/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client;

import bitel.billing.module.common.BGControlPanelContractSelect;
import bitel.billing.module.common.BGControlPanelMonth;
import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.service.CalculateService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;

public class InetCalculatePanel
extends BGUTabPanel {
    private BGControlPanelMonth period = new BGControlPanelMonth();
    private JTextField mail = new JTextField();
    private JTextField comment = new JTextField();
    private BGControlPanelContractSelect contracts = new BGControlPanelContractSelect();
    private IntTextField day;
    private JCheckBox daySelected;

    public InetCalculatePanel(ClientContext ctx) {
        super(ctx);
    }

    protected void jbInit() {
        this.setLayout(new GridBagLayout());
        JPanel monthPanel = new JPanel(new GridBagLayout());
        JPanel startPanel = new JPanel(new GridBagLayout());
        startPanel.setBorder((Border)new BGTitleBorder(" \u041f\u0443\u0441\u043a "));
        JLabel sendLabel = new JLabel();
        sendLabel.setText("\u0412\u044b\u0441\u043b\u0430\u0442\u044c \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u043d\u0430:");
        JButton startButton = new JButton();
        this.mail.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.mail.setMinimumSize(new Dimension(100, 24));
        this.mail.setPreferredSize(new Dimension(200, 24));
        this.comment.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.comment.setMinimumSize(new Dimension(100, 24));
        this.comment.setPreferredSize(new Dimension(200, 24));
        startButton.setText("\u0417\u0430\u043f\u0443\u0441\u043a");
        startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InetCalculatePanel.this.saveUserEmail(((ClientContext)InetCalculatePanel.this.getContext()).getModule(), InetCalculatePanel.this.mail.getText().trim());
                InetCalculatePanel.this.sendRecalculateRequest();
            }
        });
        this.day = new IntTextField();
        this.daySelected = new JCheckBox("\u0414\u0435\u043d\u044c");
        this.daySelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InetCalculatePanel.this.day.setEditable(InetCalculatePanel.this.daySelected.isSelected());
                InetCalculatePanel.this.day.setEnabled(InetCalculatePanel.this.daySelected.isSelected());
            }
        });
        this.daySelected.setSelected(false);
        this.day.setEditable(false);
        this.day.setEnabled(false);
        JPanel periodPanel = new JPanel(new GridBagLayout());
        periodPanel.add((Component)this.period, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        periodPanel.add((Component)this.daySelected, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        periodPanel.add((Component)this.day, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        periodPanel.setBorder((Border)new BGTitleBorder(" \u041c\u0435\u0441\u044f\u0446  "));
        this.period.setDebugGraphicsOptions(0);
        startPanel.add((Component)sendLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        startPanel.add((Component)this.mail, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 5, 0), 0, 0));
        startPanel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        startPanel.add((Component)this.comment, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 5, 0), 0, 0));
        startPanel.add(Box.createHorizontalStrut(8), new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        startPanel.add((Component)startButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        monthPanel.add((Component)periodPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(monthPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(startPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.contracts, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InetCalculatePanel.this.setData();
            }
        };
    }

    private void setData() throws BGException {
        this.mail.setText(this.getUserEmail(((ClientContext)this.getContext()).getModule()));
    }

    private void sendRecalculateRequest() {
        Date month = TimeUtils.convertLocalDateToDate((LocalDate)this.period.getLocalDate());
        Calendar cal = TimeUtils.convertDateToCalendar((Date)month);
        if (this.daySelected.isSelected() && this.day.getValue() <= 0L || this.day.getValue() > (long)cal.getActualMaximum(5)) {
            BGSwingUtilites.error((String)"\u0414\u0435\u043d\u044c \u0432\u0432\u0435\u0434\u0435\u043d \u043d\u0435\u0432\u0435\u0440\u043d\u043e");
            return;
        }
        ((CalculateService)((ClientContext)this.getContext()).getPort(CalculateService.class)).calculate(month, this.daySelected.isSelected() ? Integer.valueOf((int)this.day.getValue()) : null, this.contracts.getContracts(), this.mail.getText(), this.comment.getText());
        JOptionPane.showMessageDialog((Component)((Object)this), "\u041f\u0435\u0440\u0435\u0441\u0447\u0435\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d, \u043e\u043f\u043e\u0432\u0435\u0449\u0435\u043d\u0438\u0435 \u0431\u0443\u0434\u0435\u0442 \n\u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 EMail", "\u041f\u0435\u0440\u0435\u0441\u0447\u0435\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d", 1);
    }
}

