/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficType;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class TrafficTypePanel
extends BGUPanel {
    private InetServService inetServService = null;
    private TrafficTypeTableModel model = new TrafficTypeTableModel(TrafficTypeTableModel.class.getName());

    public TrafficTypePanel() {
        super((LayoutManager)new BorderLayout());
    }

    protected void jbInit() {
        BGUTable table = new BGUTable((TableModel)((Object)this.model));
        table.setSelectionMode(0);
        this.add(BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)table)), "Center");
        BGSwingUtilites.handleEdit((JTable)table, (AbstractBGUPanel)this);
    }

    protected JDialog getEditorDialog(TrafficType current) {
        BGTextField title = new BGTextField(30);
        title.setText(current.getTitle());
        ArrayList<IdTitle> unitData = new ArrayList<IdTitle>();
        unitData.add(new IdTitle(30000, "\u0431\u0430\u0439\u0442"));
        unitData.add(new IdTitle(20000, "\u0441\u0435\u043a\u0443\u043d\u0434\u0430"));
        BGUComboBox unit = new BGUComboBox();
        unit.setData(unitData);
        unit.setSelectedItem((Object)current.getId());
        JPanel panel = new JPanel(new GridBagLayout());
        ClientUtils.addComponentToPanel((JPanel)panel, (int)0, (Component[][])new Component[][]{{new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), title}, {new JLabel("\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f:"), unit}}, (boolean)true);
        BGOptionPane optionPane = new BGOptionPane((Object)panel, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0422\u0438\u043f\u0430 \u0442\u0440\u0430\u0444\u0438\u043a\u0430");
        JDialog dialog = optionPane.getDialog();
        ((JButton)optionPane.getOptions()[0]).addActionListener(e -> {
            current.setTitle(title.getText());
            current.setUnit(((IdTitle)unit.getSelectedItem()).getId());
            int id = 0;
            try {
                id = this.getInetServService().trafficTypeUpdate(current);
            }
            catch (BGException e1) {
                ClientUtils.showErrorMessageDialog((Throwable)e1);
            }
            this.performAction("refresh");
            this.model.setSelectedRow(id);
            dialog.setVisible(false);
            dialog.dispose();
        });
        return dialog;
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                TrafficTypePanel.this.model.setData(TrafficTypePanel.this.getInetServService().trafficTypeList());
            }
        };
        new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                TrafficTypePanel.this.getEditorDialog(new TrafficType()).setVisible(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                TrafficType trafficType = (TrafficType)TrafficTypePanel.this.model.getSelectedRow();
                if (trafficType != null && trafficType.getId() != TrafficType.TIME_ID.intValue()) {
                    TrafficTypePanel.this.getEditorDialog(trafficType).setVisible(true);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                TrafficType trafficType = (TrafficType)TrafficTypePanel.this.model.getSelectedRow();
                if (trafficType != null && trafficType.getId() != TrafficType.TIME_ID.intValue() && BGSwingUtilites.confirmDelete((String)"\u0442\u0438\u043f \u0442\u0440\u0430\u0444\u0438\u043a\u0430", (Object)trafficType)) {
                    TrafficTypePanel.this.getInetServService().trafficTypeDelete(trafficType.getId());
                    TrafficTypePanel.this.performAction("refresh");
                }
            }
        };
    }

    private InetServService getInetServService() {
        if (this.inetServService == null) {
            this.inetServService = (InetServService)((ClientContext)this.getContext()).getPort(InetServService.class);
        }
        return this.inetServService;
    }

    private class TrafficTypeTableModel
    extends BGTableModel<TrafficType> {
        public TrafficTypeTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", "title", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0415\u0434. \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f", 150, 150, 140, "unit", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(TrafficType trafficType, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("unit".equals(identifier)) {
                switch (trafficType.getUnit()) {
                    case 30000: {
                        return "\u0431\u0430\u0439\u0442";
                    }
                    case 20000: {
                        return "\u0441\u0435\u043a\u0443\u043d\u0434\u0430";
                    }
                }
                return "";
            }
            return super.getValue((Object)trafficType, column);
        }
    }
}

