/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.common.bean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlTransient;
import org.json.JSONObject;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.model.AbstractTreeNode;
import ru.bitel.common.model.Contractable;
import ru.bitel.common.model.TreeNode;

public final class InetServ
extends AbstractTreeNode<InetServ>
implements Cloneable,
TreeNode<InetServ>,
Contractable {
    private static final String PARAM_FRAMED_IP_ADDRESS = "framed_ip_address";
    private static final String PARAM_FRAMED_IPV6_ADDRESS = "framed_ipv6_address";
    private static final String PARAM_FRAMED_IPV6_ADDRESS_RESOURCE_ID = "framed_ipv6_address_resource_id";
    private static final String PARAM_FRAMED_IPV6_ADDRESS_RESOURCE_SUBSCRIPTION_ID = "framed_ipv6_address_resource_subscription_id";
    private static final String PARAM_FRAMED_IPV6_PREFIX = "framed_ipv6_prefix";
    private static final String PARAM_FRAMED_IPV6_PREFIX_LENGTH = "framed_ipv6_prefix_length";
    private static final String PARAM_FRAMED_IPV6_PREFIX_RESOURCE_ID = "framed_ipv6_prefix_resource_id";
    private static final String PARAM_FRAMED_IPV6_PREFIX_RESOURCE_SUBSCRIPTION_ID = "framed_ipv6_prefix_resource_subscription_id";
    private static final String PARAM_DELEGATED_IPV6_PREFIX = "delegated_ipv6_prefix";
    private static final String PARAM_DELEGATED_IPV6_PREFIX_LENGTH = "delegated_ipv6_prefix_length";
    private static final String PARAM_DELEGATED_IPV6_PREFIX_RESOURCE_ID = "delegated_ipv6_prefix_resource_id";
    private static final String PARAM_DELEGATED_IPV6_PREFIX_RESOURCE_SUBSCRIPTION_ID = "delegated_ipv6_prefix_resource_subscription_id";
    public static final int STATUS_ACTIVE = 0;
    public static final int STATUS_CLOSED = 1;
    public static final int STATUS_LOCKED = 2;
    public static final short STATE_NULL = -1000;
    public static final short STATE_DELETED = -1;
    public static final short STATE_DISABLE = 0;
    public static final short STATE_ENABLE = 1;
    private int contractId;
    private String contractTitle;
    private String contractComment;
    private int superContractId;
    private int typeId;
    private String typeTitle;
    private String login;
    private String password;
    private int deviceId;
    private String deviceTitle;
    private int interfaceId = -1;
    private String interfaceTitle;
    private int vlan = -1;
    private List<String> identifierList;
    private List<byte[]> macAddressList;
    private int ipResourceId;
    private int ipResourceSubscriptionId;
    private byte[] addressFrom;
    private byte[] addressTo;
    private Date dateFrom;
    private Date dateTo;
    private String data = "{}";
    private int status;
    private int sessionCountLimit;
    private String comment;
    private volatile short deviceState;
    private volatile Set<Integer> deviceOptions;
    private String accessCodeTitle;
    private int accessCode;
    private String config;
    private int contractObjectId;
    private static final Pattern macClearPattern = Pattern.compile("[\\s\\.:\\-]+");

    @XmlAttribute(name="cid")
    public int getContractId() {
        return this.contractId;
    }

    public void setContractId(int contractId) {
        this.contractId = contractId;
    }

    @XmlAttribute
    public String getContractTitle() {
        return this.contractTitle;
    }

    public void setContractTitle(String contractTitle) {
        this.contractTitle = contractTitle;
    }

    @XmlAttribute
    public String getContractComment() {
        return this.contractComment;
    }

    public void setContractComment(String contractComment) {
        this.contractComment = contractComment;
    }

    @XmlAttribute(name="scid")
    @Deprecated
    public int getSuperContractId() {
        return this.superContractId;
    }

    @Deprecated
    public void setSuperContractId(int superContractId) {
        this.superContractId = superContractId;
    }

    @XmlAttribute(name="typeId")
    public int getTypeId() {
        return this.typeId;
    }

    public void setTypeId(int inetServId) {
        this.typeId = inetServId;
    }

    @XmlAttribute
    public String getTypeTitle() {
        return this.typeTitle;
    }

    public void setTypeTitle(String servTypeTitle) {
        this.typeTitle = servTypeTitle;
    }

    @XmlAttribute(name="did")
    public int getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(int inetDeviceId) {
        this.deviceId = inetDeviceId;
    }

    @XmlAttribute
    public String getDeviceTitle() {
        return this.deviceTitle;
    }

    public void setDeviceTitle(String deviceTitle) {
        this.deviceTitle = deviceTitle;
    }

    @XmlAttribute(name="ifaceId")
    public int getInterfaceId() {
        return this.interfaceId;
    }

    public void setInterfaceId(int portId) {
        this.interfaceId = portId;
    }

    @XmlAttribute
    public String getInterfaceTitle() {
        return this.interfaceTitle;
    }

    public void setInterfaceTitle(String interfaceTitle) {
        this.interfaceTitle = interfaceTitle;
    }

    @XmlAttribute
    public int getVlan() {
        return this.vlan;
    }

    public void setVlan(int vlanId) {
        this.vlan = vlanId;
    }

    @XmlElementWrapper(name="identifierList")
    @XmlElements(value={@XmlElement(name="identifier")})
    public List<String> getIdentifierList() {
        return this.identifierList;
    }

    public void setIdentifierList(List<String> identifierList) {
        this.identifierList = identifierList;
    }

    @XmlElementWrapper(name="macList")
    @XmlElements(value={@XmlElement(name="mac")})
    public List<byte[]> getMacAddressList() {
        return this.macAddressList;
    }

    public void setMacAddressList(List<byte[]> macAddress) {
        this.macAddressList = macAddress;
    }

    @XmlTransient
    @Deprecated
    public byte[] getMacAddress() {
        return this.getMacAddressListBytes();
    }

    @XmlTransient
    public byte[] getMacAddressListBytes() {
        if (this.macAddressList == null) {
            return null;
        }
        int size = this.macAddressList.size();
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                return this.macAddressList.get(0);
            }
        }
        int length = this.macAddressList.get(0).length;
        byte[] result = new byte[length * size];
        for (int i = 0; i < size; ++i) {
            byte[] mac = this.macAddressList.get(i);
            System.arraycopy(mac, 0, result, i * length, length);
        }
        return result;
    }

    @Deprecated
    public void setMacAddress(byte[] macAddress) {
        this.setMacAddressListBytes(macAddress);
    }

    public void setMacAddressListBytes(byte[] macAddressListBytes) {
        if (macAddressListBytes == null) {
            this.setMacAddressList(Collections.emptyList());
            return;
        }
        if (macAddressListBytes.length <= 8) {
            this.setMacAddressList(Collections.singletonList(macAddressListBytes));
            return;
        }
        if (macAddressListBytes.length % 6 == 0) {
            int size = macAddressListBytes.length / 6;
            ArrayList<byte[]> macAddressList = new ArrayList<byte[]>(size);
            for (int i = 0; i < size; ++i) {
                byte[] mac = new byte[6];
                System.arraycopy(macAddressListBytes, i * 6, mac, 0, 6);
                macAddressList.add(mac);
            }
            this.setMacAddressList(macAddressList);
            return;
        }
        if (macAddressListBytes.length % 8 == 0) {
            int size = macAddressListBytes.length / 8;
            ArrayList<byte[]> macAddressList = new ArrayList<byte[]>(size);
            for (int i = 0; i < size; ++i) {
                byte[] mac = new byte[8];
                System.arraycopy(macAddressListBytes, i * 8, mac, 0, 8);
                macAddressList.add(mac);
            }
            this.setMacAddressList(macAddressList);
            return;
        }
        this.setMacAddressList(Collections.singletonList(macAddressListBytes));
    }

    @XmlAttribute(name="ipResSubsriptionId")
    public int getIpResourceSubscriptionId() {
        return this.ipResourceSubscriptionId;
    }

    public void setIpResourceSubscriptionId(int ipResourceSubscriptionId) {
        this.ipResourceSubscriptionId = ipResourceSubscriptionId;
    }

    @XmlAttribute(name="ipResId")
    public int getIpResourceId() {
        return this.ipResourceId;
    }

    public void setIpResourceId(int ipResourceId) {
        this.ipResourceId = ipResourceId;
    }

    @XmlAttribute(name="addrFrom")
    public byte[] getAddressFrom() {
        return this.addressFrom;
    }

    public void setAddressFrom(byte[] addressFrom) {
        this.addressFrom = addressFrom;
    }

    @XmlAttribute(name="addrTo")
    public byte[] getAddressTo() {
        return this.addressTo;
    }

    public void setAddressTo(byte[] addressTo) {
        this.addressTo = addressTo;
    }

    @XmlAttribute(name="uname")
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    @XmlAttribute(name="passw")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @XmlAttribute
    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    @XmlAttribute
    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    @XmlAttribute
    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @XmlAttribute(name="sessCntLimit")
    public int getSessionCountLimit() {
        return this.sessionCountLimit;
    }

    public void setSessionCountLimit(int sessions) {
        this.sessionCountLimit = sessions;
    }

    @XmlAttribute(name="devState")
    public short getDeviceState() {
        return this.deviceState;
    }

    public void setDeviceState(short currentState) {
        this.deviceState = currentState;
    }

    public String getAccessCodeTitle() {
        return this.accessCodeTitle;
    }

    public void setAccessCodeTitle(String deviceStateTitle) {
        this.accessCodeTitle = deviceStateTitle;
    }

    @XmlAttribute(name="devOpts")
    public Set<Integer> getDeviceOptions() {
        return this.deviceOptions;
    }

    public void setDeviceOptions(Set<Integer> currentInetOptionSet) {
        this.deviceOptions = currentInetOptionSet;
    }

    @XmlAttribute
    public int getAccessCode() {
        return this.accessCode;
    }

    public void setAccessCode(int accessCode) {
        this.accessCode = accessCode;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Deprecated
    public short getState() {
        short state = 0;
        if (this.status == 0) {
            state = 1;
        }
        return state;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    @XmlAttribute(name="coid")
    public int getContractObjectId() {
        return this.contractObjectId;
    }

    public void setContractObjectId(int contractObjectId) {
        this.contractObjectId = contractObjectId;
    }

    @XmlElement(name="data")
    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    @XmlAttribute(name="FramedIPAddress")
    public byte[] getFramedIPAddress() {
        return Utils.hexStringToBytes((String)this.getDataParamValue(PARAM_FRAMED_IP_ADDRESS));
    }

    public void setFramedIPAddress(byte[] address) {
        this.setDataParamValue(PARAM_FRAMED_IP_ADDRESS, Utils.bytesToHexString((byte[])address));
    }

    @XmlAttribute(name="FramedIPv6Address")
    public byte[] getFramedIPv6Address() {
        return Utils.hexStringToBytes((String)this.getDataParamValue(PARAM_FRAMED_IPV6_ADDRESS));
    }

    public void setFramedIPv6Address(byte[] address) {
        this.setDataParamValue(PARAM_FRAMED_IPV6_ADDRESS, Utils.bytesToHexString((byte[])address));
    }

    @XmlAttribute(name="FramedIPv6AddressResourceId")
    public int getFramedIPv6AddressResourceId() {
        return Utils.parseInt((String)this.getDataParamValue(PARAM_FRAMED_IPV6_ADDRESS_RESOURCE_ID));
    }

    public void setFramedIPv6AddressResourceId(int resourceId) {
        this.setDataParamValue(PARAM_FRAMED_IPV6_ADDRESS_RESOURCE_ID, String.valueOf(resourceId));
    }

    @XmlAttribute(name="FramedIPv6Prefix")
    public byte[] getFramedIPv6Prefix() {
        return Utils.hexStringToBytes((String)this.getDataParamValue(PARAM_FRAMED_IPV6_PREFIX));
    }

    public void setFramedIPv6Prefix(byte[] prefix) {
        this.setDataParamValue(PARAM_FRAMED_IPV6_PREFIX, Utils.bytesToHexString((byte[])prefix));
    }

    @XmlAttribute(name="FramedIPv6PrefixLength")
    public short getFramedIPv6PrefixLength() {
        return (short)Utils.parseInt((String)this.getDataParamValue(PARAM_FRAMED_IPV6_PREFIX_LENGTH));
    }

    public void setFramedIPv6PrefixLength(short length) {
        this.setDataParamValue(PARAM_FRAMED_IPV6_PREFIX_LENGTH, String.valueOf(length));
    }

    @XmlAttribute(name="FramedIPv6PrefixResourceId")
    public int getFramedIPv6PrefixResourceId() {
        return Utils.parseInt((String)this.getDataParamValue(PARAM_FRAMED_IPV6_PREFIX_RESOURCE_ID));
    }

    public void setFramedIPv6PrefixResourceId(int resourceId) {
        this.setDataParamValue(PARAM_FRAMED_IPV6_PREFIX_RESOURCE_ID, String.valueOf(resourceId));
    }

    @XmlAttribute(name="FramedIPv6PrefixResourceSubscriptionId")
    public int getFramedIPv6PrefixResourceSubscriptionId() {
        return Utils.parseInt((String)this.getDataParamValue(PARAM_FRAMED_IPV6_PREFIX_RESOURCE_SUBSCRIPTION_ID));
    }

    public void setFramedIPv6PrefixResourceSubscriptionId(int subscriptionId) {
        this.setDataParamValue(PARAM_FRAMED_IPV6_PREFIX_RESOURCE_SUBSCRIPTION_ID, String.valueOf(subscriptionId));
    }

    @XmlAttribute(name="DelegatedIPv6Prefix")
    public byte[] getDelegatedIPv6Prefix() {
        return Utils.hexStringToBytes((String)this.getDataParamValue(PARAM_DELEGATED_IPV6_PREFIX));
    }

    public void setDelegatedIPv6Prefix(byte[] prefix) {
        this.setDataParamValue(PARAM_DELEGATED_IPV6_PREFIX, Utils.bytesToHexString((byte[])prefix));
    }

    @XmlAttribute(name="DelegatedIPv6PrefixLength")
    public short getDelegatedIPv6PrefixLength() {
        return (short)Utils.parseInt((String)this.getDataParamValue(PARAM_DELEGATED_IPV6_PREFIX_LENGTH));
    }

    public void setDelegatedIPv6PrefixLength(short length) {
        this.setDataParamValue(PARAM_DELEGATED_IPV6_PREFIX_LENGTH, String.valueOf(length));
    }

    @XmlAttribute(name="DelegatedIPv6PrefixResourceId")
    public int getDelegatedIPv6PrefixResourceId() {
        return Utils.parseInt((String)this.getDataParamValue(PARAM_DELEGATED_IPV6_PREFIX_RESOURCE_ID));
    }

    public void setDelegatedIPv6PrefixResourceId(int resourceId) {
        this.setDataParamValue(PARAM_DELEGATED_IPV6_PREFIX_RESOURCE_ID, String.valueOf(resourceId));
    }

    @XmlAttribute(name="DelegatedIPv6PrefixResourceSubscriptionId")
    public int getDelegatedIPv6PrefixResourceSubscriptionId() {
        return Utils.parseInt((String)this.getDataParamValue(PARAM_DELEGATED_IPV6_PREFIX_RESOURCE_SUBSCRIPTION_ID));
    }

    public void setDelegatedIPv6PrefixResourceSubscriptionId(int subscriptionId) {
        this.setDataParamValue(PARAM_DELEGATED_IPV6_PREFIX_RESOURCE_SUBSCRIPTION_ID, String.valueOf(subscriptionId));
    }

    private String getDataParamValue(String paramName) {
        String value = null;
        if (this.data != null && !this.data.isEmpty()) {
            value = new JSONObject(this.data).optString(paramName);
        }
        return value;
    }

    private void setDataParamValue(String paramName, String value) {
        JSONObject json = new JSONObject(this.data == null || this.data.isEmpty() ? "{}" : this.data);
        json.put(paramName, (Object)value);
        this.data = json.toString();
    }

    public InetServ clone() {
        try {
            return (InetServ)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public String toString() {
        return this.title;
    }

    public static String toString(InetServ val) {
        StringBuilder data = new StringBuilder();
        if (Utils.notBlankString((String)val.getLogin())) {
            data.append("\u041b\u043e\u0433\u0438\u043d: ");
            data.append(val.getLogin());
        }
        if (Utils.notBlankString((String)val.getInterfaceTitle())) {
            if (data.length() > 0) {
                data.append("; ");
            }
            data.append("\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441: ");
            data.append(val.getInterfaceTitle());
        }
        if (val.getAddressFrom() != null || val.getAddressTo() != null) {
            if (data.length() > 0) {
                data.append("; ");
            }
            data.append("\u0410\u0434\u0440\u0435\u0441(\u0430): ");
            IpAddress from = new IpAddress(val.getAddressFrom());
            IpAddress to = new IpAddress(val.getAddressTo());
            if (val.getAddressTo() == null) {
                data.append(from.toString());
            } else {
                data.append(from.toString());
                data.append("-");
                data.append(to.toString());
            }
        }
        return data.toString();
    }

    public static byte[] parseMacAddress(String macAddress) {
        if (Utils.isBlankString((String)macAddress)) {
            return null;
        }
        if (macAddress.charAt(1) == ':' || macAddress.charAt(2) == ':') {
            return InetServ.semicolonedMacToBytes(macAddress);
        }
        macAddress = macClearPattern.matcher(macAddress).replaceAll("");
        return InetServ.toBytes(macAddress);
    }

    public static String macAddressToString(byte[] macAddress) {
        if (macAddress == null || macAddress.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(macAddress.length * 3);
        int size = macAddress.length;
        for (int i = 0; i < size; ++i) {
            sb.append(Utils.HEX[(macAddress[i] & 0xF0) >> 4]);
            sb.append(Utils.HEX[macAddress[i] & 0xF]);
            sb.append(':');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private static byte[] toBytes(String s) {
        byte[] result;
        int i;
        int j;
        if (Utils.isBlankString((String)s)) {
            return null;
        }
        int size = s.length();
        if (size % 2 == 0) {
            j = 0;
            i = 0;
            result = new byte[size / 2];
        } else {
            j = 1;
            i = 1;
            result = new byte[size / 2 + 1];
            int digit2 = Character.digit(s.charAt(0), 16);
            result[0] = (byte)digit2;
        }
        while (i < size) {
            int digit1 = Character.digit(s.charAt(i++), 16);
            int digit2 = Character.digit(s.charAt(i++), 16);
            result[j++] = (byte)(digit1 * 16 + digit2);
        }
        return result;
    }

    private static byte[] semicolonedMacToBytes(String s) {
        if (Utils.isBlankString((String)s)) {
            return null;
        }
        int size = s.length();
        int i = 0;
        int j = 0;
        byte[] result = new byte[6];
        while (i < size && j < 6) {
            if (s.charAt(i) == ':') {
                ++i;
                continue;
            }
            int digit1 = Character.digit(s.charAt(i++), 16);
            if (i >= size || s.charAt(i) == ':') {
                result[j++] = (byte)digit1;
                continue;
            }
            int digit2 = Character.digit(s.charAt(i++), 16);
            result[j++] = (byte)(digit1 * 16 + digit2);
        }
        return result;
    }
}

