/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.common.event.manage;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import ru.bitel.bgbilling.kernel.event.PartitionedQueueEvent;

@XmlRootElement
public class InetDeviceManageEvent
extends PartitionedQueueEvent {
    @XmlAttribute
    private final int deviceId;
    @XmlAttribute
    private final int inetDeviceId;
    @XmlAttribute
    private final String operation;
    @XmlAttribute
    private final int servId;
    @XmlAttribute
    private final int connectionId;
    private Object result;
    private static final String packageName = InetDeviceManageEvent.class.getPackage().getName();

    protected InetDeviceManageEvent() {
        this.deviceId = -1;
        this.inetDeviceId = -1;
        this.operation = null;
        this.servId = -1;
        this.connectionId = -1;
    }

    public InetDeviceManageEvent(int moduleId, int userId, int invDeviceId, String operation, int servId, int connectionId) {
        this(moduleId, userId, invDeviceId, 0, operation, servId, connectionId);
    }

    public InetDeviceManageEvent(int moduleId, int userId, int invDeviceId, int inetDeviceId, String operation, int servId, int connectionId) {
        super(moduleId, CONTRACT_GLOBAL, userId);
        this.deviceId = invDeviceId;
        this.inetDeviceId = inetDeviceId;
        this.operation = operation;
        this.servId = servId;
        this.connectionId = connectionId;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("deviceId", this.deviceId);
        message.setIntProperty("inetDeviceId", this.inetDeviceId);
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public int getServId() {
        return this.servId;
    }

    public String getOperation() {
        return this.operation;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    protected void toString(StringBuilder sb) {
        sb.append("; deviceId: ");
        sb.append(this.deviceId);
        sb.append("; inetDeviceId: ");
        sb.append(this.inetDeviceId);
        sb.append("; operation: ");
        sb.append(this.operation);
    }

    protected String getPackageName() {
        return packageName;
    }

    protected int getPartitionValue() {
        return this.deviceId;
    }
}

