/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.proccess.create;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.create.SessionCreateTask;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.DataProcessRecord;
import ru.bitel.bgbilling.modules.inet.server.bean.DataProcessRecordDao;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.PeriodicalTaskRunner;

public class InetCreateSessionProcessor
extends PeriodicalTaskRunner<SessionCreateTask> {
    protected final int moduleId;
    private InetDeviceRuntime rootDevice = null;

    public InetCreateSessionProcessor(Setup setup, int threadCount, long initialDelay, long delay, int moduleId, Accounting accounting) {
        super(setup, threadCount, initialDelay, delay, accounting.rootDeviceId, "create_sessions");
        this.moduleId = moduleId;
        this.rootDevice = accounting.deviceMap.get(accounting.rootDeviceId);
    }

    protected List<SessionCreateTask> readTasks() throws BGException {
        ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);
        Connection con = connectionSet.getConnection();
        try {
            ArrayList<SessionCreateTask> arrayList;
            try (DataProcessRecordDao dao = new DataProcessRecordDao(con, this.moduleId);){
                ArrayList<SessionCreateTask> result = new ArrayList<SessionCreateTask>();
                List<Object> dataList = new ArrayList();
                Date startTime = new Date();
                HashSet<Integer> descendantIds = new HashSet<Integer>(this.rootDevice.descendantIds);
                descendantIds.add(this.rootDevice.inetDeviceId);
                dataList = dao.list(2, descendantIds);
                for (DataProcessRecord dataProcessRecord : dataList) {
                    dataProcessRecord.setStartTime(startTime);
                    dao.update(dataProcessRecord);
                    SessionCreateTask runTask = new SessionCreateTask(dataProcessRecord, this.setup, this.rootDevice.inetDeviceId);
                    result.add(runTask);
                }
                arrayList = result;
            }
            return arrayList;
        }
        finally {
            connectionSet.recycle();
        }
    }
}

