/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.recalculate;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.SessionTarifficationManager;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.DetailRecord;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.InetConnectionRecalculateRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.RecalculateDAO;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.SessionRecalculateTarifficationManager;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.TrafficMaxRecalculateManager;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.TrafficRangeRecalculateManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.tariff.server.range.RangeRecalculateManager;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeEntry;
import ru.bitel.bgbilling.modules.inet.common.bean.AccountingTrafficAmount;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLog;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionLogDao;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxEntry;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.sql.ConnectionSet;

public class RecalculateTask
implements Callable<Object> {
    private static final Logger logger = LogManager.getLogger();
    Queue<DetailRecord> recordQueue = new ConcurrentLinkedQueue<DetailRecord>();
    protected ConcurrentMap<Long, InetSessionLog> sessionMap = new ConcurrentHashMap<Long, InetSessionLog>();
    final InetServRuntimeMap inetServRuntimeMap;
    final InetDeviceRuntimeMap deviceRuntimeMap;
    protected SessionRecalculateTarifficationManager sessionRecalculateTarifficationManager;
    protected TrafficMaxRecalculateManager maxRecalculateManager;
    protected RangeRecalculateManager rangeRecalculateManager;
    protected Accounting accounting;
    protected final Date dateFrom;
    protected final Date dateTo;
    final Set<Integer> affectedContracts;
    protected int roundingScale;
    protected RoundingMode roundingMode;
    protected Set<Long> affectedSessionsForContract = new HashSet<Long>();
    protected Map<Integer, BigDecimal> accountMapForContract = new HashMap<Integer, BigDecimal>();
    protected Map<Long, InetConnectionRuntime> connectionMapForContract = new HashMap<Long, InetConnectionRuntime>();
    SortedSet<Long> connectionForHour = new TreeSet<Long>();
    SortedSet<Long> connectionForDay = new TreeSet<Long>();
    protected InetTariffWorkerContext workerContext;
    protected RecalculateDAO recalculateDAO;
    protected Set<Integer> loadContractSet = new HashSet<Integer>();
    private final SessionTarifficationManager sessionTarifficationManager;
    protected boolean needSlaveForSessionRead = true;

    public RecalculateTask(SessionRecalculateTarifficationManager sessionRecalculateTarifficationManager, Accounting accounting) throws SQLException {
        this.inetServRuntimeMap = accounting.inetServRuntimeMap;
        this.deviceRuntimeMap = accounting.deviceMap;
        this.sessionRecalculateTarifficationManager = sessionRecalculateTarifficationManager;
        this.accounting = accounting;
        this.dateFrom = sessionRecalculateTarifficationManager.dateFrom;
        this.dateTo = sessionRecalculateTarifficationManager.dateTo;
        this.affectedContracts = sessionRecalculateTarifficationManager.affectedContracts;
        this.sessionTarifficationManager = new SessionTarifficationManager(accounting);
    }

    protected void createRecalculateDAO(Accounting accounting, Connection con) throws SQLException {
        this.recalculateDAO = new RecalculateDAO(this.dateFrom, this.dateTo, accounting.moduleId, con);
        this.recalculateDAO.init();
    }

    void addRecord(DetailRecord record) {
        this.recordQueue.add(record);
        this.loadContractSet.add(record.getContractId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws Exception {
        try {
            int currentDay = -1;
            int currentHour = -1;
            this.workerContext = (InetTariffWorkerContext)ServerContext.get();
            ConnectionSet connectionSet = this.workerContext.getConnectionSet();
            this.createRecalculateDAO(this.accounting, connectionSet.getConnection());
            this.initMaxAndRangeManagers(connectionSet);
            this.loadSessionMap();
            int currentContractId = -1;
            Calendar calendar = TimeUtils.convertDateToCalendar((Date)this.dateFrom);
            Iterator it = this.recordQueue.iterator();
            while (it.hasNext()) {
                InetConnectionRuntime connectionRuntime;
                InetConnectionRuntime connection;
                DetailRecord record = (DetailRecord)it.next();
                it.remove();
                InetSessionLog session = (InetSessionLog)this.sessionMap.get(record.getSessionId());
                if (session == null) {
                    logger.warn("Session not found with id=" + record.getSessionId());
                    continue;
                }
                InetServRuntime servRuntime = this.inetServRuntimeMap.get(session.getServId());
                if (servRuntime == null) {
                    logger.warn("servRuntime not found with id=" + session.getServId());
                    continue;
                }
                InetDeviceRuntime deviceRuntime = this.deviceRuntimeMap.get(session.getDeviceId());
                if (deviceRuntime == null) {
                    logger.warn("deviceRuntime not found with id=" + session.getDeviceId());
                    continue;
                }
                boolean calculated = false;
                boolean maxTrafsUpdated = false;
                boolean sessionFlushed = false;
                if (currentContractId > 0 && currentContractId != record.getContractId()) {
                    this.nextContract(connectionSet, currentDay, currentContractId, currentHour);
                    calculated = true;
                    maxTrafsUpdated = true;
                    sessionFlushed = true;
                    this.connectionForHour.clear();
                }
                if (currentDay != record.getDay() && currentDay >= 0) {
                    if (!calculated) {
                        for (Long l : this.connectionForHour) {
                            connection = this.connectionMapForContract.get(l);
                            this.tarificateSessionHour(connection, connectionSet, currentDay, currentHour);
                        }
                        for (Long l : this.connectionForDay) {
                            connection = this.connectionMapForContract.get(l);
                            this.flushSession(connectionSet.getConnection(), connection);
                        }
                        calculated = true;
                        sessionFlushed = true;
                        this.connectionForHour.clear();
                        this.connectionForDay.clear();
                    }
                    if (!maxTrafsUpdated) {
                        this.maxRecalculateManager.flushDay(currentContractId, currentDay);
                        this.rangeRecalculateManager.flushDay(currentContractId, currentDay);
                    }
                }
                if (currentHour != record.getHour() && currentHour >= 0) {
                    if (!calculated) {
                        for (Long l : this.connectionForHour) {
                            connection = this.connectionMapForContract.get(l);
                            this.tarificateSessionHour(connection, connectionSet, currentDay, currentHour);
                        }
                        calculated = true;
                    }
                    this.connectionForHour.clear();
                }
                if ((connectionRuntime = this.connectionMapForContract.get(record.getConnectionId())) == null) {
                    servRuntime.lock();
                    try {
                        connectionRuntime = this.createConnectionRuntime(session, servRuntime);
                    }
                    finally {
                        servRuntime.unlock();
                    }
                }
                this.connectionForHour.add(record.getConnectionId());
                this.connectionForDay.add(record.getConnectionId());
                if (connectionRuntime.sessionId != record.getSessionId()) {
                    if (!this.affectedSessionsForContract.contains(connectionRuntime.sessionId)) {
                        if (!calculated) {
                            for (Long conId2 : this.connectionForHour) {
                                InetConnectionRuntime connection2 = this.connectionMapForContract.get(conId2);
                                this.tarificateSessionHour(connection2, connectionSet, currentDay, currentHour);
                            }
                            this.connectionForHour.clear();
                            calculated = true;
                        }
                        if (!sessionFlushed) {
                            this.flushSession(connectionSet.getConnection(), connectionRuntime);
                            sessionFlushed = true;
                        }
                    }
                    connectionRuntime.inetServRuntime.lock();
                    try {
                        connectionRuntime.setSession(this.accounting, session.toSession());
                        connectionRuntime.setAccountingPeriod(this.accounting, connectionSet, session.getSessionStart().getTime(), false);
                    }
                    finally {
                        connectionRuntime.inetServRuntime.unlock();
                    }
                }
                HashMap<Integer, AccountingTrafficAmount> hashMap = new HashMap<Integer, AccountingTrafficAmount>();
                hashMap.put(record.getTrafficTypeId(), new AccountingTrafficAmount(record.getAmount()));
                calendar.set(5, record.getDay());
                calendar.set(11, record.getHour());
                TimeUtils.clear_MIN_MIL_SEC((Calendar)calendar);
                long hourMillis = calendar.getTimeInMillis();
                try {
                    connectionRuntime.inetServRuntime.lock();
                    connectionRuntime.addTraffics(0, hourMillis, hashMap);
                }
                finally {
                    connectionRuntime.inetServRuntime.unlock();
                }
                currentContractId = record.getContractId();
                currentDay = record.getDay();
                currentHour = record.getHour();
                this.connectionMapForContract.put(record.getConnectionId(), connectionRuntime);
            }
            this.nextContract(connectionSet, currentDay, currentContractId, currentHour);
        }
        catch (Exception ex) {
            try {
                logger.error("", (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.sessionMap.clear();
                for (Integer contractId : this.loadContractSet) {
                    this.accounting.tariffContext.maxTrafficManager.removeTrafficMaxEntry(contractId);
                    this.accounting.tariffContext.rangedTrafficManager.removeRangedTrafficEntry(contractId.intValue());
                    List<InetServRuntime> servs = this.inetServRuntimeMap.getForContractId(contractId);
                    for (InetServRuntime serv : servs) {
                        this.inetServRuntimeMap.removeRuntime(serv.inetServId);
                    }
                }
                this.recalculateDAO.recycle();
                this.maxRecalculateManager.close();
                this.rangeRecalculateManager.close();
                throw throwable;
            }
            this.sessionMap.clear();
            for (Integer contractId : this.loadContractSet) {
                this.accounting.tariffContext.maxTrafficManager.removeTrafficMaxEntry(contractId);
                this.accounting.tariffContext.rangedTrafficManager.removeRangedTrafficEntry(contractId.intValue());
                List<InetServRuntime> servs = this.inetServRuntimeMap.getForContractId(contractId);
                for (InetServRuntime serv : servs) {
                    this.inetServRuntimeMap.removeRuntime(serv.inetServId);
                }
            }
            this.recalculateDAO.recycle();
            this.maxRecalculateManager.close();
            this.rangeRecalculateManager.close();
        }
        this.sessionMap.clear();
        for (Integer contractId : this.loadContractSet) {
            this.accounting.tariffContext.maxTrafficManager.removeTrafficMaxEntry(contractId);
            this.accounting.tariffContext.rangedTrafficManager.removeRangedTrafficEntry(contractId.intValue());
            List<InetServRuntime> servs = this.inetServRuntimeMap.getForContractId(contractId);
            for (InetServRuntime serv : servs) {
                this.inetServRuntimeMap.removeRuntime(serv.inetServId);
            }
        }
        this.recalculateDAO.recycle();
        this.maxRecalculateManager.close();
        this.rangeRecalculateManager.close();
        return null;
    }

    protected void initMaxAndRangeManagers(ConnectionSet connectionSet) throws SQLException {
        this.maxRecalculateManager = new TrafficMaxRecalculateManager(connectionSet.getConnection(), this.dateFrom, this.dateTo, this.accounting.moduleId, this.sessionRecalculateTarifficationManager.accounting.tariffContext.maxTrafficManager);
        this.rangeRecalculateManager = new TrafficRangeRecalculateManager(connectionSet.getConnection(), this.dateFrom, this.dateTo, this.accounting.moduleId, this.sessionRecalculateTarifficationManager.accounting.tariffContext.rangedTrafficManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetConnectionRuntime createConnectionRuntime(InetSessionLog session, InetServRuntime servRuntime) throws BGException {
        InetConnectionRecalculateRuntime connectionRuntime;
        try {
            InetConnectionRuntime parentConnection;
            servRuntime.lock();
            connectionRuntime = new InetConnectionRecalculateRuntime(this.accounting, servRuntime, session);
            long parentConnectionId = connectionRuntime.connection.getParentConnectionId();
            if (parentConnectionId > 0L && (parentConnection = this.connectionMapForContract.get(parentConnectionId)) != null) {
                connectionRuntime.sessionDeviceState = parentConnection.sessionDeviceState;
            }
        }
        finally {
            servRuntime.unlock();
        }
        return connectionRuntime;
    }

    private void tarificateSessionHour(InetConnectionRuntime connectionRuntime, ConnectionSet connectionSet, int day, int hour) {
        Calendar calendar = TimeUtils.convertDateToCalendar((Date)this.dateFrom);
        calendar.set(5, day);
        calendar.set(11, hour);
        TimeUtils.clear_MIN_MIL_SEC((Calendar)calendar);
        long hourMillis = calendar.getTimeInMillis();
        this.sessionTarifficationManager.tarifficate(connectionSet, this.workerContext, connectionRuntime, hourMillis, false, 0L, false);
        connectionRuntime.trafficsDelta.clear();
    }

    private boolean flushSession(Connection con, InetConnectionRuntime connectionRuntime) throws BGException {
        this.detectRounding(connectionRuntime.sessionId);
        connectionRuntime.inetServRuntime.lock();
        try {
            InetConnection connection = connectionRuntime.connection;
            if (connection == null) {
                boolean bl = false;
                return bl;
            }
            int contractId = connectionRuntime.contractId;
            BigDecimal accountSum = this.recalculateDAO.flushSessisonAccount(connectionRuntime, contractId, this.roundingScale, this.roundingMode, this.accountMapForContract);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(new Date(connectionRuntime.sessionStartTime));
            BigDecimal sessionCostDelta = connectionRuntime.sessionCostDelta.setScale(this.roundingScale, this.roundingMode);
            connectionRuntime.sessionCostDelta = connectionRuntime.sessionCostDelta.subtract(sessionCostDelta);
            InetSessionLog session = (InetSessionLog)this.sessionMap.get(connectionRuntime.sessionId);
            this.recalculateDAO.updateSessionCostAndTime(connectionRuntime, accountSum, this.roundingScale, this.roundingMode, session);
            this.affectedSessionsForContract.add(connectionRuntime.sessionId);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        finally {
            connectionRuntime.inetServRuntime.unlock();
        }
        return true;
    }

    protected void detectRounding(long sessionId) {
        this.roundingScale = 5;
        this.roundingMode = RoundingMode.HALF_EVEN;
    }

    protected void nextContract(ConnectionSet connectionSet, int currentDay, int currentContractId, int currentHour) throws BGException, SQLException {
        List<InetServRuntime> servs;
        TrafficRangeEntry trafficRangeEntry;
        InetConnectionRuntime connection;
        if (currentContractId <= 0) {
            return;
        }
        for (Long conId : this.connectionForHour) {
            connection = this.connectionMapForContract.get(conId);
            this.tarificateSessionHour(connection, connectionSet, currentDay, currentHour);
        }
        for (Long conId : this.connectionForDay) {
            connection = this.connectionMapForContract.get(conId);
            this.flushSession(connectionSet.getConnection(), connection);
        }
        int superContractId = 0;
        ContractRuntime contractRuntime = this.accounting.contractRuntimeMap.getContractRuntime(connectionSet, Integer.valueOf(currentContractId));
        if (contractRuntime != null) {
            superContractId = contractRuntime.getSuperContractId();
        } else {
            logger.error("ContractRuntime was not found for id = " + currentContractId);
        }
        Calendar calendar = TimeUtils.convertDateToCalendar((Date)this.dateFrom);
        int yy = calendar.get(1);
        int mm = calendar.get(2) + 1;
        this.recalculateDAO.flushContract(currentContractId, superContractId, yy, mm, this.affectedSessionsForContract, this.accountMapForContract, this.sessionRecalculateTarifficationManager.getInetServiceSet());
        this.affectedContracts.add(currentContractId);
        BalanceDao balanceDao = new BalanceDao(connectionSet.getConnection());
        this.updateContractBalance(balanceDao, currentContractId, superContractId, yy, mm);
        balanceDao.recycle();
        this.maxRecalculateManager.flushDay(currentContractId, currentDay);
        this.maxRecalculateManager.flushContract(currentContractId);
        this.rangeRecalculateManager.flushDay(currentContractId, currentDay);
        this.rangeRecalculateManager.flushContract(currentContractId);
        this.accountMapForContract.clear();
        this.connectionMapForContract.clear();
        this.affectedSessionsForContract.clear();
        TrafficMaxEntry trafficMaxEntry = this.accounting.tariffContext.maxTrafficManager.getTrafficMaxEntry(currentContractId);
        if (trafficMaxEntry != null) {
            trafficMaxEntry.entrySet().clear();
        }
        if ((trafficRangeEntry = this.accounting.tariffContext.rangedTrafficManager.getRangedTrafficEntry(currentContractId)) != null) {
            trafficRangeEntry.entrySet().clear();
        }
        if ((servs = this.accounting.inetServRuntimeMap.getForContractId(currentContractId)) != null) {
            for (InetServRuntime serv : servs) {
                this.accounting.inetServRuntimeMap.removeRuntime(serv.inetServId);
            }
        }
        this.connectionForHour.clear();
        this.connectionForDay.clear();
        this.connectionForHour.clear();
        this.connectionForDay.clear();
    }

    protected void updateContractBalance(BalanceDao balanceDao, int contractId, int superContractId, int yy, int mm) throws BGException {
        BigDecimal balanceAccount = balanceDao.setBalanceAccount(contractId, superContractId, yy, mm);
        this.accounting.balanceEP.publish((Event)new ContractBalanceChangedEvent(contractId, 2, yy, mm, balanceAccount));
    }

    protected void loadSessionMap() throws BGException {
        ConnectionSet connectionSet = this.workerContext.getConnectionSet();
        Connection conForLoad = this.needSlaveForSessionRead ? connectionSet.getSlaveConnection() : connectionSet.getConnection();
        InetSessionLogDao inetSessionLogDao = new InetSessionLogDao(conForLoad, this.accounting.moduleId, this.dateFrom);
        List<InetSessionLog> sessionList = inetSessionLogDao.listForContracts(this.loadContractSet, this.dateFrom, this.dateTo);
        for (InetSessionLog session : sessionList) {
            Long sessionId = session.getId();
            this.sessionMap.put(sessionId, session);
        }
    }
}

