/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.recalculate;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.SessionRecalculateTarifficationManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMax;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxEntry;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxKey;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class TrafficMaxRecalculateManager
implements AutoCloseable {
    private static final Logger logger = LogManager.getLogger();
    protected int moduleId;
    protected Connection con;
    protected Date dateFrom;
    protected Date dateTo;
    private PreparedStatement insertMaxTraffsDetailPS;
    private PreparedStatement updateMaxTraffsDetailPS;
    private PreparedStatement insertMaxTraffsPS;
    private PreparedStatement updateMaxTraffsPS;
    private Set<Integer> affectedDaysForContract = new HashSet<Integer>();
    private Set<Integer> affectedContracts = new HashSet<Integer>();
    protected TrafficMaxManager manager;
    protected final String trafficMaxTableName;
    protected final String trafficMaxDetailTableName;

    public TrafficMaxRecalculateManager(Connection con, Date dateFrom, Date dateTo, int moduleId, TrafficMaxManager manager) throws SQLException {
        this.con = con;
        this.dateFrom = dateFrom;
        this.dateTo = dateTo;
        this.moduleId = moduleId;
        this.manager = manager;
        this.trafficMaxTableName = ServerUtils.getModuleTableName((String)"inet_tariff_traffic_max", (int)moduleId);
        this.trafficMaxDetailTableName = ServerUtils.getModuleMonthTableName((String)"inet_tariff_traffic_max_detail", (Date)dateFrom, (int)moduleId);
        this.init();
    }

    private void init() throws SQLException {
        this.updateMaxTraffsPS = this.con.prepareStatement("UPDATE " + this.trafficMaxTableName + " SET amountMax = ? , amount1 = ?, amount2 = ?, counter = counter + 1 WHERE contractId = ? AND treeNodeId = ? AND maxKey = ?  AND yy =? AND mm=? AND  (@counter:=counter) IS NOT NULL");
        this.insertMaxTraffsPS = this.con.prepareStatement("INSERT INTO " + this.trafficMaxTableName + " ( contractId, treeNodeId, maxKey, amountMax, amount1, amount2, yy, mm, counter )  VALUES (?,?,?,?,?,?,?,?,1)");
    }

    public void flushDay(int contractId, int day) throws SQLException {
        if (this.insertMaxTraffsDetailPS == null) {
            this.insertMaxTraffsDetailPS = this.con.prepareStatement("INSERT INTO " + this.trafficMaxDetailTableName + " ( contractId, treeNodeId, maxKey, day, amountMax, amount1, amount2  )  VALUES (?,?,?,?,?,?,?)");
        }
        if (this.updateMaxTraffsDetailPS == null) {
            this.updateMaxTraffsDetailPS = this.con.prepareStatement("UPDATE " + this.trafficMaxDetailTableName + " SET  amountMax = ?, amount1 = ?, amount2 = ?   WHERE  contractId = ? AND treeNodeId = ? AND maxKey = ? AND day = ?");
        }
        this.affectedDaysForContract.add(day);
        TrafficMaxEntry trafficMaxEntry = this.manager.getTrafficMaxEntry(contractId);
        HashSet<Long> affectedTreenodes = new HashSet<Long>();
        HashSet<Long> affectedKeys = new HashSet<Long>();
        if (trafficMaxEntry != null) {
            TrafficMax value;
            TrafficMaxKey key;
            HashMap<TrafficMaxKey, TrafficMax> maxTrafsMap = new HashMap<TrafficMaxKey, TrafficMax>();
            for (Map.Entry<TrafficMaxKey, TrafficMax> entry : trafficMaxEntry.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                long delta1 = value.delta1;
                long delta2 = value.delta2;
                long deltaMax = value.deltaMax;
                if (delta1 == 0L && delta2 == 0L && deltaMax == 0L) continue;
                this.addDeltaToMap(maxTrafsMap, key, value);
                value.deltaMax = 0L;
                value.delta1 = 0L;
                value.delta2 = 0L;
                trafficMaxEntry.delta = false;
            }
            for (Map.Entry<TrafficMaxKey, TrafficMax> entry : maxTrafsMap.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                if (value.amount1 == 0L && value.amount2 == 0L && value.deltaMax == 0L) continue;
                affectedTreenodes.add(key.getTreeNodeId());
                affectedKeys.add(key.getKey());
                int idx = 1;
                this.updateMaxTraffsDetailPS.setLong(idx++, value.amountMax);
                this.updateMaxTraffsDetailPS.setLong(idx++, value.amount1);
                this.updateMaxTraffsDetailPS.setLong(idx++, value.amount2);
                this.updateMaxTraffsDetailPS.setInt(idx++, contractId);
                this.updateMaxTraffsDetailPS.setLong(idx++, key.getTreeNodeId());
                this.updateMaxTraffsDetailPS.setLong(idx++, key.getKey());
                this.updateMaxTraffsDetailPS.setInt(idx++, day);
                if (this.updateMaxTraffsDetailPS.executeUpdate() != 0) continue;
                idx = 1;
                this.insertMaxTraffsDetailPS.setInt(idx++, contractId);
                this.insertMaxTraffsDetailPS.setLong(idx++, key.getTreeNodeId());
                this.insertMaxTraffsDetailPS.setLong(idx++, key.getKey());
                this.insertMaxTraffsDetailPS.setInt(idx++, day);
                this.insertMaxTraffsDetailPS.setLong(idx++, value.amountMax);
                this.insertMaxTraffsDetailPS.setLong(idx++, value.amount1);
                this.insertMaxTraffsDetailPS.setLong(idx++, value.amount2);
                this.insertMaxTraffsDetailPS.executeUpdate();
            }
        }
        if (affectedTreenodes.size() == 0) {
            affectedTreenodes.add(-1L);
        }
        if (affectedKeys.size() == 0) {
            affectedKeys.add(-1L);
        }
        PreparedStatement deleteInvalidMaxTraffsDetailForContractAndDayPS = this.con.prepareStatement(" DELETE FROM " + this.trafficMaxDetailTableName + " WHERE contractId = ?  AND day = ? AND  ( treenodeId not in (" + Utils.toString(affectedTreenodes) + ") OR maxKey not in (" + Utils.toString(affectedKeys) + ") ) ");
        int idx = 1;
        deleteInvalidMaxTraffsDetailForContractAndDayPS.setInt(idx++, contractId);
        deleteInvalidMaxTraffsDetailForContractAndDayPS.setInt(idx++, day);
        deleteInvalidMaxTraffsDetailForContractAndDayPS.executeUpdate();
        deleteInvalidMaxTraffsDetailForContractAndDayPS.close();
    }

    public void flushContract(int contractId) throws SQLException, BGException {
        HashSet<Long> affectedKeys = new HashSet<Long>();
        HashSet<Long> affectedNodes = new HashSet<Long>();
        TrafficMaxEntry trafficMaxEntry = this.manager.getTrafficMaxEntry(contractId);
        if (trafficMaxEntry != null) {
            for (Map.Entry<TrafficMaxKey, TrafficMax> entry : trafficMaxEntry.entrySet()) {
                TrafficMaxKey key = entry.getKey();
                TrafficMax value = entry.getValue();
                if (value.amount1 == 0L && value.amount2 == 0L && value.deltaMax == 0L) continue;
                affectedKeys.add(key.getKey());
                affectedNodes.add(key.getTreeNodeId());
                this.updateMaxTraffic(contractId, key, value);
            }
        }
        if (affectedNodes.size() == 0) {
            affectedNodes.add(-1L);
        }
        if (affectedKeys.size() == 0) {
            affectedKeys.add(-1L);
        }
        this.deleteInvalidMaxTraffs(contractId, affectedKeys, affectedNodes);
        this.deleteMaxTraffsDetailForInvalidDays(contractId);
        this.affectedContracts.add(contractId);
        this.affectedDaysForContract.clear();
    }

    protected void deleteInvalidMaxTraffs(int contractId, Set<Long> affectedKeys, Set<Long> affectedNodes) throws SQLException {
        int yy = TimeUtils.convertDateToCalendar((Date)this.dateFrom).get(1);
        int mm = TimeUtils.convertDateToCalendar((Date)this.dateFrom).get(2) + 1;
        int idx = 1;
        PreparedStatement deleteInvalidMaxTraffsForContractPS = this.con.prepareStatement("DELETE FROM " + this.trafficMaxTableName + " WHERE contractId=?  AND yy = ? AND mm = ?  AND ( treeNodeId NOT IN (" + Utils.toString(affectedNodes) + ")  OR maxKey not IN(" + Utils.toString(affectedKeys) + ") )");
        deleteInvalidMaxTraffsForContractPS.setInt(idx++, contractId);
        deleteInvalidMaxTraffsForContractPS.setInt(idx++, yy);
        deleteInvalidMaxTraffsForContractPS.setInt(idx++, mm);
        deleteInvalidMaxTraffsForContractPS.executeUpdate();
        deleteInvalidMaxTraffsForContractPS.close();
    }

    protected void deleteMaxTraffsDetailForInvalidDays(int contractId) throws SQLException {
        PreparedStatement deleteInvalidMaxTraffsDetailForContract = this.con.prepareStatement(" DELETE FROM " + this.trafficMaxDetailTableName + " WHERE contractId = ?  AND day NOT IN(" + Utils.toString(this.affectedDaysForContract) + ")  AND day >= ? AND day <=? ");
        Calendar calFrom = TimeUtils.convertDateToCalendar((Date)this.dateFrom);
        Calendar calTo = TimeUtils.convertDateToCalendar((Date)this.dateTo);
        int dayFrom = calFrom.get(5);
        int dayTo = TimeUtils.monthsDelta((Date)this.dateFrom, (Date)this.dateTo) == 0 ? calTo.get(5) - 1 : calFrom.getActualMaximum(5);
        int idx = 1;
        deleteInvalidMaxTraffsDetailForContract.setInt(idx++, contractId);
        deleteInvalidMaxTraffsDetailForContract.setInt(idx++, dayFrom);
        deleteInvalidMaxTraffsDetailForContract.setInt(idx++, dayTo);
        deleteInvalidMaxTraffsDetailForContract.executeUpdate();
        deleteInvalidMaxTraffsDetailForContract.close();
    }

    protected void updateMaxTraffic(int contractId, TrafficMaxKey key, TrafficMax value) throws SQLException {
        int yy = TimeUtils.convertDateToCalendar((Date)this.dateFrom).get(1);
        int mm = TimeUtils.convertDateToCalendar((Date)this.dateFrom).get(2) + 1;
        int idx = 1;
        this.updateMaxTraffsPS.setLong(idx++, value.amountMax);
        this.updateMaxTraffsPS.setLong(idx++, value.amount1);
        this.updateMaxTraffsPS.setLong(idx++, value.amount2);
        this.updateMaxTraffsPS.setInt(idx++, contractId);
        this.updateMaxTraffsPS.setLong(idx++, key.getTreeNodeId());
        this.updateMaxTraffsPS.setLong(idx++, key.getKey());
        this.updateMaxTraffsPS.setLong(idx++, yy);
        this.updateMaxTraffsPS.setLong(idx++, mm);
        if (this.updateMaxTraffsPS.executeUpdate() == 0) {
            idx = 1;
            this.insertMaxTraffsPS.setInt(idx++, contractId);
            this.insertMaxTraffsPS.setLong(idx++, key.getTreeNodeId());
            this.insertMaxTraffsPS.setLong(idx++, key.getKey());
            this.insertMaxTraffsPS.setLong(idx++, value.amountMax);
            this.insertMaxTraffsPS.setLong(idx++, value.amount1);
            this.insertMaxTraffsPS.setLong(idx++, value.amount2);
            this.insertMaxTraffsPS.setLong(idx++, yy);
            this.insertMaxTraffsPS.setLong(idx++, mm);
            this.insertMaxTraffsPS.executeUpdate();
        }
    }

    public void removeAllExtraData(Date month, Set<Integer> cids, int idDivizor, int idRemainder, Set<Integer> affectedContracts) throws BGException, SQLException {
        String andCidPartWithAffected = SessionRecalculateTarifficationManager.getSqlAndcidPartWithAffected(cids, affectedContracts);
        PreparedStatement ps = this.con.prepareStatement("DELETE FROM  " + this.trafficMaxDetailTableName + " WHERE 1=1 " + andCidPartWithAffected.replace("cid", "contractId"));
        SessionRecalculateTarifficationManager.setDivizorAndRemainder(ps, 1, cids, idDivizor, idRemainder);
        ps.executeUpdate();
        ps.close();
        Calendar cal = TimeUtils.convertDateToCalendar((Date)month);
        int yy = cal.get(1);
        int mm = cal.get(2) + 1;
        String query = "DELETE FROM  " + this.trafficMaxTableName + " WHERE 1=1  AND yy = ? AND mm = ? " + andCidPartWithAffected.replace("cid", "contractId");
        ps = this.con.prepareStatement(query);
        ps.setInt(1, yy);
        ps.setInt(2, mm);
        SessionRecalculateTarifficationManager.setDivizorAndRemainder(ps, 3, cids, idDivizor, idRemainder);
        ps.executeUpdate();
        ps.close();
    }

    private TrafficMax addDeltaToMap(Map<TrafficMaxKey, TrafficMax> maxTrafsMap, TrafficMaxKey key, TrafficMax value) {
        TrafficMax cachedValue = maxTrafsMap.get(key);
        if (cachedValue == null) {
            cachedValue = new TrafficMax(0, value.deltaMax, value.delta1, value.delta2);
            maxTrafsMap.put(key, cachedValue);
        } else {
            cachedValue.amount1 += value.delta1;
            cachedValue.amount2 += value.delta2;
            cachedValue.amountMax += value.deltaMax;
        }
        return cachedValue;
    }

    @Override
    public void close() throws SQLException {
        this.updateMaxTraffsPS.close();
        this.insertMaxTraffsPS.close();
        if (this.insertMaxTraffsDetailPS != null) {
            this.insertMaxTraffsDetailPS.close();
        }
        if (this.updateMaxTraffsDetailPS != null) {
            this.updateMaxTraffsDetailPS.close();
        }
    }
}

