/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.recalculate.day.current;

import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.SessionRecalculateTarifficationManager;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.day.RecalculateDayTask;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.day.current.RecalculateCurrentDayDAO;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLog;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServTypeDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionDao;
import ru.bitel.common.sql.ConnectionSet;

public class RecalculateCurrentDayTask
extends RecalculateDayTask {
    private final Set<Long> currentSessions;

    public RecalculateCurrentDayTask(SessionRecalculateTarifficationManager sessionRecalculateTarifficationManager, Accounting accounting, Set<Long> currentSessions) throws SQLException {
        super(sessionRecalculateTarifficationManager, accounting);
        this.currentSessions = currentSessions;
        this.needSlaveForSessionRead = false;
    }

    @Override
    protected void createRecalculateDAO(Accounting accounting, Connection con) throws SQLException {
        this.recalculateDAO = new RecalculateCurrentDayDAO(this.dateFrom, this.dateTo, accounting.moduleId, this.currentSessions, con);
        this.recalculateDAO.init();
    }

    @Override
    protected void detectRounding(long sessionId) {
        if (((RecalculateCurrentDayDAO)this.recalculateDAO).isCurrent(sessionId)) {
            this.roundingScale = 2;
            this.roundingMode = RoundingMode.FLOOR;
        } else {
            this.roundingScale = 5;
            this.roundingMode = RoundingMode.HALF_EVEN;
        }
    }

    @Override
    protected void loadSessionMap() throws BGException {
        super.loadSessionMap();
        ConnectionSet connectionSet = this.workerContext.getConnectionSet();
        Connection conForLoad = this.needSlaveForSessionRead ? connectionSet.getSlaveConnection() : connectionSet.getConnection();
        InetSessionDao inetSessionDao = new InetSessionDao(conForLoad, this.accounting.moduleId);
        List<InetSessionLog> sessionList = inetSessionDao.listAsLog(new InetServTypeDao(conForLoad, this.accounting.moduleId).list(), null, null, this.loadContractSet, null, this.dateFrom, this.dateTo, null, 0, 0, false);
        for (InetSessionLog session : sessionList) {
            Long sessionId = session.getId();
            this.sessionMap.put(sessionId, session);
            this.currentSessions.add(sessionId);
        }
    }
}

