/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetAddressType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;

public class InetServTypeDao
extends AbstractIdDao<InetServType>
implements Directory<InetServType> {
    private PreparedStatement getGroupsPS = null;
    private PreparedStatement getTypesPS = null;

    public InetServTypeDao(Connection con, int moduleId) {
        super(con, moduleId, "inet_serv_type");
    }

    protected InetServType getFromRS(ResultSet rs) throws SQLException, BGException {
        InetServType result = new InetServType();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setParentTypeIds(Utils.toIntegerSet((String)rs.getString("parentTypeIds")));
        result.setSessionInitiationType(rs.getInt("sessionInitiationType"));
        result.setSessionCountLimit(rs.getInt("sessionCountLimit"));
        result.setSessionCountLimitLock(rs.getBoolean("sessionCountLimitLock"));
        result.setAddressType(InetAddressType.getInetAddressType((int)rs.getInt("addressType")));
        result.setData(rs.getString("data"));
        result.setAddressAllInterface(rs.getBoolean("addressAllInterface"));
        result.setTrafficTypeLinkId(rs.getInt("trafficTypeLinkId"));
        result.setNeedLogin(rs.getBoolean("needLogin"));
        result.setNeedDevice(rs.getBoolean("needDevice"));
        result.setNeedInterface(rs.getBoolean("needInterface"));
        result.setPersonalInterface(rs.getBoolean("personalInterface"));
        result.setPersonalVlan(rs.getBoolean("personalVlan"));
        result.setNeedVlan(rs.getInt("needVlan") > 0);
        result.setNullVlan(rs.getInt("needVlan") > 1);
        result.setNeedMacAddress(rs.getBoolean("needMacAddress"));
        result.setNeedIdentifier(rs.getBoolean("needIdentifier"));
        result.setNeedRestriction(rs.getBoolean("needRestriction"));
        result.setNeedContractObject(rs.getBoolean("needContractObject"));
        result.setConfig(rs.getString("config"));
        result.setIpFromParentRange(rs.getBoolean("ipFromParentRange"));
        result.setEntitySpecId(rs.getInt("entitySpecId"));
        HashSet<Integer> deviceTypeIds = new HashSet<Integer>();
        if (this.getTypesPS == null) {
            this.getTypesPS = this.con.prepareStatement("SELECT deviceTypeId FROM inet_serv_type_device_type_link_" + this.moduleId + " WHERE inetServId=?");
        }
        this.getTypesPS.setInt(1, result.getId());
        ResultSet getTypeRS = this.getTypesPS.executeQuery();
        while (getTypeRS.next()) {
            deviceTypeIds.add(getTypeRS.getInt(1));
        }
        HashSet<Integer> deviceGroupIds = new HashSet<Integer>();
        if (this.getGroupsPS == null) {
            this.getGroupsPS = this.con.prepareStatement("SELECT deviceGroupId FROM inet_serv_type_device_group_link_" + this.moduleId + " WHERE inetServId=?");
        }
        this.getGroupsPS.setInt(1, result.getId());
        ResultSet getGroupsRS = this.getGroupsPS.executeQuery();
        while (getGroupsRS.next()) {
            deviceGroupIds.add(getGroupsRS.getInt(1));
        }
        getGroupsRS.close();
        result.setDeviceTypeIds(deviceTypeIds);
        result.setDeviceGroupIds(deviceGroupIds);
        return result;
    }

    protected void updateImpl(InetServType inetServType) throws BGException, SQLException {
        if (Utils.isBlankString((String)inetServType.getTitle())) {
            throw new BGIllegalArgumentException();
        }
        boolean insert = inetServType.getId() < 1;
        String query = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET title=?, parentTypeIds=?, sessionInitiationType=?, addressType=?, addressAllInterface=?, trafficTypeLinkId=?, needLogin=?, needDevice=?, needInterface=?, personalInterface=?, needVlan=?, needIdentifier=?, needMacAddress=?, sessionCountLimit=?, sessionCountLimitLock=?, config=?, personalVlan=?, needContractObject=?, needRestriction=?, ipFromParentRange=?, entitySpecId=?, data=?" + (insert ? "" : " WHERE id=?");
        int parameterIndex = 1;
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setString(parameterIndex++, inetServType.getTitle());
            ps.setString(parameterIndex++, Utils.toString((Iterable)inetServType.getParentTypeIds()));
            ps.setInt(parameterIndex++, inetServType.getSessionInitiationType());
            ps.setInt(parameterIndex++, inetServType.getAddressType().getCode());
            ps.setBoolean(parameterIndex++, inetServType.isAddressAllInterface());
            ps.setInt(parameterIndex++, inetServType.getTrafficTypeLinkId());
            ps.setBoolean(parameterIndex++, inetServType.isNeedLogin());
            ps.setBoolean(parameterIndex++, inetServType.isNeedDevice());
            ps.setBoolean(parameterIndex++, inetServType.isNeedInterface());
            ps.setBoolean(parameterIndex++, inetServType.isPersonalInterface());
            ps.setInt(parameterIndex++, inetServType.isNeedVlan() ? (inetServType.isNullVlan() ? 2 : 1) : 0);
            ps.setBoolean(parameterIndex++, inetServType.isNeedIdentifier());
            ps.setBoolean(parameterIndex++, inetServType.isNeedMacAddress());
            ps.setInt(parameterIndex++, inetServType.getSessionCountLimit());
            ps.setBoolean(parameterIndex++, inetServType.isSessionCountLimitLock());
            ps.setString(parameterIndex++, inetServType.getConfig());
            ps.setBoolean(parameterIndex++, inetServType.isPersonalVlan());
            ps.setBoolean(parameterIndex++, inetServType.isNeedContractObject());
            ps.setBoolean(parameterIndex++, inetServType.isNeedRestriction());
            ps.setBoolean(parameterIndex++, inetServType.isIpFromParentRange());
            ps.setInt(parameterIndex++, inetServType.getEntitySpecId());
            ps.setString(parameterIndex++, inetServType.getData());
            if (!insert) {
                ps.setInt(parameterIndex++, inetServType.getId());
            }
            ps.executeUpdate();
        }
        if (insert) {
            inetServType.setId(ServerUtils.lastInsertId((Connection)this.con));
        } else {
            try (PreparedStatement deleteLinkPS = this.con.prepareStatement("DELETE FROM inet_serv_type_device_type_link_" + this.moduleId + " WHERE inetServId=?");){
                deleteLinkPS.setInt(1, inetServType.getId());
                deleteLinkPS.executeUpdate();
            }
            deleteLinkPS = this.con.prepareStatement("DELETE FROM inet_serv_type_device_group_link_" + this.moduleId + " WHERE inetServId=?");
            try {
                deleteLinkPS.setInt(1, inetServType.getId());
                deleteLinkPS.executeUpdate();
            }
            finally {
                if (deleteLinkPS != null) {
                    deleteLinkPS.close();
                }
            }
        }
        ps = this.con.prepareStatement("INSERT INTO inet_serv_type_device_type_link_" + this.moduleId + " SET inetServId=?, deviceTypeId=?");
        try {
            ps.setInt(1, inetServType.getId());
            for (Integer i : inetServType.getDeviceTypeIds()) {
                ps.setInt(2, i);
                ps.executeUpdate();
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        ps = this.con.prepareStatement("INSERT INTO inet_serv_type_device_group_link_" + this.moduleId + " SET inetServId=?, deviceGroupId=?");
        try {
            ps.setInt(1, inetServType.getId());
            for (Integer i : inetServType.getDeviceGroupIds()) {
                ps.setInt(2, i);
                ps.executeUpdate();
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public InetServType get(String title) throws BGException {
        throw new UnsupportedOperationException();
    }

    public List<InetServType> list() throws BGException {
        return this.list(null, "id", new Object[0]);
    }

    public List<InetServType> list(int sessionInitiationType) throws BGException {
        return this.list("sessionInitiationType=?", "id", new Object[]{sessionInitiationType});
    }
}

