/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.radius;

import java.math.BigDecimal;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.access.sa.ProtocolHandler;
import ru.bitel.bgbilling.apps.inet.accounting.ConnectionLog;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionCallRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.event.InetAccountingEvent;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSetFormatter;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSetRealmMap;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusSession;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnectionInspector;
import ru.bitel.bgbilling.modules.inet.common.bean.AccountingTrafficAmount;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.server.FramedRouteMacros;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.radius.AcctSessionIdKey;
import ru.bitel.bgbilling.modules.inet.server.radius.AuthSessionKey;
import ru.bitel.bgbilling.modules.inet.server.radius.DiscardedAccountingRequestHandler;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNasConnection;
import ru.bitel.bgbilling.modules.inet.server.radius.InetRadiusAttributesMacros;
import ru.bitel.bgbilling.modules.inet.server.radius.InetRadiusProcessor;
import ru.bitel.bgbilling.modules.inet.server.radius.InetRadiusSessionParams;
import ru.bitel.bgbilling.modules.inet.server.radius.IpResourceEntry;
import ru.bitel.bgbilling.modules.inet.server.radius.RadiusAccessRequestHandler;
import ru.bitel.bgbilling.modules.inet.server.runtime.AuthResult;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetOptionRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServTypeRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.ServSearchResult;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpNet;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.TimeoutListMapOld;
import ru.bitel.common.util.TimeoutMap;
import ru.bitel.common.util.TimeoutMapOld;
import ru.bitel.common.worker.WorkerThreadFactory;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceReserve;
import ru.bitel.oss.systems.inventory.resource.server.ip.dynamic.IpResourceRuntime;
import ru.bitel.oss.systems.inventory.resource.server.ip.dynamic.IpResourceRuntimeManager;

public class InetNas
extends Nas<InetNasConnection, Preferences, InetRadiusProcessor> {
    private static final Logger logger = LogManager.getLogger();
    private static final String REALM_REJECT = "REJECT";
    private final ReentrantReadWriteLock readWriteLock;
    private final Lock readLock;
    private final Lock writeLock;
    private final InetDeviceRuntime deviceRuntime;
    private final RadiusAttributeSetRealmMap optionAttributeSetMap;
    private final IpResourceEntry ipResourceEntry;
    private final Map<Integer, IpResourceEntry> ipResourceDescendantEntryMap;
    private final Map<Integer, RadiusAttributeSet> disableAttributeMap;
    private final Map<String, InetRadiusAttributesMacros> realmAttributeMacrosMap = new HashMap<String, InetRadiusAttributesMacros>();
    private final Map<Integer, InetRadiusAttributesMacros> disableAttributeMacrosMap = new HashMap<Integer, InetRadiusAttributesMacros>();
    private final int[][] servSearchModes;
    private final int checkDuplicateSession;
    private final boolean checkDuplicateSessionType;
    private final Set<Integer> disableRealmAccessCodes;
    private final RadiusAttributeSet disablePatternAttributes;
    private final boolean disableRealmPatternRealmName;
    public static final int RADIUS_DISABLE_MODE_DISABLE_POOL = 0;
    public static final int RADIUS_DISABLE_MODE_DEFAULT_STATIC = 1;
    public static final int RADIUS_DISABLE_MODE_DEFAULT_POOL = 2;
    private final int radiusDisableMode;
    private final boolean usernameRemoveWhitespace;
    private final boolean usernameRemoveDomain;
    private final boolean usernameIgnoreCase;
    private final ProtocolHandler protocolHandler;
    private final RadiusAccessRequestHandler accessRequestHandler;
    private final DiscardedAccountingRequestHandler discardedAccountingRequestHandler;
    private final long connectionCloseTimeout;
    private final int connectionStartFromUpdateMode;
    private final boolean connectionStartFromUpdateIgnoreFramedIpLack;
    private final int connectionStartFromAccessMode;
    private final long connectionStartStopTimeout;
    private final boolean connectionStartStateByAuth;
    private final Set<String> realms;
    private final int cardModuleId;
    private final long cardLoginMin;
    private final long cardLoginMax;
    public static final int START_FROM_ACCESS_NO = 0;
    public static final int START_FROM_ACCESS_WAIT = 1;
    public static final int START_FROM_UPDATE_NO = 0;
    public static final int START_FROM_UPDATE_NOW = 1;
    public static final int START_FROM_UPDATE_BY_CLOSE_TIMEOUT = 2;
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR_SERVICE = Executors.newScheduledThreadPool(1, (ThreadFactory)new WorkerThreadFactory("nas-ex-service", null, null));
    private final TimeoutMapOld<AcctSessionIdKey, Boolean> stoppedAcctSessionIds;
    private final RadiusAttributeSetFormatter invalidAccountErrorFormatter;
    private final boolean passwordVerification;
    private final List<Integer> disableServIds;
    private final int framedRouteVendor;
    private final int framedRouteType;
    private final FramedRouteMacros framedRouteMacros;
    private final long radiusAccessServLockTimeout;
    private final long radiusAccountingServLockTimeout;
    private final String keyPattern;
    private final boolean addressFromRequest;
    private final boolean addressFromRequestCheck;
    private final IpResourceRuntimeManager ipResourceRuntimeManager;
    private final TimeoutMap<AuthSessionKey, IpReserve> authSessionIpReserveMap;
    private final long authenticationIpReserveTimeout;
    private final long parallelAccessRequestSkipTimeout;
    private final boolean acctSessIdAlwaysPresent;
    private final boolean ipAlwaysPresent;
    private final boolean nasPortCorrect;
    private final long radiusConnectionServiceTimeout;
    private final boolean connectionAccessRequest;
    private final TimeoutListMapOld<String, StartWithParent> startWithParentMap;

    public InetNas(Preferences setup, int moduleId, InetRadiusProcessor processor, Access access, int id, Nas<InetNasConnection, Preferences, InetRadiusProcessor> oldNas, InetAddress nasIPAddress, String nasIdentifier, int vendorCode, ParameterMap config, byte[] secret, ConcurrentMap<Object, InetNasConnection> connections, ConcurrentMap<Integer, InetNasConnection> portMap, InetDeviceRuntime deviceRuntime, NasConnectionInspector inspector) {
        super(setup, moduleId, (RadiusProcessor)processor, id, oldNas, nasIPAddress, nasIdentifier, vendorCode, config, secret, connections, "", inspector);
        InetOptionRuntimeMap optionRuntimeMap;
        this.readWriteLock = new ReentrantReadWriteLock();
        this.readLock = this.readWriteLock.readLock();
        this.writeLock = this.readWriteLock.writeLock();
        this.deviceRuntime = deviceRuntime;
        this.protocolHandler = deviceRuntime.protocolHandler;
        this.accessRequestHandler = this.protocolHandler instanceof RadiusAccessRequestHandler ? (RadiusAccessRequestHandler)((Object)this.protocolHandler) : null;
        this.discardedAccountingRequestHandler = this.protocolHandler instanceof DiscardedAccountingRequestHandler ? (DiscardedAccountingRequestHandler)((Object)this.protocolHandler) : null;
        this.ipResourceRuntimeManager = processor.access != null ? processor.access.ipResourceManager : processor.accounting.ipResourceManager;
        this.getRealmAttributeMap().clear();
        if (access != null) {
            this.getRealmAttributeMap().putAll(RadiusAttributeSet.newRadiusAttributeRealmMap((ParameterMap)setup, (String)"radius.realm.", (String)"attributes"));
            this.getRealmAttributeMap().putAll(RadiusAttributeSet.newRadiusAttributeRealmMap((ParameterMap)config, (String)"radius.realm.", (String)"attributes"));
            this.getRealmAttributeMap().put("disable", RadiusAttributeSet.getRadiusAttributeSet((String)config.get("radius.disable.attributes", config.get("radius.realm.disable.attributes", config.get("nas.radius.realm.reject.attributes", null)))));
            this.getRealmAttributeMap().put(REALM_REJECT, RadiusAttributeSet.getRadiusAttributeSet((String)config.get("radius.reject.attributes", null)));
            for (Map.Entry e : config.subKeyed("radius.realm.").entrySet()) {
                String macros = ((ParameterMap)e.getValue()).get("attributes.macros", null);
                if (!Utils.notBlankString((String)macros)) continue;
                this.realmAttributeMacrosMap.put(InetUtils.internRealm((String)e.getKey()), new InetRadiusAttributesMacros(macros));
            }
            String macros = config.get("radius.disable.attributes.macros", null);
            if (Utils.notBlankString((String)macros)) {
                this.realmAttributeMacrosMap.put("disable", new InetRadiusAttributesMacros(macros));
            }
        }
        this.disableAttributeMap = new HashMap<Integer, RadiusAttributeSet>();
        if (access != null) {
            for (Map.Entry e : config.subKeyed("radius.disable.").entrySet()) {
                String macros;
                Set accessCodes = Utils.toIntegerSet((String)((String)e.getKey()));
                accessCodes.remove(0);
                if (accessCodes.size() == 0) continue;
                String attributes = ((ParameterMap)e.getValue()).get("attributes", null);
                if (Utils.notBlankString((String)attributes)) {
                    RadiusAttributeSet ras = RadiusAttributeSet.newRadiusAttributeSet((String)attributes);
                    for (Integer accessCode : accessCodes) {
                        this.disableAttributeMap.put(accessCode, ras);
                    }
                }
                if (!Utils.notBlankString((String)(macros = ((ParameterMap)e.getValue()).get("attributes.macros", null)))) continue;
                for (Integer accessCode : accessCodes) {
                    this.disableAttributeMacrosMap.put(accessCode, new InetRadiusAttributesMacros(macros));
                }
            }
            this.disableAttributeMap.remove(0);
        }
        if (access != null) {
            RadiusAttributeSetRealmMap optionAttributeSetMap = null;
            try {
                optionAttributeSetMap = InetUtils.newRadiusAttributeSetRealmMap(processor.moduleId, config, "radius.inetOption.");
            }
            catch (BGException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                optionAttributeSetMap = RadiusAttributeSet.newRadiusAttributeSetRealmMap((ParameterMap)setup, (String)"radius.inetOption.", (String)"attributes");
                optionAttributeSetMap.putAll(RadiusAttributeSet.newRadiusAttributeSetRealmMap((ParameterMap)config, (String)"radius.inetOption.", (String)"attributes"));
            }
            this.optionAttributeSetMap = optionAttributeSetMap;
        } else {
            this.optionAttributeSetMap = null;
        }
        this.realms = Utils.toSet((String)config.get("radius.realm", "default"));
        this.checkDuplicateSession = config.getInt("radius.connection.checkDuplicate", config.getInt("check.duplicate.session", 0));
        this.checkDuplicateSessionType = config.getInt("radius.connection.checkDuplicate.type", 0) > 0;
        this.disableRealmAccessCodes = Utils.toIntegerSet((String)config.get("radius.disable.accessCodes", config.get("realm.reject.error", null)));
        this.disableRealmPatternRealmName = config.getInt("radius.disable.pattern.realmName", config.getInt("nas.radius.realm.reject.pattern.realmName", 1)) > 0;
        String rejectPatternAttributeSet = config.get("radius.disable.pattern.attributes", config.get("nas.radius.realm.reject.pattern.attributes", null));
        this.disablePatternAttributes = Utils.isBlankString((String)rejectPatternAttributeSet) ? null : RadiusAttributeSet.newRadiusAttributeSet((String)rejectPatternAttributeSet);
        this.radiusDisableMode = config.getInt("radius.disable.mode", 0);
        List disableServIds = Utils.toIntegerList((String)config.get("radius.disable.servId", ""));
        disableServIds.remove((Object)0);
        if (disableServIds.size() == 0) {
            this.disableServIds = Collections.emptyList();
        } else if (disableServIds.size() == 1) {
            this.disableServIds = Collections.singletonList((Integer)disableServIds.get(0));
        } else {
            this.disableServIds = disableServIds;
            Collections.sort(disableServIds);
        }
        this.usernameRemoveDomain = config.getInt("radius.username.removeDomain", config.getInt("nas.radius.username.removeDomain", 1)) > 0;
        this.usernameRemoveWhitespace = config.getInt("radius.username.removeWhitespace", config.getInt("nas.radius.username.removeWhitespace", 0)) > 0;
        this.usernameIgnoreCase = config.getInt("radius.username.ignoreCase", 0) > 0;
        this.passwordVerification = config.getInt("radius.password.verification", 1) > 0;
        this.parallelAccessRequestSkipTimeout = config.getLong("radius.parallelAccessRequest.skipTimeout", 0L);
        InetApplication inetApplication = processor.access != null ? processor.access : processor.accounting;
        try {
            optionRuntimeMap = InetOptionRuntimeMap.getInstance(inetApplication.moduleId);
        }
        catch (BGException ex) {
            optionRuntimeMap = null;
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        this.ipResourceEntry = new IpResourceEntry(access, optionRuntimeMap, deviceRuntime, config);
        this.ipResourceDescendantEntryMap = new HashMap<Integer, IpResourceEntry>();
        InetDeviceRuntime agentDeviceRoot = deviceRuntime.getAgentDeviceRoot(inetApplication.deviceMap);
        for (Integer descendantId : agentDeviceRoot.descendantIds) {
            InetDeviceRuntime agentDeviceRuntime = inetApplication.deviceMap.get(descendantId);
            if (agentDeviceRuntime != null) {
                this.ipResourceDescendantEntryMap.put(descendantId, new IpResourceEntry(inetApplication, optionRuntimeMap, agentDeviceRuntime, agentDeviceRuntime.config));
                continue;
            }
            logger.error("Agent device not found with id=" + descendantId);
        }
        this.connectionCloseTimeout = deviceRuntime.connectionCloseTimeout;
        this.connectionStartFromUpdateMode = config.getInt("connection.start.fromUpdate", 1);
        this.connectionStartFromUpdateIgnoreFramedIpLack = config.getInt("connection.start.fromUpdate.ignoreFramedIpLack", 0) > 0;
        this.connectionStartFromAccessMode = config.getInt("connection.start.fromAccept", config.getInt("connection.start.fromAccess", 1));
        this.connectionStartStopTimeout = config.getLong("connection.start.stopTimeout", 300L) * 1000L;
        boolean bl = this.connectionStartStateByAuth = config.getInt("connection.start.stateByAuth", 0) > 0;
        if (oldNas == null) {
            this.stoppedAcctSessionIds = new TimeoutMapOld(new DelayQueue(), SCHEDULED_EXECUTOR_SERVICE, 180L, 30L, TimeUnit.SECONDS);
            this.startWithParentMap = new TimeoutListMapOld(new DelayQueue(), SCHEDULED_EXECUTOR_SERVICE, 180L, 30L, TimeUnit.SECONDS);
            this.authSessionIpReserveMap = new TimeoutMap(SCHEDULED_EXECUTOR_SERVICE, 10L, 10L, TimeUnit.SECONDS);
        } else {
            this.stoppedAcctSessionIds = ((InetNas)oldNas).stoppedAcctSessionIds;
            this.startWithParentMap = ((InetNas)oldNas).startWithParentMap;
            this.authSessionIpReserveMap = ((InetNas)oldNas).authSessionIpReserveMap;
        }
        this.cardModuleId = config.getInt("card.moduleId", config.getInt("card.module.id", -1));
        this.cardLoginMin = config.getInt("card.login.min", 0);
        this.cardLoginMax = config.getInt("card.login.max", 0);
        this.invalidAccountErrorFormatter = new RadiusAttributeSetFormatter(config.get("radius.accessError.infoPattern", "LOGIN:$User-Name"));
        this.servSearchModes = InetUtils.parseSearchModes(config.get("radius.servSearchMode", config.get("radius.serviceSearchMode", String.valueOf(0))));
        this.framedRouteVendor = config.getInt("radius.framedRoute.vendor", -1);
        this.framedRouteType = config.getInt("radius.framedRoute.type", 22);
        this.framedRouteMacros = new FramedRouteMacros(config.get("radius.framedRoute.pattern", "$net"));
        this.radiusAccessServLockTimeout = config.getLong("radius.access.serv.lockTimeout", config.getLong("serv.lockTimeout", 8L));
        this.radiusAccountingServLockTimeout = config.getLong("radius.accounting.serv.lockTimeout", config.getLong("serv.lockTimeout", 13L));
        this.keyPattern = config.get("radius.key.pattern", "$ip");
        this.addressFromRequest = config.getInt("radius.address.fromRequest", 0) > 0;
        this.addressFromRequestCheck = config.getInt("radius.address.fromRequest.check", 0) > 0;
        this.authenticationIpReserveTimeout = config.getLong("radius.address.authReserveTimeout", 0L);
        this.acctSessIdAlwaysPresent = config.getInt("radius.connection.acctSessIdAlwaysPresent", 0) > 0;
        this.ipAlwaysPresent = config.getInt("radius.connection.ipAlwaysPresent", 0) > 0;
        this.nasPortCorrect = config.getInt("radius.connection.nasPortCorrect", 0) > 0;
        this.radiusConnectionServiceTimeout = config.getLong("radius.connection.service.timeout", 0L);
        this.connectionAccessRequest = config.getInt("radius.connection.accessRequest", 0) > 0;
    }

    public Lock readLock() {
        return this.readLock;
    }

    public Lock writeLock() {
        return this.writeLock;
    }

    public RadiusAttributeSetFormatter getInvalidAccountErrorFormatter() {
        return this.invalidAccountErrorFormatter;
    }

    public ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    public RadiusAccessRequestHandler getAccessRequestHandler() {
        return this.accessRequestHandler;
    }

    public DiscardedAccountingRequestHandler getDiscardedAccountingRequestHandler() {
        return this.discardedAccountingRequestHandler;
    }

    public InetNasConnection getParentConnection(RadiusPacket request) throws BGException {
        String parentAcctSessionId = (String)request.getOption(InetRadiusProcessor.PARENT_ACCT_SESSION_ID);
        if (Utils.notEmptyString((String)parentAcctSessionId)) {
            InetNasConnection parentNasConnection = (InetNasConnection)((Object)this.connections.get(parentAcctSessionId));
            if (parentNasConnection == null) {
                throw new BGException("Option parentAcctSessionId is set but connection not found with acctSessionId=" + parentAcctSessionId);
            }
            return parentNasConnection;
        }
        return null;
    }

    protected InetNasConnection getConnection(Object acctSessionId) {
        return (InetNasConnection)((Object)this.connections.get(acctSessionId));
    }

    @Deprecated
    public InetNasConnection setConnection(InetNasConnection nasCon, RadiusPacket nullz, Connection con, Connection conSlave) {
        return this.setConnection(nasCon, con, conSlave);
    }

    public InetNasConnection setConnection(InetNasConnection nasCon, Connection con, Connection conSlave) {
        if (nasCon == null) {
            logger.error("InetNasConnection is null");
        } else if (nasCon.getSession() == null) {
            logger.error("InetConnectionCallRuntime is null");
        } else if (nasCon.getSession().inetServRuntime == null) {
            logger.error("inetServRuntime is null");
        }
        assert (nasCon.getSession().inetServRuntime.isHeldByCurrentThread());
        try {
            InetConnectionCallRuntime connectionRuntime = nasCon.getSession();
            InetNasConnection oldNasCon = this.connections.putIfAbsent(connectionRuntime.connection.getAcctSessionId(), nasCon);
            if (oldNasCon != null) {
                if (nasCon.getSession().sessionId == oldNasCon.getSession().sessionId) {
                    return oldNasCon;
                }
                oldNasCon = this.connections.put(connectionRuntime.connection.getAcctSessionId(), nasCon);
                if (oldNasCon != null) {
                    logger.info("NasConnection already exist. Stopping old...");
                    this.stopConnection(con, oldNasCon, 0L, true, false, System.currentTimeMillis(), true);
                }
            }
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return nasCon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetNasConnection startConnection(RadiusListenerWorker<?> req, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, Date time) {
        try {
            InetNasConnection nasCon = ((InetRadiusProcessor)this.processor).getNasConnection(req, connectionSet, this, request, time);
            if (nasCon != null) {
                try {
                    connectionSet.commit();
                }
                finally {
                    nasCon.getSession().inetServRuntime.unlock();
                }
                if (req != null) {
                    InetConnectionCallRuntime connectionCallRuntime = nasCon.getSession();
                    req.setContractId(connectionCallRuntime.inetServRuntime.contractRuntime.contractId);
                    req.setAccountId(connectionCallRuntime.inetServRuntime.inetServId.intValue());
                }
            } else if (this.discardedAccountingRequestHandler != null) {
                try {
                    this.discardedAccountingRequestHandler.discard((ServerContext)ServerContext.get(ServerContext.class), req, request, response);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            return nasCon;
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    boolean isRecentlyStopped(String acctSessionId) {
        return acctSessionId != null && this.stoppedAcctSessionIds.containsKey((Object)new AcctSessionIdKey(acctSessionId, 0L));
    }

    private void addRecentlyStopped(String acctSessionId) {
        if (this.connectionStartStopTimeout > 0L) {
            this.stoppedAcctSessionIds.put((Object)new AcctSessionIdKey(acctSessionId, System.currentTimeMillis() + this.connectionStartStopTimeout), (Object)Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetNasConnection updateConnection(RadiusListenerWorker<?> req, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        try {
            assert (req.millis != 0L);
            long millis = req.millis;
            Date time = new Date(millis);
            Long hour = millis / 3600000L * 3600000L;
            InetNasConnection nasCon = ((InetRadiusProcessor)this.processor).getNasConnection(req, connectionSet, this, request, time);
            if (nasCon != null) {
                InetConnectionCallRuntime connectionCallRuntime = nasCon.getSession();
                try {
                    Map<Integer, AccountingTrafficAmount> counterTraffics = InetUtils.getCounterTraffics(connectionCallRuntime, request);
                    long nextDayTime = connectionCallRuntime.nextDayTime;
                    if (((InetRadiusProcessor)this.processor).accounting.processRadiusPacket(this.getId(), hour, millis, connectionCallRuntime, request, counterTraffics) && req != null && !connectionCallRuntime.isServiceSession() && (connectionCallRuntime.sessionStartTime != nextDayTime || ThreadLocalRandom.current().nextInt(9) == 0)) {
                        req.setConnectionModified(true);
                    }
                    connectionSet.commit();
                    if (req != null) {
                        req.setContractId(connectionCallRuntime.inetServRuntime.contractRuntime.contractId);
                        req.setAccountId(connectionCallRuntime.inetServRuntime.inetServId.intValue());
                    }
                    ((InetRadiusProcessor)this.processor).accounting.onConnectionUpdate(connectionCallRuntime);
                    ((InetRadiusProcessor)this.processor).accounting.sessionAccountingEP.publish((Event)new InetAccountingEvent(((InetRadiusProcessor)this.processor).accounting.sessionAccountingEP, connectionCallRuntime.contractId, connectionCallRuntime.connection, connectionCallRuntime.sessionId, 3, new HashMap<Integer, AccountingTrafficAmount>(connectionCallRuntime.counterTraffics), time));
                }
                finally {
                    connectionCallRuntime.inetServRuntime.unlock();
                }
            }
            logger.warn("NasConnection not found");
            if (this.discardedAccountingRequestHandler != null) {
                try {
                    this.discardedAccountingRequestHandler.discard((ServerContext)ServerContext.get(ServerContext.class), req, request, response);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            return nasCon;
        }
        catch (BGException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetNasConnection stopConnection(RadiusListenerWorker<?> req, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        try {
            assert (req.millis != 0L);
            long millis = req.millis;
            Date time = new Date(millis);
            Long hour = millis / 3600000L * 3600000L;
            InetNasConnection nasCon = ((InetRadiusProcessor)this.processor).getNasConnection(req, connectionSet, this, request, time);
            if (nasCon != null) {
                InetConnectionCallRuntime connectionCallRuntime = nasCon.getSession();
                try {
                    if (!connectionCallRuntime.isServiceSession()) {
                        req.setConnectionModified(true);
                    }
                    req.setContractId(connectionCallRuntime.inetServRuntime.contractRuntime.contractId);
                    req.setAccountId(connectionCallRuntime.inetServRuntime.inetServId.intValue());
                    Map<Integer, AccountingTrafficAmount> counterTraffics = InetUtils.getCounterTraffics(connectionCallRuntime, request);
                    long sessionTime = request.getIntAttribute(-1, 46, Integer.valueOf(-1)).intValue();
                    boolean sessionTimeError = false;
                    long seconds = millis / 1000L - connectionCallRuntime.connectionStartTime / 1000L;
                    if (Math.abs(seconds - sessionTime) > 3600L) {
                        logger.warn("Wrong Acct-Session-Time value in Stop-packet: " + sessionTime + "!");
                        sessionTime = 0L;
                        sessionTimeError = true;
                    }
                    try {
                        ((InetRadiusProcessor)this.processor).accounting.processRadiusPacket(this.getId(), hour, millis, connectionCallRuntime, request, counterTraffics);
                    }
                    finally {
                        if (sessionTimeError) {
                            connectionCallRuntime.updateTime(millis);
                        }
                        this.stopConnection(connectionSet.getConnection(), nasCon, sessionTime, true, true, millis, false);
                    }
                    connectionSet.commit();
                }
                finally {
                    connectionCallRuntime.inetServRuntime.unlock();
                }
            }
            logger.warn("NasConnection not found");
            if (this.discardedAccountingRequestHandler != null) {
                try {
                    this.discardedAccountingRequestHandler.discard((ServerContext)ServerContext.get(ServerContext.class), req, request, response);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            return nasCon;
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean stopConnection(Connection con, InetNasConnection nasCon, long sessionTime, boolean system, long millis, boolean force) throws BGException {
        return this.stopConnection(con, nasCon, sessionTime, system, true, millis, force);
    }

    private boolean stopConnection(Connection con, InetNasConnection nasCon, long sessionTime, boolean system, boolean needRemove, long millis, boolean force) throws BGException {
        logger.info("Stopping NasConnection");
        InetConnectionCallRuntime connectionRuntime = nasCon.getSession();
        connectionRuntime.inetServRuntime.lock();
        try {
            long timeout;
            InetConnection connection = connectionRuntime.connection;
            ConnectionLog.log(connectionRuntime, Level.INFO, "Stopping NasConnection");
            if (nasCon.getStatus() == NasConnection.Status.stopped) {
                logger.debug("Nas connection status already stopped");
                boolean bl = false;
                return bl;
            }
            nasCon.setStatus(NasConnection.Status.stopped);
            long sessionStop = millis;
            long l = timeout = system ? 16L : 8L;
            if (sessionTime > 0L) {
                sessionStop = connectionRuntime.connectionStartTime + (sessionTime - 1L) * 1000L;
            }
            ((InetRadiusProcessor)this.processor).accounting.connectionStop(con, system, connectionRuntime, new Date(sessionStop), timeout);
            if (!con.getAutoCommit()) {
                con.commit();
            }
            if (needRemove) {
                String acctSessionId = connection.getAcctSessionId();
                this.connections.remove(acctSessionId, (Object)nasCon);
                if (!force) {
                    this.addRecentlyStopped(acctSessionId);
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        finally {
            connectionRuntime.inetServRuntime.unlock();
        }
        return true;
    }

    public void addRadiusAttributes(ServerContext context, RadiusListenerWorker<?> req, InetServTypeRuntime servTypeRuntime, InetServRuntime servRuntime, List<InetServRuntime> childrenServRuntimes, RadiusSession<InetNas, InetRadiusSessionParams> radiusSession, RadiusPacket response, Set<Integer> optionSet, Set<Integer> attrSets) throws BGException {
        this.addRadiusAttributes(context, req, servTypeRuntime, servRuntime, radiusSession, response, optionSet, attrSets);
    }

    public void addRadiusAttributes(ServerContext context, RadiusListenerWorker<?> req, InetServTypeRuntime servTypeRuntime, InetServRuntime servRuntime, RadiusSession<InetNas, InetRadiusSessionParams> radiusSession, RadiusPacket response, Set<Integer> optionSet, Set<Integer> attrSets) throws BGException {
        String macrosRadiusAttributes;
        InetRadiusAttributesMacros macros;
        RadiusAttributeSet set;
        boolean disable;
        String realm = ((InetRadiusSessionParams)radiusSession.sessionParams).realm;
        if (realm == null) {
            realm = "default";
            disable = false;
        } else {
            disable = "disable".equals(realm);
        }
        int ipResourceId = req.getIpAddressSet().getResourceId();
        IpResourceRuntime ipResourceRuntime = ipResourceId > 0 ? this.ipResourceRuntimeManager.getResource(Integer.valueOf(ipResourceId)) : null;
        RadiusAttributeSet servAttributes = null;
        if (this.accessRequestHandler != null) {
            servAttributes = new RadiusAttributeSet();
            servTypeRuntime.addRadiusAttributes(realm, servRuntime.getConfig(), servAttributes);
            try {
                if (this.accessRequestHandler.addResponseAttributes(context, servTypeRuntime.inetServType, servRuntime.getInetServ(), response, realm, this.getRealmAttributeMap(), servAttributes, optionSet)) {
                    logger.debug("RADIUS-attributes added by accessRequestHandler.");
                    return;
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (disable) {
            set = this.disableAttributeMap.get(radiusSession.errorCode);
            if (set == null) {
                set = (RadiusAttributeSet)this.getRealmAttributeMap().get(realm);
            }
            if (set != null) {
                response.addAttributes(set);
            }
            if ((macros = this.disableAttributeMacrosMap.get(radiusSession.errorCode)) == null) {
                macros = this.realmAttributeMacrosMap.get(realm);
            }
            if (macros != null && Utils.notEmptyString((String)(macrosRadiusAttributes = macros.format(new StringBuffer(30), new Object[]{((InetRadiusProcessor)this.processor).access != null ? ((InetRadiusProcessor)this.processor).access : ((InetRadiusProcessor)this.processor).accounting, this, req, ipResourceRuntime, optionSet, servRuntime}).toString()))) {
                response.addAttributes(RadiusAttributeSet.newRadiusAttributeSet((String)macrosRadiusAttributes));
            }
        } else {
            set = (RadiusAttributeSet)this.getRealmAttributeMap().get(realm);
            if (set != null) {
                response.addAttributes(set);
            }
            if ((macros = this.realmAttributeMacrosMap.get(realm)) != null && Utils.notEmptyString((String)(macrosRadiusAttributes = macros.format(new StringBuffer(30), new Object[]{((InetRadiusProcessor)this.processor).access != null ? ((InetRadiusProcessor)this.processor).access : ((InetRadiusProcessor)this.processor).accounting, this, req, ipResourceRuntime, optionSet, servRuntime}).toString()))) {
                response.addAttributes(RadiusAttributeSet.newRadiusAttributeSet((String)macrosRadiusAttributes));
            }
        }
        if (servAttributes != null) {
            response.addAttributes(servAttributes);
        } else {
            servTypeRuntime.addRadiusAttributes(realm, servRuntime.getConfig(), (RadiusAttributeSet)response);
        }
        if (disable) {
            return;
        }
        if (optionSet != null && optionSet.size() > 0) {
            for (Integer option : optionSet) {
                RadiusAttributeSet optionRadiusAttributes = this.optionAttributeSetMap.get(realm, option);
                if (optionRadiusAttributes == null) continue;
                response.addAttributes(optionRadiusAttributes);
            }
        }
        if (attrSets != null) {
            for (Integer i : attrSets) {
                RadiusAttributeSet set2 = (RadiusAttributeSet)this.getAttributeSetMap().get(i);
                if (set2 == null) continue;
                response.addAttributes(set2);
            }
        }
    }

    private IpResourceEntry getIpResourceEntry(int agentDeviceId) {
        IpResourceEntry ipResourceEntry;
        if (agentDeviceId > 0 && (ipResourceEntry = this.ipResourceDescendantEntryMap.get(agentDeviceId)) != null && !ipResourceEntry.isEmpty()) {
            return ipResourceEntry;
        }
        return this.ipResourceEntry;
    }

    @Deprecated
    public IpResourceReserve reserveIp(int agentDeviceId, int servId, String username, byte[] macAddress, String callingStationId, String identifier, String realm, boolean[] resourceExist, Set<Integer> optionSet) {
        return this.reserveIp(agentDeviceId, servId, username, macAddress, callingStationId, identifier, realm, resourceExist, optionSet, IpResourceEntry.AddressType.Default);
    }

    public IpResourceReserve reserveIp(int agentDeviceId, int servId, String username, byte[] macAddress, String callingStationId, String identifier, String realm, boolean[] resourceExist, Set<Integer> optionSet, IpResourceEntry.AddressType addressType) {
        IpReserve reserve;
        AuthSessionKey authSessionKey;
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Trying to reserve ip. agentDeviceId: %d, servId: %d, username: %s, macAddress: %s, callingStationId: %s, identifier: %s, realm: %s, addressType: %s", agentDeviceId, servId, username, Utils.bytesToHexString((byte[])macAddress), callingStationId, identifier, realm, addressType.name()));
        }
        long now = System.currentTimeMillis();
        if (this.authenticationIpReserveTimeout > 0L) {
            authSessionKey = new AuthSessionKey(servId, agentDeviceId, username, macAddress, callingStationId, identifier, realm);
            reserve = (IpReserve)this.authSessionIpReserveMap.get((Object)authSessionKey);
            if (reserve != null && reserve.expire > now) {
                IpResourceReserve ipResourceReserve = switch (addressType) {
                    case IpResourceEntry.AddressType.IPv6Prefix -> reserve.prefixReserve;
                    case IpResourceEntry.AddressType.IPv6DelegatedPrefix -> reserve.delegatedPrefixReserve;
                    default -> reserve.reserve;
                };
                if (ipResourceReserve != null && ipResourceReserve.getTimeout() > now) {
                    return ipResourceReserve;
                }
            } else {
                reserve = null;
            }
        } else {
            reserve = null;
            authSessionKey = null;
        }
        IpResourceEntry ipResourceEntry = this.getIpResourceEntry(agentDeviceId);
        IpResourceReserve ipResourceReserve = switch (addressType) {
            case IpResourceEntry.AddressType.IPv6Prefix -> ipResourceEntry.reservePrefix(this, realm, resourceExist);
            case IpResourceEntry.AddressType.IPv6DelegatedPrefix -> ipResourceEntry.reserveDelegatedPrefix(this, realm, resourceExist);
            default -> ipResourceEntry.reserve(this, realm, resourceExist, optionSet);
        };
        if (ipResourceReserve != null && authSessionKey != null) {
            if (reserve == null) {
                long expire = now + this.authenticationIpReserveTimeout;
                reserve = new IpReserve(expire);
                this.authSessionIpReserveMap.put((Object)authSessionKey, (Object)new IpReserve(expire), expire);
            }
            switch (addressType) {
                case IPv6Prefix: {
                    reserve.prefixReserve = ipResourceReserve;
                    break;
                }
                case IPv6DelegatedPrefix: {
                    reserve.delegatedPrefixReserve = ipResourceReserve;
                    break;
                }
                default: {
                    reserve.reserve = ipResourceReserve;
                }
            }
        }
        return ipResourceReserve;
    }

    public boolean isUnauthorizedSession(int servId, InetServRuntime servRuntime, RadiusPacket request, String realm) {
        if (this.disableRealmPatternRealmName) {
            return "disable".equals(realm);
        }
        if (this.disablePatternAttributes != null) {
            return request.contains(this.disablePatternAttributes);
        }
        if (this.disableServIds.contains(servId)) {
            return true;
        }
        if (this.connectionStartStateByAuth) {
            InetApplication application = ((InetRadiusProcessor)this.processor).accounting != null ? ((InetRadiusProcessor)this.processor).accounting : ((InetRadiusProcessor)this.processor).access;
            InetServRuntime parentServRuntime = servRuntime.getParentInetServRuntime(application);
            try {
                AuthResult authResult = ((InetRadiusProcessor)this.processor).accounting.authorization(parentServRuntime, servRuntime, true, this.getId(), 0, null, null, 0, null, 0, 0, false, null, null, false, BigDecimal.ZERO, false);
                return authResult.accessCode != 0;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public boolean isUsernameIgnoreCase() {
        return this.usernameIgnoreCase;
    }

    public String[] getUsernameAndRealm(String username) {
        int pos;
        boolean canTrim;
        String[] result = new String[3];
        boolean bl = canTrim = username.length() <= 100;
        if (this.usernameRemoveWhitespace && canTrim) {
            username = username.trim();
        }
        if ((pos = username.indexOf(64)) > 0) {
            result[0] = username.substring(0, pos);
            result[1] = username.substring(pos + 1);
            result[2] = result[1];
        } else {
            result[0] = username;
            result[1] = "default";
            result[2] = "";
        }
        if (this.usernameRemoveDomain && canTrim && (pos = result[0].indexOf(92)) >= 0) {
            result[0] = result[0].substring(pos + 1);
        }
        return result;
    }

    public int getIpResourceId(int agentDeviceId, String realm, byte[] address, Date start, Set<Integer> optionSet, IpResourceEntry.AddressType addressType) throws BGException {
        IpResourceEntry ipResourceEntry = this.getIpResourceEntry(agentDeviceId);
        if (logger.isDebugEnabled()) {
            logger.debug("agentDeviceId = " + agentDeviceId);
            logger.debug("ipResourceEntry = " + ipResourceEntry);
        }
        Set<Integer> categoryIds = null;
        if (logger.isDebugEnabled()) {
            logger.debug("optionSet = " + optionSet);
        }
        if (optionSet != null && optionSet.size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("optionSet.size() = " + optionSet.size());
                logger.debug("realm = " + realm);
            }
            categoryIds = ipResourceEntry.getCategoriesForOption(realm, optionSet);
            if (logger.isDebugEnabled()) {
                logger.debug("ipResourceEntry.getCategoriesForOption: categoryIds = " + categoryIds);
            }
        }
        categoryIds = this.getCategoryIds(realm, ipResourceEntry, ipResourceEntry.realmIpCategoriesMap, categoryIds);
        if (logger.isDebugEnabled()) {
            logger.debug("getCategoryIds: categoryIds = " + categoryIds);
        }
        switch (addressType) {
            case IPv6Prefix: {
                categoryIds = this.getCategoryIds(realm, ipResourceEntry, ipResourceEntry.realmPrefixIpCategoriesMap, categoryIds);
                if (!logger.isDebugEnabled()) break;
                logger.debug("getCategoryIds[IPv6Prefix]: categoryIds = " + categoryIds);
                break;
            }
            case IPv6DelegatedPrefix: {
                categoryIds = this.getCategoryIds(realm, ipResourceEntry, ipResourceEntry.realmDelegatedPrefixIpCategoriesMap, categoryIds);
                if (!logger.isDebugEnabled()) break;
                logger.debug("getCategoryIds[IPv6DelegatedPrefix]: categoryIds = " + categoryIds);
                break;
            }
        }
        if (categoryIds != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("start.getTime() = " + start.getTime());
            }
            return ((InetRadiusProcessor)this.processor).accounting.ipResourceManager.getIpResourceId(categoryIds, address, start.getTime());
        }
        return 0;
    }

    private Set<Integer> getCategoryIds(String realm, IpResourceEntry ipResourceEntry, Map<String, LinkedHashSet<Integer>> realmCategoriesMap, Set<Integer> categoryIds) {
        if (categoryIds == null || categoryIds.size() == 0) {
            categoryIds = realmCategoriesMap.get(realm);
        } else {
            Set categoryIds2 = realmCategoriesMap.get(realm);
            if (categoryIds2 != null) {
                categoryIds = new LinkedHashSet(categoryIds);
                categoryIds.addAll(categoryIds2);
            }
        }
        return categoryIds;
    }

    public boolean isDisableRealmAccessCode(int error) {
        return this.disableRealmAccessCodes.contains(error);
    }

    public long getConnectionCloseTimeout() {
        return this.connectionCloseTimeout;
    }

    public int getConnectionStartFromUpdateMode() {
        return this.connectionStartFromUpdateMode;
    }

    public void startWithParentAdd(Date time, String parentAcctSessionId, RadiusPacket request) {
        this.startWithParentMap.add((Map.Entry)new StartWithParentKey(parentAcctSessionId, new StartWithParent(time, request)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWithParentProcess(ConnectionSet connectionSet, String parentAcctSessionId) throws BGException {
        List list = this.startWithParentMap.remove((Comparable)((Object)parentAcctSessionId));
        if (list != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                StartWithParent start = (StartWithParent)list.get(i);
                logger.debug("Start service connection");
                InetNasConnection nasCon = ((InetRadiusProcessor)this.processor).getNasConnection(null, connectionSet, this, start.request, start.time);
                if (nasCon == null) continue;
                try {
                    connectionSet.commit();
                    continue;
                }
                finally {
                    nasCon.getSession().inetServRuntime.unlock();
                }
            }
        }
    }

    @Deprecated
    public boolean isDisableRealmIpAddress() {
        return this.radiusDisableMode > 0;
    }

    public int getRadiusDisableMode() {
        return this.radiusDisableMode;
    }

    public int getConnectionStartFromAccessMode() {
        return this.connectionStartFromAccessMode;
    }

    public boolean isConnectionStartFromUpdateIgnoreFramedIpLack() {
        return this.connectionStartFromUpdateIgnoreFramedIpLack;
    }

    public boolean isRealmAllowed(InetServTypeRuntime servTypeRuntime, String realm) {
        if (servTypeRuntime.realms != null) {
            return servTypeRuntime.realms.contains(realm);
        }
        return this.realms.contains(realm);
    }

    public boolean canActivateCard(int cardActivateServiceId) {
        return cardActivateServiceId != 0 && this.activateServices.contains(cardActivateServiceId) || this.activateServices.contains(0);
    }

    public Set<Integer> getActivateServiceIds() {
        return this.activateServices;
    }

    public int getCardModuleId() {
        return this.cardModuleId;
    }

    public boolean isCardCode(String userName) {
        long userNameLong = Utils.parseLong((String)userName, (long)0L);
        if (userNameLong <= 0L) {
            return false;
        }
        return !(this.cardLoginMin > 0L && this.cardLoginMin > userNameLong || this.cardLoginMax > 0L && this.cardLoginMax < userNameLong);
    }

    public int[][] getServSearchModes() {
        return this.servSearchModes;
    }

    public InetDeviceRuntime getAgentDeviceRuntime(InetApplication application, RadiusListenerWorker<?> req, RadiusPacket request) {
        Object agentSvlan;
        InetDeviceRuntime result;
        if (req != null && (result = (InetDeviceRuntime)req.getAgentDevice()) != null) {
            return result;
        }
        result = null;
        Object agentRemoteId = this.deviceRuntime.getOption82AgentRemoteId(request);
        if (logger.isDebugEnabled()) {
            if (agentRemoteId instanceof byte[]) {
                logger.debug("agentRemoteId=" + Utils.bytesToString((byte[])((byte[])agentRemoteId), (boolean)false, null));
            } else {
                logger.debug("agentRemoteId=" + agentRemoteId);
            }
        }
        if (agentRemoteId != null && !"".equals(agentRemoteId)) {
            InetDeviceRuntime subDeviceRuntime = application.deviceMap.getByIdentifier(result != null ? result : this.deviceRuntime, agentRemoteId);
            if (subDeviceRuntime != null) {
                result = subDeviceRuntime;
                logger.info("Found agentDevice by identifier: " + result.inetDeviceId);
                req.setAgentDeviceId(result.inetDeviceId.intValue());
                req.setAgentDevice((Object)result);
            } else {
                logger.info("AgentDevice not found by identifier.");
            }
        }
        if ((agentSvlan = request.getOption(InetRadiusProcessor.AGENT_SVLAN)) != null && !"".equals(agentSvlan)) {
            InetDeviceRuntime subDeviceRuntime = application.deviceMap.getBySvlan(result != null ? result : this.deviceRuntime, agentSvlan);
            if (subDeviceRuntime != null) {
                result = subDeviceRuntime;
                logger.info("Found agentDevice by SVLAN: " + result.inetDeviceId);
                req.setAgentDeviceId(result.inetDeviceId.intValue());
                req.setAgentDevice((Object)result);
            } else {
                logger.info("AgentDevice not found by SVLAN.");
            }
        }
        return result;
    }

    public ServSearchResult findServRuntime(InetApplication application, RadiusListenerWorker<?> req, String userName, RadiusPacket request, Date time) {
        if (logger.isDebugEnabled()) {
            logger.debug("Try to find serv in runtime [username = " + userName + "]");
        }
        try {
            Date date = new Date();
            for (int[] servSearchMode : this.servSearchModes) {
                Object result;
                if (logger.isDebugEnabled()) {
                    logger.debug("Trying search mode: " + servSearchMode[0]);
                }
                if ((result = this.findServRuntime(servSearchMode[0], application, req, userName, request, time)) == null) continue;
                if (result instanceof ServSearchResult) {
                    return (ServSearchResult)result;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Trying child search mode: " + servSearchMode[1]);
                }
                return this.findChildServRuntime(application, (InetServRuntime)result, servSearchMode[1], date, request, userName);
            }
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private ServSearchResult findChildServRuntime(InetApplication application, InetServRuntime parentServRuntime, int subServSearchMode, Date time, RadiusPacket request, String userName) {
        switch (subServSearchMode) {
            case 1: 
            case 2: {
                InetServRuntime servRuntime;
                byte[] macAddress = InetServ.parseMacAddress((String)((String)request.getOption(InetRadiusProcessor.MAC_ADDRESS)));
                if (macAddress == null) {
                    macAddress = (byte[])request.getOption(InetRadiusProcessor.MAC_ADDRESS_BYTES);
                }
                if (macAddress == null) {
                    if (subServSearchMode == 2) {
                        logger.debug("MAC-address not found.");
                        return new ServSearchResult(subServSearchMode, parentServRuntime, parentServRuntime);
                    }
                    logger.warn("MAC-address not found.");
                    return null;
                }
                if (logger.isInfoEnabled()) {
                    logger.info("Search child serv by mac on device=" + Utils.bytesToString((byte[])macAddress, (boolean)false, null));
                }
                if ((servRuntime = application.getInetServRuntimeMap().getByMacAddress(parentServRuntime, macAddress, time.getTime())) == null && subServSearchMode == 2) {
                    return new ServSearchResult(subServSearchMode, parentServRuntime, parentServRuntime);
                }
                return new ServSearchResult(subServSearchMode, parentServRuntime, servRuntime);
            }
            case 5: {
                return this.subSearchByAddress(application, parentServRuntime, subServSearchMode, userName, false, false, time);
            }
            case 6: {
                return this.subSearchByAddress(application, parentServRuntime, subServSearchMode, userName, true, false, time);
            }
            case 7: {
                return this.subSearchByAddress(application, parentServRuntime, subServSearchMode, userName, false, true, time);
            }
            case 8: {
                return this.subSearchByAddress(application, parentServRuntime, subServSearchMode, userName, true, true, time);
            }
        }
        return new ServSearchResult(0, parentServRuntime, parentServRuntime);
    }

    private ServSearchResult subSearchByAddress(InetApplication application, InetServRuntime parentServRuntime, int subServSearchMode, String userName, boolean ifExist, boolean withRoot, Date time) {
        InetServRuntime servRuntime;
        byte[] address;
        try {
            InetAddress inetAddress = InetAddress.getByName(userName);
            address = inetAddress.getAddress();
        }
        catch (Exception e) {
            if (ifExist) {
                if (logger.isInfoEnabled()) {
                    logger.info("IP-address not found " + userName + ": " + e.getMessage());
                }
                return new ServSearchResult(subServSearchMode, parentServRuntime, parentServRuntime);
            }
            logger.warn("IP-address not found " + userName + ": " + e.getMessage());
            return null;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Search child serv by address=" + userName);
        }
        if ((servRuntime = application.getInetServRuntimeMap().getByAddress(parentServRuntime, address, time.getTime(), withRoot)) == null && ifExist) {
            return new ServSearchResult(subServSearchMode, parentServRuntime, parentServRuntime);
        }
        return new ServSearchResult(subServSearchMode, parentServRuntime, servRuntime);
    }

    private Object findServRuntime(int servSearchMode, InetApplication application, RadiusListenerWorker<?> req, String userName, RadiusPacket request, Date time) throws BGException {
        switch (servSearchMode) {
            case 1: {
                InetDeviceRuntime agentDeviceRuntime = this.getAgentDeviceRuntime(application, req, request);
                if (logger.isDebugEnabled()) {
                    logger.debug("findServ agentDeviceRuntime=" + agentDeviceRuntime);
                }
                if (agentDeviceRuntime != null) {
                    int interfaceId = agentDeviceRuntime.getOption82InterfaceId(request);
                    logger.info("Search serv on deviceId=" + agentDeviceRuntime.inetDeviceId + "; interfaceId=" + interfaceId);
                    req.setCircuitId((Object)interfaceId);
                    return application.getInetServRuntimeMap().getByDevicePort(agentDeviceRuntime.inetDeviceId, interfaceId, time, null);
                }
                int interfaceId = this.deviceRuntime.getOption82InterfaceId(request);
                logger.info("Search serv on deviceId=" + this.deviceRuntime.inetDeviceId + "; interfaceId=" + interfaceId);
                req.setCircuitId((Object)interfaceId);
                return application.getInetServRuntimeMap().getByDevicePort(this.deviceRuntime.inetDeviceId, interfaceId, time);
            }
            case 2: {
                return this.searchOnVlan(application, req, this.deviceRuntime, false, request, time);
            }
            case 16: {
                return this.searchOnVlanWithAddress(application, req, this.deviceRuntime, false, request, userName, time);
            }
            case 4: {
                return this.searchOnVlan(application, req, this.deviceRuntime, true, request, time);
            }
            case 5: {
                return this.searchByMac(application, req, this.deviceRuntime, false, request, time);
            }
            case 6: {
                return this.searchByMac(application, req, this.deviceRuntime, true, request, time);
            }
            case 15: {
                InetDeviceRuntime agentDeviceRuntime = this.getAgentDeviceRuntime(application, req, request);
                if (logger.isDebugEnabled()) {
                    logger.debug("agentDeviceRuntime=" + agentDeviceRuntime);
                }
                if (agentDeviceRuntime != null) {
                    return this.searchByMac(application, req, agentDeviceRuntime, true, request, time);
                }
                return this.searchByMac(application, req, this.deviceRuntime, true, request, time);
            }
            case 10: {
                InetDeviceRuntime rootDevice = application.deviceMap.get(application.rootDeviceId);
                return this.searchByMac(application, req, rootDevice, true, request, time);
            }
            case 7: {
                InetServRuntime rootServRuntime;
                byte[] address = InetNas.ipAddress(userName);
                if (address == null) {
                    return null;
                }
                logger.info("Search by address=" + userName);
                InetServRuntime servRuntime = application.getInetServRuntimeMap().getByAddress(address, time);
                if (servRuntime != null && (rootServRuntime = servRuntime.getRootInetServRuntime(application)) != servRuntime) {
                    return new ServSearchResult(5, rootServRuntime, servRuntime);
                }
                return servRuntime;
            }
            case 9: {
                InetServRuntime rootServRuntime;
                byte[] address = InetNas.ipAddress(userName);
                if (address == null) {
                    return null;
                }
                InetDeviceRuntime agentDeviceRuntime = this.getAgentDeviceRuntime(application, req, request);
                if (logger.isDebugEnabled()) {
                    logger.debug("findServ agentDeviceRuntime=" + agentDeviceRuntime);
                }
                if (agentDeviceRuntime != null) {
                    InetServRuntime rootServRuntime2;
                    logger.info("Search by address=" + userName + " on agentDevice");
                    InetServRuntime servRuntime = application.getInetServRuntimeMap().getByAddress(address, time, agentDeviceRuntime.inetDeviceId, agentDeviceRuntime.descendantIds);
                    if (servRuntime != null && (rootServRuntime2 = servRuntime.getRootInetServRuntime(application)) != servRuntime) {
                        return new ServSearchResult(5, rootServRuntime2, servRuntime);
                    }
                    return servRuntime;
                }
                logger.info("Search by address=" + userName + " on device");
                InetServRuntime servRuntime = application.getInetServRuntimeMap().getByAddress(address, time, this.getId(), this.deviceRuntime.descendantIds);
                if (servRuntime != null && (rootServRuntime = servRuntime.getRootInetServRuntime(application)) != servRuntime) {
                    return new ServSearchResult(5, rootServRuntime, servRuntime);
                }
                return servRuntime;
            }
            case 13: {
                return this.searchByMacAndInterface(application, req, this.deviceRuntime, request, time);
            }
        }
        logger.info("Default search by username=" + userName);
        return application.getInetServRuntimeMap().getByUsername(userName, time, this.usernameIgnoreCase);
    }

    public void fanoutPacket(RadiusListenerWorker<?> req, RadiusPacket packet) {
        if (req.getAccountId() > 0) {
            this.fanout.fanout(req, packet, req.getAccountId());
            return;
        }
        RadiusSession radiusSession = req.getRadiusSession();
        if (radiusSession != null) {
            int servId = 0;
            Object login = radiusSession.login;
            if (login instanceof InetServRuntime) {
                servId = ((InetServRuntime)login).inetServId;
            }
            if (servId == 0 && login instanceof InetServ) {
                servId = ((InetServ)login).getId();
            }
            this.fanout.fanout(req, packet, servId);
        } else {
            super.fanoutPacket(req, packet);
        }
    }

    private static byte[] ipAddress(String userName) {
        try {
            InetAddress inetAddress = InetAddress.getByName(userName);
            return inetAddress.getAddress();
        }
        catch (Exception e) {
            if (logger.isInfoEnabled()) {
                logger.info("IP-address not found " + userName + ": " + e.getMessage());
            }
            return null;
        }
    }

    private InetServRuntime searchOnVlan(InetApplication application, RadiusListenerWorker<?> req, InetDeviceRuntime deviceRuntime, boolean deep, RadiusPacket request, Date time) throws BGException {
        InetDeviceRuntime agentDeviceRuntime = this.getAgentDeviceRuntime(application, req, request);
        if (agentDeviceRuntime == null) {
            agentDeviceRuntime = deviceRuntime;
        }
        int vlan = agentDeviceRuntime.getOption82VlanId(request);
        logger.info("Search serv on deviceId=" + agentDeviceRuntime.inetDeviceId + (deep ? " and children" : "") + "; vlanId=" + vlan);
        req.setCircuitId((Object)vlan);
        return application.getInetServRuntimeMap().getByDeviceVlan(agentDeviceRuntime.inetDeviceId, vlan, time, deep);
    }

    private Object searchOnVlanWithAddress(InetApplication application, RadiusListenerWorker<?> req, InetDeviceRuntime deviceRuntime, boolean deep, RadiusPacket request, String userName, Date time) throws BGException {
        byte[] address = InetNas.ipAddress(userName);
        if (address == null) {
            return null;
        }
        InetServRuntime vlanServRuntime = this.searchOnVlan(application, req, deviceRuntime, false, request, time);
        if (vlanServRuntime == null) {
            return null;
        }
        logger.info("Search by address=" + userName);
        InetServRuntime addressServRuntime = application.getInetServRuntimeMap().getByAddress(address, time);
        if (addressServRuntime == null) {
            logger.info("Not found by address");
            return null;
        }
        InetServRuntime vlanRootServRuntime = vlanServRuntime.getRootInetServRuntime(application);
        InetServRuntime addressRootServRuntime = addressServRuntime.getRootInetServRuntime(application);
        if (vlanRootServRuntime.inetServId != vlanRootServRuntime.inetServId) {
            logger.info("Vlan and address not in one inetServ");
            return null;
        }
        if (addressRootServRuntime != addressServRuntime) {
            return new ServSearchResult(5, addressRootServRuntime, addressServRuntime);
        }
        return addressRootServRuntime;
    }

    private InetServRuntime searchByMac(InetApplication application, RadiusListenerWorker<?> req, InetDeviceRuntime deviceRuntime, boolean deep, RadiusPacket request, Date time) throws BGException {
        byte[] macAddress = InetServ.parseMacAddress((String)((String)request.getOption(InetRadiusProcessor.MAC_ADDRESS)));
        if (logger.isDebugEnabled()) {
            logger.debug("Search by MAC-address on device: " + (deviceRuntime != null ? deviceRuntime.inetDeviceId : -1));
            logger.debug("Try to parse MAC-address as a string: " + (macAddress != null));
        }
        if (macAddress == null) {
            macAddress = (byte[])request.getOption(InetRadiusProcessor.MAC_ADDRESS_BYTES);
            if (logger.isDebugEnabled()) {
                logger.debug("Try to parse MAC-address as a byte array: " + (macAddress != null));
            }
        }
        if (macAddress == null) {
            logger.warn("MAC-address not found.");
            return null;
        }
        if (deep) {
            logger.info("Search by mac on device and descendants=" + Utils.bytesToString((byte[])macAddress, (boolean)false, null));
            return application.getInetServRuntimeMap().getByMacAddress(macAddress, time, deviceRuntime.inetDeviceId, deviceRuntime.descendantIds);
        }
        logger.info("Search by mac on device=" + Utils.bytesToString((byte[])macAddress, (boolean)false, null));
        return application.getInetServRuntimeMap().getByMacAddress(macAddress, time, deviceRuntime.inetDeviceId, Collections.emptySet());
    }

    private InetServRuntime searchByMacAndInterface(InetApplication application, RadiusListenerWorker<?> req, InetDeviceRuntime deviceRuntime, RadiusPacket request, Date time) throws BGException {
        int deviceId;
        int interfaceId;
        InetDeviceRuntime agentDeviceRuntime = this.getAgentDeviceRuntime(application, req, request);
        if (logger.isDebugEnabled()) {
            logger.debug("findServ agentDeviceRuntime=" + agentDeviceRuntime);
        }
        if (agentDeviceRuntime != null) {
            interfaceId = agentDeviceRuntime.getOption82InterfaceId(request);
            deviceId = agentDeviceRuntime.inetDeviceId;
        } else {
            interfaceId = deviceRuntime.getOption82InterfaceId(request);
            deviceId = deviceRuntime.inetDeviceId;
        }
        req.setCircuitId((Object)interfaceId);
        byte[] macAddress = InetServ.parseMacAddress((String)((String)request.getOption(InetRadiusProcessor.MAC_ADDRESS)));
        if (macAddress == null) {
            macAddress = (byte[])request.getOption(InetRadiusProcessor.MAC_ADDRESS_BYTES);
        }
        if (macAddress == null) {
            logger.warn("MAC-address not found.");
            return null;
        }
        logger.info("Search by mac " + Utils.bytesToString((byte[])macAddress, (boolean)false, null) + " on device=" + deviceId + " and interface=" + interfaceId);
        return application.getInetServRuntimeMap().getByMacAddressAndInterface(macAddress, time, deviceId, interfaceId);
    }

    public boolean isPasswordVerification(InetServTypeRuntime inetServTypeRuntime) {
        if (inetServTypeRuntime != null && inetServTypeRuntime.passwordVerification != null) {
            return inetServTypeRuntime.passwordVerification;
        }
        return this.passwordVerification;
    }

    public int getDisableServId(RadiusPacket request) {
        switch (this.disableServIds.size()) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.disableServIds.get(0);
            }
        }
        String key = request.getStringAttribute(-1, 31, null);
        if (Utils.isEmptyString((String)key)) {
            key = request.getStringAttribute(-1, 1, null);
            if (Utils.isEmptyString((String)key)) {
                return this.disableServIds.get(0);
            }
        } else if (key.indexOf(58) >= 0) {
            return this.disableServIds.get(Math.abs(Long.hashCode(InetUtils.macAddressToLong(key))) % this.disableServIds.size());
        }
        int h = key.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        return this.disableServIds.get(Math.abs(h) % this.disableServIds.size());
    }

    public List<Integer> getDisableServIds() {
        return this.disableServIds;
    }

    public void setFramedRoute(RadiusPacket response, byte[] ipAddress, List<IpNet> nets) {
        int size = nets.size();
        for (int i = 0; i < size; ++i) {
            IpNet net = nets.get(i);
            String framedRoute = this.framedRouteMacros.format(new StringBuffer(40), ipAddress, net).toString();
            response.addAttribute((RadiusAttribute)new RadiusAttribute.RadiusAttributeString(this.framedRouteVendor, this.framedRouteType, framedRoute));
        }
    }

    public int getSetMacAddress(InetServTypeRuntime inetServTypeRuntime) {
        return this.deviceRuntime.getSetMacAddress(inetServTypeRuntime);
    }

    public int getSetIdentifier(InetServTypeRuntime inetServTypeRuntime) {
        return this.deviceRuntime.getSetIdentifier(inetServTypeRuntime);
    }

    public int getServDeviceLink(InetServTypeRuntime inetServTypeRuntime) {
        return this.deviceRuntime.getServDeviceLink(inetServTypeRuntime);
    }

    public int getCheckDuplicateSession(InetServTypeRuntime inetServTypeRuntime) {
        if (inetServTypeRuntime.checkDuplicateSession != null) {
            return inetServTypeRuntime.checkDuplicateSession;
        }
        return this.checkDuplicateSession;
    }

    public boolean getCheckDuplicateSessionType(InetServTypeRuntime inetServTypeRuntime) {
        if (inetServTypeRuntime.checkDuplicateSessionType != null) {
            return inetServTypeRuntime.checkDuplicateSessionType;
        }
        return this.checkDuplicateSessionType;
    }

    public Set<Integer> getDescendantIds() {
        return this.deviceRuntime.descendantIds;
    }

    public long getRadiusAccessServLockTimeout() {
        return this.radiusAccessServLockTimeout;
    }

    public InetDeviceRuntime getDeviceRuntime() {
        return this.deviceRuntime;
    }

    public String getKeyPattern() {
        return this.keyPattern;
    }

    public boolean isAddressFromRequest() {
        return this.addressFromRequest;
    }

    public boolean isAddressFromRequestCheck() {
        return this.addressFromRequestCheck;
    }

    public long getParallelAccessRequestSkipTimeout() {
        return this.parallelAccessRequestSkipTimeout;
    }

    public boolean isAcctSessIdAlwaysPresent() {
        return this.acctSessIdAlwaysPresent;
    }

    public boolean isIpAlwaysPresent() {
        return this.ipAlwaysPresent;
    }

    public boolean isNasPortCorrect() {
        return this.nasPortCorrect;
    }

    public long getRadiusConnectionServiceTimeout() {
        return this.radiusConnectionServiceTimeout;
    }

    public boolean isConnectionAccessRequest() {
        return this.connectionAccessRequest;
    }

    public void addRejectRadiusAttributes(RadiusPacket response) {
        RadiusAttributeSet ras = (RadiusAttributeSet)this.getRealmAttributeMap().get(REALM_REJECT);
        if (ras == null || ras.isEmpty()) {
            return;
        }
        response.addAttributes(ras);
    }

    private static class IpReserve {
        IpResourceReserve reserve;
        IpResourceReserve prefixReserve;
        IpResourceReserve delegatedPrefixReserve;
        final long expire;

        public IpReserve(long expire) {
            this.expire = expire;
        }
    }

    class StartWithParentKey
    implements Map.Entry<String, StartWithParent>,
    Delayed {
        final long expire;
        final String parentAcctSessionId;
        final StartWithParent startLater;

        public StartWithParentKey(String parentAcctSessionId, StartWithParent startLater) {
            this.parentAcctSessionId = parentAcctSessionId;
            this.startLater = startLater;
            this.expire = startLater.time.getTime() + 10000L;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expire - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            StartWithParentKey x = (StartWithParentKey)other;
            long diff = this.expire - x.expire;
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }

        @Override
        public String getKey() {
            return this.parentAcctSessionId;
        }

        @Override
        public StartWithParent getValue() {
            return this.startLater;
        }

        @Override
        public StartWithParent setValue(StartWithParent value) {
            return this.startLater;
        }
    }

    class StartWithParent {
        final Date time;
        final RadiusPacket request;

        public StartWithParent(Date time, RadiusPacket request) {
            this.time = time;
            this.request = request;
        }
    }
}

