<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<fmt:setLocale value="RU"/>

<div class="tile">
	<div class="titleFont3 titleBottomLine">Список аккаунтов</div>
	<c:if test="${not empty inetAccountingPeriod}">
	<div style="margin-bottom: 20px;">
		<span class="paramColor inetAccountingPeriod" style="font-size: 0.9rem; font-weight: normal;">Учетный период: 
		<fmt:formatDate type="BOTH" dateStyle="SHORT" timeStyle="MEDIUM" value="${inetAccountingPeriod.dateFrom}"/> -
		<fmt:formatDate type="BOTH" dateStyle="SHORT" timeStyle="MEDIUM" value="${inetAccountingPeriod.dateTo}"/>
		[<c:choose><c:when test="${inetAccountingPeriod.active}">активный</c:when><c:otherwise>не активный</c:otherwise></c:choose>]</span>
	</div>
	</c:if>
	<c:choose>
		<c:when test="${not empty inetServList}">
		<c:forEach var="inetAccountItem" varStatus="inetAccountStatus" items="${inetServList}">
			<div class="flexRow itemBlock">
				<div class="flexRow" style="flex-direction: column;">
					<div class="titleFont2">${inetAccountItem.title}</div>
					<div class="flexRow itemBlockParams">
						<div class="paramColor" style="width: 13rem;">Статус: <span><c:choose><c:when test="${inetAccountItem.status == 0}">активный</c:when><c:when test="${inetAccountItem.status == 1}">закрыт</c:when><c:otherwise>заблокирован</c:otherwise></c:choose></span></div>
						<div class="paramColor" style="width: 13rem;">Состояние: <span><c:choose><c:when test="${inetAccountItem.deviceState == 1}">включен</c:when><c:otherwise>отключен</c:otherwise></c:choose></span></div>
						<div class="paramColor" style="width: 13rem;">Период: <span><fmt:formatDate type="DATE" dateStyle="SHORT" value="${inetAccountItem.dateFrom}"/> - <fmt:formatDate type="DATE" dateStyle="SHORT" value="${inetAccountItem.dateTo}"/></span></div>
						<div class="paramColor" style="width: 13rem;">Логин: <span>${inetAccountItem.login}</span></div>
					</div>
				</div>
				<div class="flexRow" style="align-content: center;">
					<div onclick="showBlock( 'inetRoot', 'changePassword', { ...inetQuery, accountId: ${inetAccountItem.id} } );"><img src="img/security.png" title="Смена пароля" class="iconButton"></div>
					<!--
					<div onclick="showBlock( 'inetRoot', 'sessionReport', { ...inetQuery, accountId: ${inetAccountItem.id} } );"><img src="img/money.png" title="Отчет по сессиям" class="iconButton"></div>
					-->
					<div onclick="showBlock( 'inetRoot', 'trafficReport', { ...inetQuery, accountId: ${inetAccountItem.id} } );"><img src="img/bargraph.png" title="Отчет по трафику" class="iconButton"></div>
				</div>
			</div>
			<c:if test="${not inetAccountStatus.last}"><div class="line"></div></c:if>
		</c:forEach>
		</c:when>
		<c:otherwise><div class="notFound" style="margin: 20px;">Данные не найдены</div></c:otherwise>
	</c:choose>
</div>
