<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<fmt:setLocale value="RU"/>

<div id="tariffOptionResult"></div>

<div class="tile tileTabs">
 	<c:forEach var="tariffOptionItem" varStatus="status" items="${currentTariffOptions}">
 		<div class="flexRow" style="font-size: 0.8rem;">
			<div style="margin-top: 10px; margin-left: 0px;">
				<div class="titleFont3" style="margin: 0px 0px 10px 0px;">Опция: ${tariffOptionItem.optionTitle}</div>
				<div style="margin-left: 10px; line-height: 1.2rem;">
					<div class="paramColor">Начало: <span><fmt:formatDate type="BOTH" dateStyle="SHORT" timeStyle="SHORT" value="${tariffOptionItem.timeFrom}"/></span></div>
					<div class="paramColor">Окончание: <span><fmt:formatDate type="BOTH" dateStyle="SHORT" timeStyle="SHORT" value="${tariffOptionItem.timeTo}"/></span></div>
				</div>
			</div>
			<div style="margin-top: 10px; margin-top: 10px; text-align: right;">
				<div class="paramColor" style="font-size: 0.7rem;">Стоимость за активацию:</div>
 				<div class="titleFont3"><fmt:formatNumber value="${tariffOptionItem.summa}" minFractionDigits="2"/><span class="CUR"></span></div>
				<div style="text-align: right;">
				<c:if test="${optionActivateModeMap[tariffOptionItem.id].deleteMode == 2 and futureOptions[tariffOptionItem.id]}"><button onclick="if ( confirm( &quot;Вы уверены, что хотите отменить опцию?&quot; ) ) { showBlock( 'tariffOptionResult', 'delete', { ...tariffOptionQuery, tariffOptionId: ${tariffOptionItem.id}, } ); return false; }">Отменить</button></c:if>
				<c:choose>
					<c:when test="${not empty tariffOptionItem.timeTo}">
						<c:if test="${optionActivateModeMap[tariffOptionItem.id].reactivationMode == 1}"><button onclick="if ( confirm( &quot;Вы уверены, что хотите реактивировать опцию?&quot; ) ) { showBlock( 'tariffOptionResult', 'reactivate', { ...tariffOptionQuery, tariffOptionId: ${tariffOptionItem.id} } ); return false; }">Реактивировать</button></c:if>
					</c:when>
					<c:otherwise><button onclick="if ( confirm( &quot;Вы уверены, что хотите деактивировать опцию?&quot; ) ) { showBlock( 'tariffOptionResult', 'deactivate', { ...tariffOptionQuery, tariffOptionId: ${tariffOptionItem.id} } ); return false; }">Деактивировать</button></c:otherwise>
				</c:choose>
				</div> 				
 			</div>
 		</div>
		<c:if test="${not status.last}"><div class="line"></div></c:if>
 	</c:forEach>
</div>
<div class="comment"><b>Стоимость активации</b> - сумма, снимаемая в момент активации опции и не отражает периодической платы за пользование, если таковая предусмотрена в тарифном плане.</div>
