/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.common.bean;

import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import ru.bitel.bgbilling.kernel.directory.api.common.DirectoryItem;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.oss.kernel.directories.address.common.event.HouseModifiedEvent;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;

@DirectoryItem(eventClass=HouseModifiedEvent.class, serviceClass=AddressService.class)
public class House
extends Id {
    private int cityId;
    private String cityTitle;
    private int areaId;
    private String areaTitle;
    private int streetId;
    private String streetTitle;
    private int quarterId;
    private String quarterTitle;
    private int house;
    private String frac;
    private String comment;
    private String postIndex;
    private int amount;
    private Map<String, String> params;

    @XmlAttribute
    public int getCityId() {
        return this.cityId;
    }

    public void setCityId(int cityId) {
        this.cityId = cityId;
    }

    @XmlAttribute
    public int getAreaId() {
        return this.areaId;
    }

    public void setAreaId(int areaId) {
        this.areaId = areaId;
    }

    @XmlAttribute
    public int getStreetId() {
        return this.streetId;
    }

    public void setStreetId(int streetId) {
        this.streetId = streetId;
    }

    @XmlAttribute
    public int getQuarterId() {
        return this.quarterId;
    }

    public void setQuarterId(int quarterId) {
        this.quarterId = quarterId;
    }

    @XmlAttribute
    public int getHouse() {
        return this.house;
    }

    public void setHouse(int house) {
        this.house = house;
    }

    @XmlAttribute
    public String getFrac() {
        return this.frac;
    }

    public void setFrac(String frac) {
        this.frac = frac;
    }

    public void setHouseAndFrac(String houseAndFrac) {
        this.frac = "";
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < houseAndFrac.length(); ++i) {
            char ch = houseAndFrac.charAt(i);
            if (!Character.isDigit(ch)) {
                this.frac = houseAndFrac.substring(i);
                break;
            }
            str.append(ch);
        }
        this.house = Utils.parseInt(str.toString(), 0);
    }

    public static Object[] getHouseAndFrac(String houseAndFrac) {
        String frac = "";
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < houseAndFrac.length(); ++i) {
            char ch = houseAndFrac.charAt(i);
            if (!Character.isDigit(ch)) {
                frac = houseAndFrac.substring(i);
                break;
            }
            str.append(ch);
        }
        return new Object[]{Utils.parseInt(str.toString(), 0), frac};
    }

    @XmlAttribute
    public String getHouseFrac() {
        StringBuilder buf = new StringBuilder();
        if (this.house > 0) {
            buf.append(this.house);
        }
        if (this.frac != null && !this.frac.isEmpty()) {
            if (Character.isDigit(this.frac.charAt(0))) {
                buf.append('/');
            }
            buf.append(this.frac);
        }
        return buf.toString();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @XmlAttribute
    public String getPostIndex() {
        return this.postIndex;
    }

    public void setPostIndex(String postIndex) {
        this.postIndex = postIndex;
    }

    @XmlAttribute
    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    @XmlAttribute
    public String getCityTitle() {
        return this.cityTitle;
    }

    public void setCityTitle(String cityTitle) {
        this.cityTitle = cityTitle;
    }

    @XmlAttribute
    public String getAreaTitle() {
        return this.areaTitle;
    }

    public void setAreaTitle(String areaTitle) {
        this.areaTitle = areaTitle;
    }

    @XmlAttribute
    public String getStreetTitle() {
        return this.streetTitle;
    }

    public void setStreetTitle(String streetTitle) {
        this.streetTitle = streetTitle;
    }

    @XmlAttribute
    public String getQuarterTitle() {
        return this.quarterTitle;
    }

    public void setQuarterTitle(String quarterTitle) {
        this.quarterTitle = quarterTitle;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("id=");
        buf.append(this.id);
        buf.append("; areaId=");
        buf.append(this.areaId);
        buf.append("; streetId=");
        buf.append(this.streetId);
        buf.append("; quarterId=");
        buf.append(this.quarterId);
        buf.append("; house=");
        buf.append(this.house);
        buf.append("; frac=");
        buf.append(this.frac);
        buf.append("; postIndex=");
        buf.append(this.postIndex);
        buf.append("; amount=");
        buf.append(this.amount);
        buf.append("; comment=");
        buf.append(this.comment);
        return buf.toString();
    }
}

