/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server;

import bitel.billing.common.VersionInfo;
import bitel.billing.server.AdminPortListener;
import bitel.billing.server.ApplicationModule;
import bitel.billing.server.MyAccessLogValve;
import bitel.billing.server.admin.errorlog.AlarmSender;
import bitel.billing.server.admin.errorlog.bean.AlarmErrorMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.servlet.Servlet;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Valve;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.descriptor.web.ErrorPage;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.scan.StandardJarScanner;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.server.errorlog.DatabaseCheckTask;
import ru.bitel.bgbilling.kernel.admin.server.errorlog.LicCheckTask;
import ru.bitel.bgbilling.kernel.admin.server.errorlog.MQCheckTask;
import ru.bitel.bgbilling.kernel.base.converters.BGConverter;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.dynamic.server.ReadWriteClassManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ServerStartEvent;
import ru.bitel.bgbilling.kernel.event.processors.ServerEventProcessor;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.OnDestroyServer;
import ru.bitel.bgbilling.kernel.update.server.LibInfoUtil;
import ru.bitel.bgbilling.server.api.DynamicExecutor;
import ru.bitel.bgbilling.server.api.HttpService;
import ru.bitel.bgbilling.server.installer.library.LibraryEventListener;
import ru.bitel.bgbilling.server.installer.server.ComponentUpdate;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.logging.Log4j2;
import ru.bitel.common.logging.LoggingPrintStream;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.oss.kernel.directories.domain.server.DomainRuntimeMap;
import ru.bitel.oss.kernel.job.server.JobScheduler;

public class Server
extends Tomcat {
    private static Logger log = null;
    private static Setup setup;
    private StandardContext rootContext;
    public static final Date START_TIME;
    public static final String DEFAULT_CONTEXT_PATH = "/bgbilling";

    public static void main(String[] args) {
        Log4j2.init((String)"data");
        log = LogManager.getLogger();
        Preferences setup = new Preferences("data.data");
        int adminPort = setup.getInt("port.admin", 2005);
        if (args.length > 0) {
            if (args[0].trim().equals("start")) {
                new Server();
            } else {
                Server.executeCommand(args, adminPort);
            }
        } else {
            Server.showHelp();
        }
    }

    public Server() {
        BGNestedContext.push((String)"server");
        LoggingPrintStream.assignToOutput();
        String catalinaHome = ServerUtils.getServerHome();
        this.setBaseDir(catalinaHome);
        log.info("catalina.base = " + catalinaHome);
        Server.checkFiles(new String[]{"custom.css"});
        Server.checkFiles(new String[]{"js", "custom.js"});
        Server.initSetup();
        new ComponentUpdate(setup);
        LibInfoUtil.getClientLibInfos();
        try {
            log.info("Starting BGBillingServer...");
            System.getProperties().setProperty("networkaddress.cache.ttl", "3600");
            String hostname = setup.get("server.host.name", "localhost.localdomain");
            this.getEngine().setDefaultHost(hostname);
            this.getHost().setName(hostname);
            this.getHost().setAppBase(catalinaHome + "/webroot");
            String contextPath = setup.get("context.path", DEFAULT_CONTEXT_PATH);
            this.rootContext = (StandardContext)this.addWebapp(contextPath, catalinaHome + "/webroot");
            this.rootContext.setDefaultWebXml(catalinaHome + "/data/default.web.xml");
            this.rootContext.setReloadable(false);
            this.rootContext.setWorkDir("tmp");
            this.rootContext.setUseNaming(false);
            this.rootContext.setSessionTimeout(setup.getInt("context.session.timeout", 30));
            this.rootContext.setIgnoreAnnotations(true);
            this.addResources(catalinaHome);
            StandardJarScanner standardJarScanner = (StandardJarScanner)this.rootContext.getJarScanner();
            standardJarScanner.setScanManifest(false);
            standardJarScanner.setScanClassPath(false);
            standardJarScanner.setJarScanFilter((type, name) -> name.endsWith("-server.jar"));
            ParameterMap errorPages = setup.sub("server.error.");
            for (Map.Entry me : errorPages.entrySet()) {
                ErrorPage errorPage = new ErrorPage();
                errorPage.setErrorCode(Utils.parseInt((String)((String)me.getKey())));
                errorPage.setLocation((String)me.getValue());
                this.rootContext.addErrorPage(errorPage);
            }
            this.rootContext.addValve((Valve)new MyAccessLogValve());
            this.initConnectors();
            try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)setup, (boolean)true);){
                DomainRuntimeMap.getInstance(connectionSet);
            }
            ServerEventProcessor serverEventProcessor = new ServerEventProcessor(setup);
            AlarmSender.initSender(setup);
            AlarmSender.registerAlarmTask(new DatabaseCheckTask());
            AlarmSender.registerAlarmTask(new LicCheckTask());
            AlarmSender.registerAlarmTask(new MQCheckTask());
            try {
                Utils.checkJava();
            }
            catch (BGException e) {
                AlarmSender.sendAlarm(new AlarmErrorMessage("bad.java", "\u0421\u0435\u0440\u0432\u0435\u0440: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430\u044f Java", e.getMessage()), System.currentTimeMillis());
            }
            if (setup.get("no.event.process", null) == null) {
                ReadWriteClassManager manager = new ReadWriteClassManager();
                DynamicClassManager.setInstance(manager);
                if (setup.getInt("dynamic.checkOnStart", 1) > 0) {
                    new Thread(() -> {
                        try {
                            Thread.sleep(20000L);
                        }
                        catch (InterruptedException e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                        manager.recompileAll();
                    }, "dyn-class-test").start();
                }
            }
            this.initKernel();
            this.initModules();
            this.initPlugins();
            serverEventProcessor.start();
            new AdminPortListener(setup, setup.getInt("port.admin", 2005));
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Server.onServerShutdown();
                }
            });
            System.setProperty("java.protocol.handler.pkgs", "bitel.billing.common.protocol");
            System.setProperty("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE", "true");
            log.info("start...");
            this.run\u0421onverters(setup);
            this.start();
            new LibraryEventListener();
            EventProcessor.getInstance().publish(new ServerStartEvent());
            JobScheduler.getInstance("reserve", 0);
            JobScheduler.getInstance("contract_period", 0);
            log.info("Start BGBillingServer OK");
        }
        catch (Exception ex) {
            log.error("HTTP server start alarm: " + ex.getMessage() + " exiting...");
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private void initModules() {
        Connection con = setup.getDBConnectionFromPool();
        ModuleCache.removeModuleInstalledFlag(con);
        log.info("Browsing installed modules... and Creating installed modules map...");
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (BGInstalledModule module : ModuleCache.getInstance().getInstalledModulesList()) {
            if (!"module".equals(module.getType())) continue;
            String moduleName = module.getName();
            int lastIndex = moduleName.lastIndexOf(46);
            moduleName = lastIndex > -1 ? moduleName.substring(lastIndex + 1) : moduleName;
            VersionInfo versionInfo = VersionInfo.getVersionInfo((String)moduleName);
            if (versionInfo != null && versionInfo.getVersion() != null && versionInfo.getVersion().trim().length() > 0) {
                log.info("Module " + module.getName() + " ver. " + versionInfo.getVersionString());
            } else {
                log.info("Module " + module.getName() + " ver." + module.getVersion());
            }
            map2.put(module.getName(), module.getPackageServer());
            this.setServletAndFilters(module.getPackageServer() + ".servlet");
        }
        this.rootContext.getServletContext().setAttribute("installed_modules_map", map2);
        try {
            javax.naming.Context env = Setup.getEnvironment();
            for (BGModule module : ModuleCache.getInstance().getModulesList()) {
                ApplicationModule applicationModule;
                javax.naming.Context ctx = null;
                try {
                    ctx = (javax.naming.Context)env.lookup(String.valueOf(module.getId()));
                }
                catch (Exception versionInfo) {
                    // empty catch block
                }
                if (ctx == null) {
                    ctx = env.createSubcontext(String.valueOf(module.getId()));
                }
                if ((applicationModule = ModuleCache.getInstance().getApplicationModule(module.getName())) == null) continue;
                try {
                    applicationModule.start(con, module);
                }
                catch (BGException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (NamingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        ServerUtils.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initPlugins() {
        Connection con = setup.getDBConnectionFromPool();
        try {
            BGPluginManagerServer bgPluginManagerServer = BGPluginManagerServer.getManager();
            bgPluginManagerServer.init(con, "server");
            log.info("Browsing installed plugins...");
            for (Map.Entry<String, BGPluginServer> plugin : bgPluginManagerServer.getPluginsMap().entrySet()) {
                String pluginName = plugin.getKey();
                int lastIndex = pluginName.lastIndexOf(46);
                pluginName = lastIndex > -1 ? pluginName.substring(lastIndex + 1) : pluginName;
                VersionInfo versionInfo = VersionInfo.getVersionInfo((String)pluginName);
                if (versionInfo != null && versionInfo.getVersion() != null && versionInfo.getVersion().trim().length() > 0) {
                    log.info("Plugin " + plugin.getKey() + " ver. " + versionInfo.getVersionString());
                } else {
                    log.info("Plugin " + plugin.getKey() + " ver. ???");
                }
                this.setServletAndFilters(plugin.getValue().getPackServer() + ".servlet");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    private void run\u0421onverters(Setup setup) {
        List<Class<?>> classes = ServerUtils.getClassList("ru.bitel.bgbilling.kernel.base.converters");
        for (Class<?> clazz : classes) {
            if (!BGConverter.class.isAssignableFrom(clazz) || clazz.getSuperclass() == null) continue;
            try {
                BGConverter converter = (BGConverter)Utils.newInstance((String)clazz.getName(), clazz);
                if (converter == null) continue;
                converter.runConverter(setup.getDBConnection());
            }
            catch (BGException e) {
                log.error((Object)e);
            }
        }
    }

    public static void setSetup(Setup setup) {
        Server.setup = setup;
        UserMap.initUserMap();
    }

    public static void initSetup() {
        if (setup != null) {
            return;
        }
        setup = new Setup("data.data");
        Setup.setSetup(setup);
        UserMap.initUserMap();
    }

    public static void exit() {
        Server.main(new String[]{"stop"});
    }

    private static void executeCommand(String[] args, int port) {
        try {
            StringBuffer command = new StringBuffer(args[0]);
            for (int i = 1; i < args.length; ++i) {
                command.append(" ");
                command.append(args[i]);
            }
            byte[] data = command.toString().getBytes("ISO-8859-1");
            DatagramPacket packet = new DatagramPacket(data, data.length);
            packet.setAddress(InetAddress.getByName("127.0.0.1"));
            packet.setPort(port);
            DatagramSocket socket = new DatagramSocket();
            socket.send(packet);
            byte[] buffer = new byte[1000000];
            DatagramPacket responsePacket = new DatagramPacket(buffer, buffer.length);
            socket.setSoTimeout(3000);
            socket.receive(responsePacket);
            socket.close();
            System.out.println(new String(responsePacket.getData(), 0, responsePacket.getLength(), "ISO-8859-1"));
        }
        catch (Exception ex) {
            System.err.println("Port " + port + " unavailable");
        }
    }

    private static void showHelp() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nUsage: [start|stop|status|sysvar|javavar|conpool|help]");
        sb.append("\nParameters:");
        sb.append("\n\t help                       - show this help");
        sb.append("\n\t start                      - starting BGBillingServer");
        sb.append("\n\t stop                       - stopping BGBillingServer");
        sb.append("\n\t sysvar                     - show system variables");
        sb.append("\n\t javavar                    - show java properties");
        sb.append("\n\t conpool                    - show connection pool trace, need option db.trace=1 in data.properties");
        sb.append("\n\t diskBenchmark           - disk benchmark");
        sb.append("\n\nExample: application.sh start");
        sb.append("\nExample: application.sh status");
        System.out.println(sb.toString());
    }

    private void initKernel() {
        this.setServletAndFilters("ru.bitel.bgbilling.kernel.base.server.servlet");
        String customServletPackage = setup.get("custom.servlet.package");
        if (customServletPackage != null) {
            log.info("Add custom servlet from " + customServletPackage);
            this.setServletAndFilters(customServletPackage);
        }
    }

    private void addResources(String catalinaHome) {
        StandardRoot resourceRoot = new StandardRoot((Context)this.rootContext);
        this.rootContext.setResources((WebResourceRoot)resourceRoot);
        resourceRoot.setCachingAllowed(true);
        this.rootContext.setDelegate(true);
    }

    private void initConnectors() {
        this.getService().removeConnector(this.getConnector());
        String connectorHttp = null;
        connectorHttp = setup.get("connector.http");
        log.info("HTTP Connector: " + connectorHttp);
        if (connectorHttp != null) {
            String maxThreads = setup.get("connector.http.thread.max", "100");
            String compression = setup.get("connector.http.compression", "off");
            for (String connectorHttpItem : connectorHttp.split(",")) {
                int port;
                int pos = (connectorHttpItem = connectorHttpItem.trim()).lastIndexOf(58);
                if (pos <= -1) continue;
                String host = connectorHttpItem.substring(0, pos);
                if ("*".equals(host)) {
                    String string = host = "true".equals(System.getProperty("java.net.preferIPv4Stack")) ? "0.0.0.0" : "::";
                }
                if ((port = Utils.parseInt((String)connectorHttpItem.substring(pos + 1), (int)-1)) <= 0) continue;
                log.info("Starting HTTP connector " + host + ":" + port + "...");
                Connector connector = new Connector();
                IntrospectionUtils.setProperty((Object)connector, (String)"address", (String)host);
                connector.setPort(port);
                connector.setEnableLookups(false);
                connector.setProperty("maxThreads", maxThreads);
                connector.setProperty("compression", compression);
                connector.setProperty("compressionMinSize", "2048");
                connector.setProperty("compressableMimeType", "text/xml");
                connector.setProperty("sendReasonPhrase", "true");
                this.setCommonConnectorOptions(connector);
                this.getService().addConnector(connector);
            }
        }
        String connectorHttps = setup.get("connector.https");
        log.info("HTTPS Connector: " + connectorHttps);
        if (connectorHttps != null) {
            String connectorHttpsThreadMax = setup.get("connector.https.thread.max", "10");
            String sslEnabledProtocols = setup.get("connector.https.sslEnabledProtocols", null);
            String sslCiphers = setup.get("connector.https.ciphers", null);
            for (String connectorHttpsItem : connectorHttps.split(",")) {
                int port;
                int pos = (connectorHttpsItem = connectorHttpsItem.trim()).lastIndexOf(58);
                if (pos <= -1) continue;
                String host = connectorHttpsItem.substring(0, pos);
                if ("*".equals(host)) {
                    String string = host = "true".equals(System.getProperty("java.net.preferIPv4Stack")) ? "0.0.0.0" : "::";
                }
                if ((port = Utils.parseInt((String)connectorHttpsItem.substring(pos + 1), (int)-1)) <= 0) continue;
                log.info("Starting HTTPS connector " + host + ":" + port + "...");
                String password = setup.get("keystore.password", "bgbilling");
                String alias = setup.get("keystore.alias");
                Connector connector = new Connector();
                IntrospectionUtils.setProperty((Object)connector, (String)"address", (String)host);
                connector.setPort(port);
                connector.setEnableLookups(false);
                connector.setScheme("https");
                connector.setProperty("SSLEnabled", "true");
                connector.setProperty("maxThreads", connectorHttpsThreadMax);
                connector.setProperty("sendReasonPhrase", "true");
                SSLHostConfig sslConfig = new SSLHostConfig();
                sslConfig.setCertificateKeystoreFile("data" + File.separatorChar + ".keystore");
                sslConfig.setCertificateKeystorePassword(password);
                if (alias != null) {
                    sslConfig.setCertificateKeyAlias(alias);
                }
                if (this.checkTrustStoreNotEmpty(password)) {
                    log.info("Found public certificates in keystore. Set as truststore.");
                    sslConfig.setTruststoreFile("data" + File.separatorChar + ".keystore");
                    sslConfig.setTruststorePassword(password);
                } else {
                    log.info("Not found public certificates in keystore. Skip as truststore.");
                    sslConfig.setTruststorePassword(password);
                }
                sslConfig.setCertificateVerification("want");
                connector.addSslHostConfig(sslConfig);
                this.setCommonConnectorOptions(connector);
                if (sslEnabledProtocols != null) {
                    connector.setProperty("sslEnabledProtocols", sslEnabledProtocols);
                }
                if (sslCiphers != null) {
                    connector.setProperty("ciphers", sslCiphers);
                }
                this.getService().addConnector(connector);
            }
        }
    }

    private void setCommonConnectorOptions(Connector connector) {
        this.rootContext.setSessionCookiePath("/");
        connector.setUseBodyEncodingForURI(true);
        connector.setMaxPostSize(setup.getInt("max.post.size", 10000000));
        connector.setMaxSavePostSize(1000000);
    }

    private boolean checkTrustStoreNotEmpty(String password) {
        char[] passw = password.toCharArray();
        try {
            KeyStore store = KeyStore.getInstance("JKS");
            store.load(new FileInputStream("data" + File.separatorChar + ".keystore"), passw);
            Enumeration<String> aliases = store.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!store.isCertificateEntry(alias)) continue;
                return true;
            }
        }
        catch (FileNotFoundException store) {
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private void setServletFilter(final Map<String, WebFilter> filtersMap) {
        ArrayList sortKeys = new ArrayList();
        filtersMap.keySet().forEach(e -> sortKeys.add(e));
        Collections.sort(sortKeys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int sort1 = Utils.parseInt((String)Server.this.getSort((WebFilter)filtersMap.get(o1)), (int)Integer.MAX_VALUE);
                int sort2 = Utils.parseInt((String)Server.this.getSort((WebFilter)filtersMap.get(o2)), (int)Integer.MAX_VALUE);
                return sort1 - sort2;
            }
        });
        for (String filterClass : sortKeys) {
            WebFilter webFilter = filtersMap.get(filterClass);
            String filterName = webFilter.filterName();
            String[] mappings = webFilter.urlPatterns();
            FilterDef filterDef = new FilterDef();
            filterDef.setFilterName(filterName);
            filterDef.setFilterClass(filterClass);
            for (WebInitParam webInitParam : webFilter.initParams()) {
                filterDef.addInitParameter(webInitParam.name(), webInitParam.value());
            }
            this.rootContext.addFilterDef(filterDef);
            for (String string : mappings) {
                FilterMap filterMap = new FilterMap();
                filterMap.addURLPattern(string);
                filterMap.setFilterName(filterName);
                this.rootContext.addFilterMap(filterMap);
                log.info("Add mapping: " + filterClass + " to " + string);
            }
        }
    }

    private String getSort(WebFilter webFilter) {
        String sort = "";
        for (WebInitParam webInitParam : webFilter.initParams()) {
            if (!"sort".equals(webInitParam.name())) continue;
            sort = webInitParam.value();
        }
        return sort;
    }

    public void addServlet(String servletName, String servletClass, String[] mappings) {
        if (mappings != null && servletClass != null) {
            try {
                Class<?> clazz;
                Object servlet = (Servlet)Utils.newInstance((String)servletClass, Servlet.class);
                if (servlet == null && (clazz = DynamicClassManager.getInstance().loadClass(servletClass)) != null && HttpService.class.isAssignableFrom(clazz)) {
                    servlet = new DynamicExecutor(servletClass);
                }
                if (servlet != null) {
                    servletName = servletName != null ? servletName : servletClass;
                    Wrapper wrapper = this.rootContext.createWrapper();
                    wrapper.setName(servletName);
                    wrapper.setServletClass(servletClass);
                    wrapper.setServlet(servlet);
                    this.rootContext.addChild((Container)wrapper);
                    for (String mapping : mappings) {
                        this.rootContext.addServletMappingDecoded(mapping, servletName);
                        log.info("Add mapping: " + servletClass + " to " + mapping);
                    }
                }
            }
            catch (Exception e) {
                log.error("Error while init class " + servletClass, (Throwable)e);
            }
        }
    }

    private static void onServerShutdown() {
        for (OnDestroyServer p : BGPluginManagerServer.getManager().getInvokeables(OnDestroyServer.class, false)) {
            p.onDestroyServer("server");
        }
    }

    private static void checkFiles(String[] customFileName) {
        Path webrootPath = Paths.get("webroot", new String[0]);
        if (Files.exists(webrootPath, new LinkOption[0])) {
            Path customPath = Paths.get(webrootPath.toString(), customFileName);
            if (!Files.exists(customPath, new LinkOption[0])) {
                try {
                    Files.createFile(customPath, new FileAttribute[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.out.println(webrootPath.toString() + " not found!");
        }
    }

    private void setServletAndFilters(String packageName) {
        HashMap<String, WebFilter> filtersMap = new HashMap<String, WebFilter>();
        for (Class<?> clazz : ServerUtils.getClassList(packageName)) {
            String className = clazz.getName();
            if (clazz.isAnnotationPresent(WebServlet.class)) {
                WebServlet webServlet = clazz.getAnnotation(WebServlet.class);
                this.addServlet(webServlet.name(), className, webServlet.urlPatterns());
            }
            if (!clazz.isAnnotationPresent(WebFilter.class)) continue;
            filtersMap.put(className, clazz.getAnnotation(WebFilter.class));
        }
        this.setServletFilter(filtersMap);
    }

    static {
        START_TIME = new Date();
    }
}

