/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.bgsecure.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.kernel.module.common.bean.BGSAction;

public class UserPermitionsManager {
    private Connection con;
    private static final String TABLE_NAME = "bgs_user_action";

    public UserPermitionsManager(Connection con) {
        this.con = con;
    }

    public List<BGSAction> getUserActions(int userId) {
        ArrayList<BGSAction> result = new ArrayList<BGSAction>();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM bgs_user_action WHERE uid=?");){
            ps.setInt(1, userId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                BGSAction action = new BGSAction();
                this.loadFromRS(rs, action);
                result.add(action);
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateUserActions(int userId, List<BGSAction> values) {
        PreparedStatement ps;
        try {
            ps = this.con.prepareStatement("DELETE FROM bgs_user_action WHERE uid=?");
            try {
                ps.setInt(1, userId);
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ps = this.con.prepareStatement("INSERT INTO bgs_user_action SET uid=?, mid=?, aid=?");
            try {
                ps.setInt(1, userId);
                for (BGSAction action : values) {
                    ps.setString(2, action.mid);
                    ps.setInt(3, action.actionID);
                    ps.executeUpdate();
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadFromRS(ResultSet rs, BGSAction action) throws SQLException {
        action.mid = rs.getString("mid");
        action.actionID = rs.getInt("aid");
    }
}

