/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.resource.bean;

import bitel.billing.server.admin.resource.bean.ResourceCategory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ResourceCategoryManager<T extends ResourceCategory<T>> {
    protected Connection con;
    protected String tableName;

    public ResourceCategoryManager(Connection con, int mid) {
        this.con = con;
        this.tableName = this.getTableName() + "_" + mid;
    }

    public List<T> getCategoryTree() {
        ArrayList<T> result = new ArrayList<T>();
        try {
            HashMap<Integer, List<T>> byParentMap = new HashMap<Integer, List<T>>();
            String query = "SELECT * FROM " + this.tableName + " ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                T category = this.getCategoryFromRs(rs);
                int parentId = ((ResourceCategory)category).getParentId();
                if (parentId == 0) {
                    result.add(category);
                    continue;
                }
                ArrayList<T> childList = (ArrayList<T>)byParentMap.get(parentId);
                if (childList == null) {
                    childList = new ArrayList<T>(10);
                    byParentMap.put(parentId, childList);
                }
                childList.add(category);
            }
            rs.close();
            ps.close();
            this.setChilds(result, byParentMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private void setChilds(List<T> categories, Map<Integer, List<T>> byParentMap) {
        for (ResourceCategory category : categories) {
            List<T> childList = byParentMap.get(category.getId());
            if (childList == null) continue;
            category.setSubCategories(childList);
            this.setChilds(childList, byParentMap);
        }
    }

    public int getSubCount(int categoryId) {
        int result = 0;
        try {
            String query = "SELECT COUNT(*) FROM " + this.tableName + " WHERE parent_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, categoryId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected void loadStandartCategoryFields(ResultSet rs, T category) throws Exception {
        ((ResourceCategory)category).setId(rs.getInt("id"));
        ((ResourceCategory)category).setParentId(rs.getInt("parent_id"));
        ((ResourceCategory)category).setTitle(rs.getString("title"));
        ((ResourceCategory)category).setComment(rs.getString("comment"));
    }

    public T getCategory(int id) {
        T result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getCategoryFromRs(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void deleteCategory(int id) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract String getTableName();

    protected abstract T getCategoryFromRs(ResultSet var1);
}

