/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action.web;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ChargeEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

@Deprecated
public class ActionDistributeBalance
extends ActionBase {
    private ContractManager contractManager = null;
    private BalanceUtils bu = null;
    private BigDecimal debt;

    @Override
    public void doAction() throws SQLException, BGException {
        if (this.cid <= 0) {
            throw new BGIllegalArgumentException();
        }
        this.contractManager = new ContractManager(this.con);
        Contract contract = this.contractManager.getContractById(this.cid);
        if (contract == null) {
            this.setWebErrorMessage("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u043a\u043e\u0434\u043e\u043c " + this.cid + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
            return;
        }
        this.bu = new BalanceUtils(this.con);
        this.debt = contract.getBalanceMode() == 0 ? this.bu.getSaldo(new Date(), contract.getId()) : this.bu.getBalance(new Date(), contract.getId());
        int commit = this.getIntParameter("commit", 0);
        if (commit > 0) {
            Date date = new Date();
            BigDecimal summa = BigDecimal.ZERO;
            ArrayList<Payment> payments = new ArrayList<Payment>();
            ArrayList<Charge> charges = new ArrayList<Charge>();
            int paymentTransferType = this.setup.getInt("transfer.payment.type", 0);
            int chargeTransferType = this.setup.getInt("transfer.charge.type", 0);
            if (paymentTransferType == 0 || chargeTransferType == 0) {
                Element free = this.createElement(this.rootNode, "free");
                free.setAttribute("amount", Utils.formatBigDecimalSumm((BigDecimal)this.debt));
                this.dataMap.put("error", "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0430 \u0441\u0440\u0435\u0434\u0441\u0442\u0432. \u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438.");
                this.setWebErrorMessage("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0430 \u0441\u0440\u0435\u0434\u0441\u0442\u0432. \u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438.");
                this.setData();
                return;
            }
            for (Contract contract2 : this.contractManager.getSubContracts(this.cid, 1)) {
                Element free;
                BigDecimal amount = this.getBigDecimalParameter(String.valueOf(contract2.getId()), BigDecimal.ZERO);
                if ((summa = summa.add(amount)).compareTo(this.debt) > 0) {
                    free = this.createElement(this.rootNode, "free");
                    free.setAttribute("amount", Utils.formatBigDecimalSumm((BigDecimal)this.debt));
                    this.dataMap.put("error", "\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0435 \u0441\u0443\u043c\u043c\u044b \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u044e\u0442 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0435 \u0441\u0440\u0435\u0434\u0441\u0442\u0432\u0430 \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430!");
                    this.setWebErrorMessage("\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0435 \u0441\u0443\u043c\u043c\u044b \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u044e\u0442 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0435 \u0441\u0440\u0435\u0434\u0441\u0442\u0432\u0430 \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430!");
                    this.setData();
                    return;
                }
                if (amount.compareTo(BigDecimal.ZERO) >= 0) {
                    if (amount.compareTo(BigDecimal.ZERO) <= 0) continue;
                    Payment p = new Payment();
                    p.setContractId(contract2.getId());
                    p.setDate(date);
                    p.setUserId(-1);
                    p.setTypeId(paymentTransferType);
                    p.setSum(amount);
                    p.setComment("\u041f\u0435\u0440\u0435\u043d\u043e\u0441 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0441 \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
                    payments.add(p);
                    Charge superCharge = new Charge();
                    superCharge.setDate(date);
                    superCharge.setTypeId(chargeTransferType);
                    superCharge.setContractId(this.cid);
                    superCharge.setUserId(-1);
                    superCharge.setSum(amount);
                    superCharge.setComment("\u041f\u0435\u0440\u0435\u043d\u043e\u0441 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043d\u0430 \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + contract2.getTitle() + " ( " + contract2.getComment() + " )");
                    charges.add(superCharge);
                    continue;
                }
                free = this.createElement(this.rootNode, "free");
                free.setAttribute("amount", Utils.formatBigDecimalSumm((BigDecimal)this.debt));
                this.dataMap.put("error", "\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043c\u0435\u043d\u044c\u0448\u0435 \u043d\u0443\u043b\u044f!");
                this.setWebErrorMessage("\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043c\u0435\u043d\u044c\u0448\u0435 \u043d\u0443\u043b\u044f!");
                this.setData();
                return;
            }
            ChargeDao chargeManager = new ChargeDao(this.con);
            for (Charge charge : charges) {
                chargeManager.update(charge);
                this.bu.updateBalance(date, this.cid);
                this.context.publishAfterCommit(new ChargeEvent(0, charge));
                this.context.publishAfterCommit(new ContractBalanceChangedEvent(charge.getContractId(), 4, charge.getSum()));
            }
            ServerUtils.commitConnection(this.con);
            PaymentDao paymentDao = new PaymentDao(this.con);
            for (Payment payment : payments) {
                paymentDao.update(payment);
                this.bu.updateBalance(date, payment.getContractId());
                this.context.publishAfterCommit(new PaymentEvent(0, payment));
                this.context.publishAfterCommit(new ContractBalanceChangedEvent(payment.getContractId(), 3, payment.getSum()));
            }
            this.bu.updateBalance(date, this.cid);
            this.debt = this.debt.subtract(summa);
        }
        this.setData();
        this.bu.close();
    }

    private void addContract(Contract contract, Element data) throws DOMException, BGException {
        Element row = this.createElement(data, "sub");
        row.setAttribute("cid", String.valueOf(contract.getId()));
        row.setAttribute("title", contract.getTitle());
        row.setAttribute("comment", contract.getComment());
        if (contract.getBalanceMode() == 0) {
            row.setAttribute("debt", Utils.formatBigDecimalSumm((BigDecimal)this.bu.getSaldo(new Date(), contract.getId())));
        } else {
            row.setAttribute("debt", Utils.formatBigDecimalSumm((BigDecimal)this.bu.getBalance(new Date(), contract.getId())));
        }
    }

    @Override
    protected void setDataForXslt() throws DOMException, BGException {
        Element table = this.createElement(this.rootNode, "subs");
        for (Contract subContract : this.contractManager.getSubContracts(this.cid, 1)) {
            this.addContract(subContract, table);
        }
        Element free = this.createElement(this.rootNode, "free");
        free.setAttribute("amount", Utils.formatBigDecimalSumm((BigDecimal)this.debt));
    }

    @Override
    protected void setDataToRequest() throws BGException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (Contract contract : this.contractManager.getSubContracts(this.cid, 1)) {
            String[] str = new String[]{String.valueOf(contract.getId()), contract.getTitle(), contract.getComment(), contract.getBalanceMode() == 0 ? Utils.formatBigDecimalSumm((BigDecimal)this.bu.getSaldo(new Date(), contract.getId())) : Utils.formatBigDecimalSumm((BigDecimal)this.bu.getBalance(new Date(), contract.getId()))};
            list.add(str);
        }
        this.dataMap.put("subs", list);
        this.dataMap.put("freeAmoun", Utils.formatBigDecimalSumm((BigDecimal)this.debt));
    }
}

