/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.script.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.script.common.bean.Script;

public class ScriptManager {
    private Connection con;

    public ScriptManager(Connection con) {
        this.con = con;
    }

    public List<Script> getScriptList() {
        ArrayList<Script> result = new ArrayList<Script>();
        try {
            String query = "SELECT * FROM script ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Script script = new Script();
                this.loadScriptFromRS(script, rs);
                result.add(script);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public Map<Integer, Script> getScriptMap() {
        HashMap<Integer, Script> result = new HashMap<Integer, Script>();
        try {
            String query = "SELECT * FROM script ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Script script = new Script();
                this.loadScriptFromRS(script, rs);
                result.put(script.getId(), script);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public Script getScriptById(int id) {
        Script result = null;
        try {
            String query = "SELECT * FROM script WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new Script();
                this.loadScriptFromRS(result, rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public Script getScriptByID(int id) {
        return this.getScriptById(id);
    }

    public void deleteScript(int id) {
        try {
            String query = "DELETE FROM script WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadScriptFromRS(Script script, ResultSet rs) throws SQLException {
        script.setId(rs.getInt("id"));
        script.setTitle(rs.getString("title"));
    }
}

