/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff;

import bitel.billing.server.tariff.TariffTreeBuilder;
import bitel.billing.server.tariff.TariffTreeNode;
import java.util.HashMap;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public final class TariffModuleTree {
    private TariffTreeNode _rootNode;
    private HashMap<String, Class<?>> typesClasses = new HashMap();
    private int _treeID = -1;
    private int _mid = -1;
    private String _module;
    private long _lmTimeAtInit = -1L;
    private long _lmTimeAtCheck = -1L;

    public TariffModuleTree(String module, int treeID, int mid) {
        this._module = module;
        this._treeID = treeID;
        this._mid = mid;
    }

    public boolean load(TariffTreeBuilder tariffTreeBuilder) {
        boolean result = false;
        if (this.init(tariffTreeBuilder, this._module)) {
            result = this.loadTree(tariffTreeBuilder, this._treeID, this._mid);
            this._lmTimeAtInit = tariffTreeBuilder.getLastModificationTimeForTree(this._treeID, this._mid);
            this._lmTimeAtCheck = System.currentTimeMillis() + 2200L;
        }
        return result;
    }

    public long getTimeAtInit() {
        return this._lmTimeAtInit;
    }

    public boolean hasRootNode() {
        return this._rootNode != null;
    }

    public int getTreeId() {
        return this._treeID;
    }

    public int getMid() {
        return this._mid;
    }

    public boolean isActual(TariffTreeBuilder tariffTreeBuilder) {
        boolean result;
        long millis = System.currentTimeMillis();
        if (this._lmTimeAtCheck >= millis) {
            return true;
        }
        boolean bl = result = this._lmTimeAtInit == tariffTreeBuilder.getLastModificationTimeForTree(this._treeID, this._mid);
        if (result) {
            this._lmTimeAtCheck = millis;
        }
        return result;
    }

    private boolean init(TariffTreeBuilder tariffTreeBuilder, String module) {
        boolean result = false;
        String refStr = null;
        try {
            refStr = new String(tariffTreeBuilder.getModuleTariffConfig(module), "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (refStr != null) {
            this.loadChildsClasses(XMLUtils.parseDocument(refStr));
            result = true;
        }
        return result;
    }

    private boolean loadTree(TariffTreeBuilder tariffTreeBuilder, int treeId, int moduleId) {
        boolean result = false;
        Element tree = XMLUtils.newDocument().createElement("tree");
        result = tariffTreeBuilder.addMTreeItems(treeId, moduleId, tree, true, 0);
        if (result) {
            NodeList nodeList = tree.getElementsByTagName("item");
            int size = nodeList.getLength();
            HashMap<Integer, Vector<TariffTreeNode>> childsByParents = new HashMap<Integer, Vector<TariffTreeNode>>();
            for (int i = 0; i < size; ++i) {
                Element item = (Element)nodeList.item(i);
                int id = Utils.parseInt((String)item.getAttribute("id"), (int)-1);
                String type = item.getAttribute("type");
                String data = item.getAttribute("data");
                int deep = Integer.parseInt(item.getAttribute("deep"));
                int parent = Integer.parseInt(item.getAttribute("parent"));
                TariffTreeNode node = this.createNode(type);
                if (node != null) {
                    node.init(data, deep, id);
                    if (parent == 0) {
                        this._rootNode = node;
                        continue;
                    }
                    Vector<TariffTreeNode> childs = childsByParents.get(parent);
                    if (childs == null) {
                        childs = new Vector();
                        childsByParents.put(parent, childs);
                    }
                    childs.add(node);
                    continue;
                }
                System.err.println("\u041d\u0435 \u0441\u043e\u0437\u0434\u0430\u043d \u0443\u0437\u0435\u043b: " + type);
            }
            if (this._rootNode != null) {
                this._rootNode.loadChilds(null, childsByParents);
            }
        }
        return result;
    }

    private void loadChildsClasses(Document doc) {
        if (doc != null) {
            for (Element item : XMLUtils.selectElements((Node)doc.getDocumentElement(), (String)"/data/tree/node")) {
                String type = item.getAttribute("type");
                String className = item.getAttribute("class2");
                try {
                    this.typesClasses.put(type, Class.forName(className));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private TariffTreeNode createNode(String type) {
        TariffTreeNode result = null;
        Class<?> clazz = this.typesClasses.get(type);
        if (clazz != null) {
            try {
                result = (TariffTreeNode)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public void processRequest(TariffRequest request) {
        if (this._rootNode != null) {
            this._rootNode.processRequest(request);
        } else {
            request.addError("Root node for tariff wasn't found!");
        }
    }
}

