/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.webmenu.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.webmenu.client.WebMenuEditor;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.GuiTitlable;

public class WebContractSearchConfig
extends BGUPanel {
    private WebMenuEditor webMenuEditor;
    private JTabbedPane tabbedPane;
    private BGUList<ListItem> avaibleSearchModules;
    private BGUList<ListItem> restoreSearchModules;
    private BGUList<ListItem> paymentSearchModules;
    private JSONArray modules;

    public WebContractSearchConfig(WebMenuEditor webMenuEditor) {
        this.webMenuEditor = webMenuEditor;
    }

    protected void jbInit() throws Exception {
        this.restoreSearchModules = new BGUList();
        this.restoreSearchModules.setCellRenderer((ListCellRenderer)new SearchModuleCellRenderer());
        this.paymentSearchModules = new BGUList();
        this.paymentSearchModules.setCellRenderer((ListCellRenderer)new SearchModuleCellRenderer());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add((Component)this.getListPanel(this.restoreSearchModules), "\u0412\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0430");
        this.tabbedPane.add((Component)this.getListPanel(this.paymentSearchModules), "\u041e\u043f\u043b\u0430\u0442\u0430");
        this.tabbedPane.addChangeListener(e -> this.performAction("refresh"));
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, (Component)this.tabbedPane, (Component)this.getAvaiblePanel(), 800L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel getAvaiblePanel() {
        this.avaibleSearchModules = new BGUList();
        this.avaibleSearchModules.setCellRenderer((ListCellRenderer)new SearchModuleCellRenderer());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 11, 3, new Insets(25, 10, 0, 15), 0, 0));
        panel.add((Component)new JLabel("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043f\u043e\u0438\u0441\u043a\u043e\u0432\u044b\u0435 \u043c\u043e\u0434\u0443\u043b\u0438"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.avaibleSearchModules), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getButtonPanel() {
        JButton addButton = new JButton("<<<");
        addButton.addActionListener(a -> this.addDelSearchModule(this.avaibleSearchModules, "true"));
        JButton delButton = new JButton(">>>");
        delButton.addActionListener(a -> this.addDelSearchModule(this.tabbedPane.getSelectedIndex() == 0 ? this.restoreSearchModules : this.paymentSearchModules, "false"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)addButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)delButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 11, 2, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private void addDelSearchModule(BGUList<ListItem> modules, String value) {
        int index = this.tabbedPane.getSelectedIndex();
        modules.getSelectedValuesList().forEach(i -> {
            JSONArray params = i.jsonObject.optJSONArray("params");
            params.forEach(p -> {
                JSONObject paramJson = (JSONObject)p;
                if (index == 0 && "use.for.access.restore".equals(paramJson.optString("key"))) {
                    paramJson.put("value", (Object)value);
                } else if (index == 1 && "use.for.payment".equals(paramJson.optString("key"))) {
                    paramJson.put("value", (Object)value);
                }
            });
            try {
                this.webMenuEditor.getWebMenuService().updateContractSearchModuleParams(i.jsonObject.getString("className"), i.jsonObject.optJSONArray("params"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.performAction("refresh");
    }

    private JPanel getListPanel(BGUList<ListItem> modules) {
        modules.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    WebContractSearchConfig.this.performAction("edit");
                }
            }
        });
        Dimension dimension = new Dimension(400, 200);
        JScrollPane scrollPane = new JScrollPane((Component)modules);
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u043f\u043e\u0438\u0441\u043a\u043e\u0432\u044b\u0435 \u043c\u043e\u0434\u0443\u043b\u0438"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 3, 3, 3), 0, 0));
        return panel;
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                int tabId = WebContractSearchConfig.this.tabbedPane.getSelectedIndex();
                ArrayList avaibleData = new ArrayList();
                ArrayList restoreData = new ArrayList();
                ArrayList paymentData = new ArrayList();
                WebContractSearchConfig.this.modules = WebContractSearchConfig.this.webMenuEditor.getWebMenuService().getContractSearchModuleList();
                WebContractSearchConfig.this.modules.forEach(a -> {
                    JSONObject json = (JSONObject)a;
                    JSONArray array = json.optJSONArray("params");
                    array.forEach(b -> {
                        JSONObject paramJson = (JSONObject)b;
                        if ("use.for.access.restore".equals(paramJson.optString("key"))) {
                            if ("true".equals(paramJson.optString("value"))) {
                                restoreData.add(new ListItem(json));
                            } else if (tabId == 0) {
                                avaibleData.add(new ListItem(json));
                            }
                        }
                        if ("use.for.payment".equals(paramJson.optString("key"))) {
                            if ("true".equals(paramJson.optString("value"))) {
                                paymentData.add(new ListItem(json));
                            } else if (tabId == 1) {
                                avaibleData.add(new ListItem(json));
                            }
                        }
                    });
                });
                WebContractSearchConfig.this.restoreSearchModules.setData(restoreData);
                WebContractSearchConfig.this.paymentSearchModules.setData(paymentData);
                WebContractSearchConfig.this.avaibleSearchModules.setData(avaibleData);
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                int index = WebContractSearchConfig.this.tabbedPane.getSelectedIndex();
                BGUList<ListItem> selectedList = index == 0 ? WebContractSearchConfig.this.restoreSearchModules : WebContractSearchConfig.this.paymentSearchModules;
                ListItem listItem = (ListItem)selectedList.getSelectedValue();
                if (listItem != null) {
                    new ContractSeachParamEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043f\u043e\u0438\u0441\u043a\u043e\u0432\u043e\u0433\u043e \u043c\u043e\u0434\u0443\u043b\u044f", listItem.jsonObject).getDialog().setVisible(true);
                }
            }
        };
    }

    class SearchModuleCellRenderer
    extends DefaultListCellRenderer {
        private JPanel panel;
        private JLabel title = new JLabel();
        private JLabel className = new JLabel();

        public SearchModuleCellRenderer() {
            this.title.setFont(this.title.getFont().deriveFont(1).deriveFont(this.title.getFont().getSize2D() * 1.3f));
            Color fgColor = UIManager.getColor("TextField.inactiveForeground");
            this.className.setForeground(fgColor);
            this.panel = new JPanel(new GridBagLayout());
            this.panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.getPropertyPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        }

        private JPanel getPropertyPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.className, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            panel.setOpaque(false);
            return panel;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ListItem listItem = (ListItem)value;
            this.title.setText(listItem.jsonObject.optString("title"));
            this.className.setText("\u041a\u043b\u0430\u0441\u0441: " + listItem.jsonObject.optString("className"));
            this.panel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            return this.panel;
        }
    }

    class ListItem
    implements GuiTitlable {
        JSONObject jsonObject;

        public ListItem(JSONObject jsonObject) {
            this.jsonObject = jsonObject;
        }

        public String toString() {
            return this.jsonObject.toString();
        }

        public String getGuiTitle() {
            return this.jsonObject.toString();
        }
    }

    class ParamTableCellRenderer
    implements TableCellRenderer {
        ParamTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JSONObject jsonObject = (JSONObject)((ParamTableModel)((Object)table.getModel())).getRows().get(row);
            if ("BOOLEAN".equals(jsonObject.optString("type", ""))) {
                JCheckBox component = (JCheckBox)table.getDefaultRenderer(Boolean.class).getTableCellRendererComponent(table, Boolean.valueOf((String)value), isSelected, hasFocus, row, column);
                component.setHorizontalAlignment(2);
                component.setBorder(new EmptyBorder(1, 5, 1, 1));
                return component;
            }
            return table.getDefaultRenderer(String.class).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class ContractSeachParamEditor
    extends BGEditorDialog<JSONObject> {
        private ParamTableModel paramTableModel;

        public ContractSeachParamEditor(String title, JSONObject data) {
            super(title, (Object)data);
        }

        public void doDialogPanel() {
            this.paramTableModel = new ParamTableModel();
            BGUTable table = new BGUTable((TableModel)((Object)this.paramTableModel));
            table.setSelectionMode(0);
            table.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JSONObject jsonObject;
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && (jsonObject = (JSONObject)ContractSeachParamEditor.this.paramTableModel.getSelectedRow()) != null && "BOOLEAN".equals(jsonObject.optString("type"))) {
                        jsonObject.put("value", (Object)String.valueOf(Boolean.valueOf(jsonObject.optString("value")) == false));
                        ContractSeachParamEditor.this.paramTableModel.fireTableDataChanged();
                    }
                }
            });
            Dimension dimension = new Dimension(1000, 400);
            JScrollPane scrollPane = new JScrollPane((Component)table);
            scrollPane.setMinimumSize(dimension);
            scrollPane.setPreferredSize(dimension);
            this.panel.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0438\u0441\u043a\u043e\u0432\u043e\u0433\u043e \u043c\u043e\u0434\u0443\u043b\u044f"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 20, 0), 0, 0));
            ArrayList rows = new ArrayList();
            if (((JSONObject)this.data).has("params")) {
                ((JSONObject)this.data).optJSONArray("params").forEach(a -> {
                    if (!((JSONObject)a).optString("key").startsWith("use.for.")) {
                        rows.add((JSONObject)a);
                    }
                });
            }
            this.paramTableModel.setData(rows);
        }

        public boolean doApply() throws Exception {
            try {
                WebContractSearchConfig.this.webMenuEditor.getWebMenuService().updateContractSearchModuleParams(((JSONObject)this.data).getString("className"), ((JSONObject)this.data).optJSONArray("params"));
                return true;
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return false;
            }
        }
    }

    class ParamTableModel
    extends BGTableModel<JSONObject> {
        public ParamTableModel() {
            super(ParamTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 200, 250, 300, "key", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 200, 300, -1, "value", true, new ParamTableCellRenderer());
        }

        public Object getValue(JSONObject val, int column) throws BGException {
            return val.optString(this.getIdentifier(column));
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1 && "STRING".equals(((JSONObject)this.getRows().get(rowIndex)).optString("type"));
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            ((JSONObject)this.getRows().get(rowIndex)).put("value", value);
        }
    }
}

