/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.common.bean;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAttribute;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.TreeNode;

public class AbstractGeographicCode<N extends AbstractGeographicCode<N>>
extends IdTitle
implements TreeNode<N> {
    protected String code;
    protected String prefix;
    protected String[] range;
    protected List<N> children;
    private String comment;
    private int destinationId;
    private String destination;
    private static final Pattern pattern = Pattern.compile("^(\\d+)\\s*\\(\\s*(\\d+)\\s*-\\s*(\\d+)\\s*\\)$");

    public String getCode() {
        return this.code;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String[] getRange() {
        return this.range;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCode(String code) {
        this.code = code;
        if (code.endsWith(")")) {
            Matcher m = pattern.matcher(code);
            if (!m.matches()) throw new IllegalArgumentException(code);
            this.prefix = m.group(1);
            this.range = new String[]{m.group(2), m.group(3)};
            return;
        } else {
            this.prefix = code;
            this.range = null;
        }
    }

    public List<N> getChildren() {
        return this.children;
    }

    public void setChildren(List<N> children) {
        this.children = children;
    }

    @XmlAttribute(name="d")
    public int getDestinationId() {
        return this.destinationId;
    }

    public void setDestinationId(int destinationId) {
        this.destinationId = destinationId;
    }

    @XmlAttribute(name="dt")
    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    @XmlAttribute(name="c")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void addChild(N child) {
        if (this.children == null) {
            this.children = new ArrayList<N>();
        }
        this.children.add(child);
    }

    public N findCode(String code) {
        if (this.code.equals(code)) {
            return (N)((Object)this);
        }
        if (this.children != null) {
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                AbstractGeographicCode child = (AbstractGeographicCode)((Object)this.children.get(i));
                if (!AbstractGeographicCode.matches(code, child)) continue;
                return child.findCode(code);
            }
        }
        return (N)((Object)this);
    }

    public Iterable<N> findCodeIterator(final String code) {
        final AbstractGeographicCode root = this;
        return new Iterable<N>(){

            @Override
            public Iterator<N> iterator() {
                return new Iterator<N>(){
                    private N next;
                    {
                        this.next = root;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public N next() {
                        Object next = this.next;
                        if (((AbstractGeographicCode)((Object)next)).children != null) {
                            int size = ((AbstractGeographicCode)((Object)next)).children.size();
                            for (int i = 0; i < size; ++i) {
                                AbstractGeographicCode child = (AbstractGeographicCode)((Object)((AbstractGeographicCode)((Object)next)).children.get(i));
                                if (!AbstractGeographicCode.matches(code, child)) continue;
                                this.next = child;
                                break;
                            }
                        }
                        return next;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public N[] findCodePath(String code) {
        ArrayList result = new ArrayList();
        this.findCodePath(code, result);
        AbstractGeographicCode[] r = (AbstractGeographicCode[])Array.newInstance(((Object)((Object)this)).getClass(), result.size());
        r = result.toArray(r);
        return r;
    }

    void findCodePath(String code, List<N> path) {
        path.add((N)((Object)this));
        if (this.code.equals(code)) {
            return;
        }
        if (this.children != null) {
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                AbstractGeographicCode child = (AbstractGeographicCode)((Object)this.children.get(i));
                if (!AbstractGeographicCode.matches(code, child)) continue;
                child.findCodePath(code, path);
                return;
            }
        }
    }

    protected static boolean matches(String code, AbstractGeographicCode<?> child) {
        if (code.startsWith(child.prefix)) {
            if (child.range != null) {
                int length = child.prefix.length() + child.range[0].length();
                if (code.length() < length) {
                    return false;
                }
                String suffix = code.substring(child.prefix.length(), length);
                if (suffix.compareTo(child.range[0]) < 0 || suffix.compareTo(child.range[1]) > 0) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.code;
    }
}

