/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.tariff.server;

import java.math.BigDecimal;
import ru.bitel.bgbilling.kernel.base.phone.tariff.server.AbstractPhoneServiceCost;
import ru.bitel.bgbilling.kernel.base.phone.tariff.server.AbstractPhoneTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.worker.ThreadContext;

public abstract class CallTypeCostTariffTreeNode
extends DefaultTariffTreeNode<AbstractPhoneTariffRequest<AbstractPhoneServiceCost>, TariffContext> {
    public static final int COST_TYPE_MIN = 1;
    public static final int COST_TYPE_CALL = 2;
    public static final int COST_SOURCE_NODE = 1;
    public static final int COST_SOURCE_CDR = 2;
    public static final int COST_SOURCE_COSTMAP = 3;
    private final int callType;
    private final boolean clientCost;
    private final BigDecimal cost;
    private boolean isDefault = false;
    private int costType = 1;
    private int costSource = 1;

    protected CallTypeCostTariffTreeNode(int id, ParameterMap parameterMap, boolean clientCost, int callType) {
        super(id, parameterMap);
        this.callType = parameterMap.getInt("callType", callType);
        this.clientCost = clientCost;
        BigDecimal cost = null;
        try {
            String source;
            cost = parameterMap.getBigDecimal("cost", null);
            boolean bl = this.isDefault = parameterMap.get("default", null) != null;
            if ("call".equals(parameterMap.get("cost_type", null))) {
                this.costType = 2;
            }
            if ((source = parameterMap.get("cost_source", null)) != null) {
                if ("cdr".equals(source)) {
                    this.costSource = 2;
                } else if ("costMap".equals(source)) {
                    this.costSource = 3;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cost == null) {
            try {
                cost = parameterMap.getBigDecimal("", BigDecimal.ZERO);
                this.isDefault = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cost = cost;
    }

    @Override
    public int execute(Long treeNodeId, Long parentTreeNodeId, AbstractPhoneTariffRequest<AbstractPhoneServiceCost> req, TariffTreeNodeHolder holder, TariffContext ctx, TreeContext treeContext, ThreadContext workerContext) {
        int result = 0;
        if (req.getCallType() == this.callType) {
            BigDecimal cost;
            int costSource;
            Object serviceCost = this.clientCost ? (AbstractPhoneServiceCost)req.serviceCost : req.operServiceCost;
            boolean acceptInParent = ((AbstractPhoneServiceCost)serviceCost).acceptLevel > holder.level;
            boolean acceptDefault = ((AbstractPhoneServiceCost)serviceCost).acceptDefault;
            if (this.costSource == 3) {
                costSource = 1;
                BigDecimal bdCost = req.costMapCost;
                if (bdCost != null) {
                    cost = bdCost;
                    ((AbstractPhoneServiceCost)serviceCost).costMapItemId = req.costMapItemId;
                } else {
                    cost = this.cost;
                }
            } else if (this.costSource == 2 && this.clientCost) {
                costSource = this.costSource;
                cost = req.getClientCdrCost();
            } else {
                costSource = this.costSource;
                cost = this.cost;
            }
            if (!this.isDefault) {
                req.setAccepted(true);
                ((AbstractPhoneServiceCost)serviceCost).cost = cost;
                ((AbstractPhoneServiceCost)serviceCost).costType = this.costType;
                ((AbstractPhoneServiceCost)serviceCost).costSource = costSource;
                ((AbstractPhoneServiceCost)serviceCost).acceptLevel = -1;
                ((AbstractPhoneServiceCost)serviceCost).acceptDefault = false;
            } else if (((AbstractPhoneServiceCost)serviceCost).cost == null || acceptDefault && acceptInParent) {
                req.setAccepted(true);
                ((AbstractPhoneServiceCost)serviceCost).cost = cost;
                ((AbstractPhoneServiceCost)serviceCost).costType = this.costType;
                ((AbstractPhoneServiceCost)serviceCost).costSource = costSource;
                ((AbstractPhoneServiceCost)serviceCost).acceptLevel = holder.level;
                ((AbstractPhoneServiceCost)serviceCost).acceptDefault = true;
            }
        }
        return this.postExecute(treeNodeId, parentTreeNodeId, req, holder, ctx, treeContext, workerContext, result);
    }

    @Override
    protected final int executeImpl(Long treeNodeId, AbstractPhoneTariffRequest<AbstractPhoneServiceCost> req, TariffContext ctx) {
        throw new UnsupportedOperationException();
    }
}

