/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractNotification;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class ContractNotificationDao
extends AbstractIdDao<ContractNotification> {
    private static final Logger logger = LogManager.getLogger();
    private static final String TABLE_NAME = "contract_notification";

    public ContractNotificationDao(Connection con) {
        super(con, 0, TABLE_NAME);
    }

    public List<ContractNotification> list(int contractId) throws BGException {
        return super.list("cid=?", "dt DESC", new Object[]{contractId});
    }

    public int getUnreadNotificationsCount(int cid) {
        int count = 0;
        try {
            String query = "SELECT COUNT(id) FROM contract_notification WHERE cid=? AND is_read=0";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            ps.close();
        }
        catch (SQLException e) {
            logger.error("ContractNotificationManager.getNewNotificationsCount( " + cid + " )", (Throwable)e);
        }
        return count;
    }

    protected ContractNotification getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractNotification notice = new ContractNotification();
        notice.setId(rs.getInt("id"));
        notice.setContractId(rs.getInt("cid"));
        notice.setDateTime(rs.getTimestamp("dt"));
        notice.setSubject(rs.getString("subject"));
        notice.setMessage(rs.getString("message"));
        notice.setRead(rs.getBoolean("is_read"));
        return notice;
    }

    protected void updateImpl(ContractNotification notice) throws BGException, SQLException {
        PreparedStatement ps;
        if (notice.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO contract_notification SET subject=?, message=?, cid=?, dt=NOW()", 1);
            ps.setInt(3, notice.getContractId());
        } else {
            ps = this.con.prepareStatement("UPDATE contract_notification SET subject=?, message=?, is_read=? WHERE id=?");
            ps.setInt(3, notice.isRead() ? 1 : 0);
            ps.setInt(4, notice.getId());
        }
        ps.setString(1, notice.getSubject());
        ps.setString(2, notice.getMessage());
        ps.executeUpdate();
        if (notice.getId() <= 0) {
            notice.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    public boolean markReadNotification(int contractId, int id) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE contract_notification SET is_read=? WHERE id=? AND cid=?");
            ps.setInt(1, 1);
            ps.setInt(2, id);
            ps.setInt(3, contractId);
            boolean result = ps.executeUpdate() > 0;
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

