/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean.parameter;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.parameter.ContractParameterGroupAttrDao;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class ContractParameterGroupDao
extends AbstractIdDao<ContractParameterGroup>
implements Directory<ContractParameterGroup> {
    private ContractParameterGroupAttrDao attrDao;

    public ContractParameterGroupDao(Connection con) {
        super(con, 0, "contract_parameter_group_name");
        this.attrDao = new ContractParameterGroupAttrDao(con);
    }

    protected ContractParameterGroup getFromRS(ResultSet rs) throws SQLException, BGException {
        List<ContractParameterGroupAttr> attrList;
        ContractParameterGroup result = new ContractParameterGroup();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        List<ContractParameterGroupAttr> bases = attrList = this.attrDao.list(result.getId());
        result.setAttributeList(bases);
        return result;
    }

    protected void updateImpl(ContractParameterGroup b) throws BGException, SQLException {
        String query = null;
        PreparedStatement ps = null;
        if (b.getId() <= 0) {
            query = "INSERT INTO " + this.tableName + " (title) VALUES (?)";
            ps = this.con.prepareStatement(query, 1);
        } else {
            query = "UPDATE " + this.tableName + " SET title=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(2, b.getId());
        }
        ps.setString(1, b.getTitle());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    protected int deleteImpl(int id) throws BGException, SQLException {
        this.checkContractUsed(id);
        this.checkContractPatternUsed(id);
        int result = super.deleteImpl(id);
        PreparedStatement ps = this.con.prepareStatement("DELETE FROM contract_parameter_group WHERE gid=?");
        ps.setInt(1, id);
        ps.executeUpdate();
        return result;
    }

    private void checkContractUsed(int id) throws SQLException, BGMessageException {
        boolean found = false;
        PreparedStatement ps = this.con.prepareStatement("SELECT id FROM contract WHERE pgid=? LIMIT 1");
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            found = true;
        }
        rs.close();
        ps.close();
        if (found) {
            throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0433\u0440\u0443\u043f\u043f\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u0445.");
        }
    }

    private void checkContractPatternUsed(int id) throws SQLException, BGMessageException {
        boolean found = false;
        PreparedStatement ps = this.con.prepareStatement("SELECT id FROM contract_pattern WHERE pgid=? LIMIT 1");
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            found = true;
        }
        rs.close();
        ps.close();
        if (found) {
            throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0433\u0440\u0443\u043f\u043f\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u0448\u0430\u0431\u043b\u043e\u043d\u0430\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430.");
        }
    }

    public void recycle() throws BGException {
        super.recycle();
    }

    @Override
    public ContractParameterGroup get(String title) throws BGException {
        return (ContractParameterGroup)((Object)super.get("title=?", new Object[]{title}));
    }

    @Override
    public List<ContractParameterGroup> list() throws BGException {
        return super.list(null, null, new Object[0]);
    }
}

