/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.param.client;

import bitel.billing.module.contract.ContractEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.BGClient;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.Customer;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.RowData;

public class CustomerSelectDialog {
    private Customer.CustomerType customerType;
    private int selectCustomerId = 0;
    private BGOptionPane optionPane;
    private ClientContext clientContext;
    private JButton selectButton = new JButton("\u0412\u044b\u0431\u0440\u0430\u0442\u044c");
    private CustomerSearchTableModel customerSearchTableModel = null;

    public CustomerSelectDialog(ClientContext clientContext) {
        this.customerType = Customer.CustomerType.defineType(clientContext.getCustomer().optString("personType"));
        this.clientContext = clientContext;
        JButton cancelButton = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        this.selectButton.setEnabled(false);
        this.optionPane = new BGOptionPane((Object)this.getCustomerSearchPanel(), "\u0412\u044b\u0431\u043e\u0440 \u043a\u043b\u0438\u0435\u043d\u0442\u0430", new JButton[]{this.selectButton, cancelButton});
        this.selectButton.addActionListener(e -> {
            RowData rowData = (RowData)this.customerSearchTableModel.getSelectedRow();
            this.selectCustomerId = rowData == null ? 0 : rowData.getJson().optInt("id");
            this.getDialog().setVisible(false);
        });
        cancelButton.addActionListener(e -> this.getDialog().setVisible(false));
        this.getDialog().setVisible(true);
        this.getDialog().dispose();
    }

    private JPanel getCustomerSearchPanel() {
        this.customerSearchTableModel = new CustomerSearchTableModel(this.customerType);
        BGUTable table = new BGUTable((TableModel)((Object)this.customerSearchTableModel));
        table.setSelectionMode(0);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    CustomerSelectDialog.this.selectButton.doClick();
                    CustomerSelectDialog.this.getDialog().setVisible(false);
                }
            }
        });
        table.getSelectionModel().addListSelectionListener(e -> this.selectButton.setEnabled(this.customerSearchTableModel.getSelectedRow() != null));
        Dimension dimension = new Dimension(700, 300);
        JScrollPane scrollPane = new JScrollPane((Component)table);
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getCustomerSearchFilterPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getCustomerSearchFilterPanel() {
        final JTextField search = new JTextField(25);
        search.setHorizontalAlignment(0);
        final JCheckBox customeFromOpenContract = new JCheckBox("\u043a\u043b\u0438\u0435\u043d\u0442\u044b \u0438\u0437 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
        customeFromOpenContract.addActionListener(e -> {
            search.setEnabled(!customeFromOpenContract.isSelected());
            this.searchCustomer(customeFromOpenContract.isSelected(), search.getText());
        });
        search.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                String text = search.getText().trim();
                if (!text.isEmpty() && e.getKeyCode() == 10) {
                    CustomerSelectDialog.this.searchCustomer(customeFromOpenContract.isSelected(), text);
                }
            }
        });
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)search, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)customeFromOpenContract, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    private void searchCustomer(boolean customeFromOpenContract, String text) {
        ArrayList<RowData> data = new ArrayList<RowData>();
        if (customeFromOpenContract) {
            HashSet<Integer> customerIds = new HashSet<Integer>();
            for (Component component : BGClient.getFrame().getTabbedPane().getComponents()) {
                ContractEditor contractEditor;
                int customerId;
                if (!(component instanceof ContractEditor) || (customerId = (contractEditor = (ContractEditor)component).getContext().getCustomerId()) <= 0 || customerIds.contains(customerId)) continue;
                JSONObject customerJson = contractEditor.getContext().getCustomer();
                String personType = customerJson.optString("personType");
                if (this.customerType == Customer.CustomerType.JUR_CUSTOMER && "u".equals(personType)) {
                    JSONObject jurCustomer = new JSONObject();
                    jurCustomer.put("id", customerId);
                    jurCustomer.put("title", customerJson.optQuery(Customer.CustomerJur.NAME.key()));
                    jurCustomer.put("inn", customerJson.optQuery(Customer.CustomerJur.INN.key()));
                    jurCustomer.put("ogrn", customerJson.optQuery(Customer.CustomerJur.OGRN.key()));
                    data.add(new RowData(jurCustomer));
                    customerIds.add(customerId);
                    continue;
                }
                if (this.customerType != Customer.CustomerType.FIZ_CUSTOMER || !"f".equals(personType)) continue;
                StringBuilder fio = new StringBuilder();
                Object last = customerJson.optQuery(Customer.CustomerFiz.LAST_NAME.key());
                fio.append((String)(last == null ? "" : last + " "));
                Object first = customerJson.optQuery(Customer.CustomerFiz.FIRST_NAME.key());
                fio.append((String)(first == null ? "" : first + " "));
                Object middle = customerJson.optQuery(Customer.CustomerFiz.MIDDLE_NAME.key());
                fio.append(middle == null ? "" : String.valueOf(middle));
                StringBuilder passport = new StringBuilder();
                Object passportRF = customerJson.optQuery(Customer.CustomerFizDocument.PASSPORT_RF.key());
                if (passportRF != null) {
                    JSONObject passportObject = (JSONObject)passportRF;
                    passport.append(passportObject.optString("series")).append(" ").append(passportObject.optString("number"));
                }
                Object birthday = customerJson.optQuery(Customer.CustomerFiz.BIRTHDAY.key());
                JSONObject json = new JSONObject();
                json.put("id", customerId);
                json.put("title", (Object)fio.toString().trim());
                json.put("birthday", (Object)(birthday == null ? "" : TimeUtils.format((LocalDate)LocalDate.parse((String)birthday), (String)"dd.MM.yyyy")));
                json.put("passport", (Object)passport.toString().trim());
                data.add(new RowData(json));
                customerIds.add(customerId);
            }
        } else {
            try {
                JSONArray customers = new JSONArray(((ContractParameterService)this.clientContext.getPort(ContractParameterService.class)).customerSearch(this.customerType, text));
                for (int index = 0; index < customers.length(); ++index) {
                    data.add(new RowData(customers.getJSONObject(index)));
                }
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }
        this.customerSearchTableModel.setData(data);
    }

    public JDialog getDialog() {
        return this.optionPane.getDialog();
    }

    public int getSelectCustomerId() {
        return this.selectCustomerId;
    }

    class CustomerSearchTableModel
    extends BGTableModel<RowData> {
        public CustomerSearchTableModel(Customer.CustomerType customerType) {
            super(CustomerSearchTableModel.class.getName());
            this.addColumnId();
            if (customerType.equals((Object)Customer.CustomerType.JUR_CUSTOMER)) {
                this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", 100, 200, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
                this.addColumn("\u0418\u041d\u041d", 100, 100, 100, "inn", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
                this.addColumn("\u041e\u0413\u0420\u041d", 150, 150, 150, "ogrn", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            } else {
                this.addColumn("\u0424\u0418\u041e", 100, 200, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
                this.addColumn("\u0414\u0435\u043d\u044c \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f", 150, 150, 150, "birthday", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
                this.addColumn("\u041f\u0430\u0441\u043f\u043e\u0440\u0442", 100, 100, 100, "passport", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            }
        }

        protected void initColumns() {
        }

        public Object getValue(RowData rowData, int column) throws BGException {
            String identifier;
            switch (identifier = this.getIdentifier(column)) {
                case "id": {
                    return rowData.getJson().optInt(identifier);
                }
            }
            return rowData.getJson().optString(identifier);
        }
    }
}

