/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.nas;

import bitel.billing.server.admin.errorlog.AlarmSender;
import bitel.billing.server.admin.errorlog.bean.AlarmErrorMessage;
import bitel.billing.server.processor.dialup.DialUpSessionRealtime;
import bitel.billing.server.radius.RadiusSetup;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.inspectors.PodNasConnectionInspector;
import ru.bitel.bgbilling.kernel.network.radius.inspectors.SNMPNasConnectionInspectorCisco;
import ru.bitel.bgbilling.kernel.network.radius.inspectors.SNMPNasConnectionInspectorCisco36x;
import ru.bitel.bgbilling.kernel.network.radius.inspectors.SNMPNasConnectionInspectorHuaweiExpert;
import ru.bitel.bgbilling.kernel.network.radius.inspectors.SNMPNasConnectionInspectorMPD;
import ru.bitel.bgbilling.kernel.network.radius.inspectors.SNMPNasConnectionInspectorMsRRAS;
import ru.bitel.bgbilling.kernel.network.radius.inspectors.SNMPNasConnectionInspectorPPPD;
import ru.bitel.bgbilling.kernel.network.radius.inspectors.SNMPNasConnectionInspectorUSRoboticsNetServer;
import ru.bitel.bgbilling.kernel.network.radius.inspectors.ScriptNasConnectionInspector;
import ru.bitel.bgbilling.kernel.network.radius.inspectors.WiFiConnectionInspector;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnectionListener;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.ParameterMap;

public abstract class NasConnectionInspector {
    private static final Logger logger = LogManager.getLogger();
    private static final int REQUESTS_IN_BLOCK = 10;
    protected static final int SLEEP = 500;
    protected final DefaultServerSetup setup;
    protected final InetAddress nasIPAddress;
    private final int killRetries;
    private final int killTimout;
    private int modifyRetries;
    private int modifyTimout;
    private volatile boolean run = true;
    private final Map<String, ? extends NasConnection<?>> connections;
    protected final BlockingQueue<NasConnection<?>> killQueue;
    protected final BlockingQueue<NasConnection<?>> modifyQueue;
    private final ConcurrentMap<NasConnection<?>, long[]> killMap = new ConcurrentHashMap();
    private final ConcurrentMap<NasConnection<?>, long[]> modifyMap = new ConcurrentHashMap();
    protected final Random random = new Random();
    protected Nas<?, ?, ?> nas;
    private final boolean check;
    private Iterator<? extends NasConnection<?>> checkIterator;
    private NasConnection<?> lastCheck;
    private int checkSize;
    private int checkSleepTime;
    private final CopyOnWriteArraySet<NasConnectionListener> listeners = new CopyOnWriteArraySet();

    protected NasConnectionInspector(DefaultServerSetup setup, InetAddress nasIPAddress, byte[] secret, Map<String, ? extends NasConnection<?>> connections, ParameterMap params, NasConnectionInspector old) {
        this.setup = setup;
        this.nasIPAddress = nasIPAddress;
        this.connections = connections;
        this.check = params.getInt("dialup.workmode", 1) == 2;
        this.checkSleepTime = params.getInt("nas.inspector.sleep_time", 60);
        this.killRetries = params.getInt("nas.inspector.kill.max_messages", params.getInt("nas.inspector.snmp.kill.max_messages", 5));
        this.killTimout = params.getInt("nas.inspector.kill.max_wait", 10) * 1000;
        this.modifyRetries = params.getInt("nas.inspector.coa.retries", 3);
        this.modifyTimout = params.getInt("nas.inspector.coa.timeout", 5) * 1000;
        if (old != null) {
            this.killQueue = old.killQueue;
            this.modifyQueue = old.modifyQueue;
        } else {
            this.killQueue = new LinkedBlockingQueue();
            this.modifyQueue = new LinkedBlockingQueue();
        }
        this.addListener(new NasConnectionListener(){

            @Override
            public void notKilled(NasConnection<?> con) {
                String key = "radius.dialup.error.session.drop";
                long time = System.currentTimeMillis();
                if (AlarmSender.needAlarmSend(key, time, 10000L)) {
                    String message = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0437\u043e\u0440\u0432\u0430\u0442\u044c \u0441\u0435\u0441\u0441\u0438\u044e: " + con.session.toString() + " \u043f\u043e\u0441\u043b\u0435 " + NasConnectionInspector.this.killRetries + " \u043f\u043e\u043f\u044b\u0442\u043e\u043a \u0441\u0431\u0440\u043e\u0441\u0430. \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u043f\u044b\u0442\u043e\u043a \u0441\u0431\u0440\u043e\u0441\u0430 \u043d\u0430\u0441\u0442\u0440\u0430\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 'nas.inspector.kill.max_messages' \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 NAS\u0430, \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043c\u0435\u0436\u0434\u0443 \u043f\u043e\u043f\u044b\u0442\u043a\u0430\u043c\u0438 \u0432 \u0441\u0435\u043a\u0443\u043d\u0434\u0430\u0445 - 'nas.inspector.sleep_time'.";
                    AlarmSender.sendAlarm(new AlarmErrorMessage(key, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0437\u043e\u0440\u0432\u0430\u0442\u044c \u0441\u0435\u0441\u0441\u0438\u044e DialUp \u043c\u043e\u0434\u0443\u043b\u044f", message), time);
                }
            }

            @Override
            public void notModified(NasConnection<?> con) {
                String key = "radius.dialup.coa.not.answer";
                long time = System.currentTimeMillis();
                if (AlarmSender.needAlarmSend("radius.dialup.coa.not.answer", time, 10000L)) {
                    DialUpSessionRealtime session = (DialUpSessionRealtime)con.getSession();
                    String message = "\u041d\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 " + NasConnectionInspector.this.modifyRetries + " CoA \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432.\n\n \u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u043d\u0435 \u0431\u044b\u043b\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u044b. \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u0432\u0442\u043e\u0440\u044b\u0445 \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432 \u0437\u0430\u0434\u0430\u0435\u0442\u0441\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 'nas.inspector.coa.retries' \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 NAS\u0430, \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u0432 \u0441\u0435\u043a\u0443\u043d\u0434\u0430\u0445 \u043c\u0435\u0436\u0434\u0443 \u043f\u043e\u043f\u044b\u0442\u043a\u0430\u043c\u0438 - 'nas.inspector.coa.timeout'.\nUser-Name: " + session.getLoginName() + "; Acct-Session-Id: " + session.getAcctSessionId() + "; Nas-Port: " + session.getNasPort();
                    AlarmSender.sendAlarm(new AlarmErrorMessage("radius.dialup.coa.not.answer", "\u041d\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u044b \u043e\u0442\u0432\u0435\u0442\u044b \u043d\u0430 CoA \u0437\u0430\u043f\u0440\u043e\u0441\u044b", message), time);
                }
            }
        });
    }

    public static NasConnectionInspector newInstance(String className, DefaultServerSetup setup, InetAddress nasIPAddress, byte[] secret, Map<Object, ?> connections, ParameterMap params, NasConnectionInspector old) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<NasConnectionInspector> clazz = Class.forName(NasConnectionInspector.wrapInspectorClassName(className)).asSubclass(NasConnectionInspector.class);
        Constructor<NasConnectionInspector> constr = clazz.getConstructor(RadiusSetup.class, InetAddress.class, byte[].class, Map.class, ParameterMap.class, NasConnectionInspector.class);
        return constr.newInstance(new Object[]{setup, nasIPAddress, secret, connections, params, old});
    }

    private static String wrapInspectorClassName(String clazz) {
        if ("bitel.billing.server.processor.PoDNASConnectionInspector".equals(clazz)) {
            return PodNasConnectionInspector.class.getName();
        }
        if ("bitel.billing.server.processor.ScriptNASConnectionInspector".equals(clazz)) {
            return ScriptNasConnectionInspector.class.getName();
        }
        if ("bitel.billing.server.processor.SNMPNASConnectionInspectorMPD".equals(clazz) || "bitel.billing.server.processor.SNMPNASConnectionInspectorType5".equals(clazz)) {
            return SNMPNasConnectionInspectorMPD.class.getName();
        }
        if ("bitel.billing.server.processor.SNMPNASConnectionInspectorPPPD".equals(clazz) || "bitel.billing.server.processor.SNMPNASConnectionInspectorType2".equals(clazz)) {
            return SNMPNasConnectionInspectorPPPD.class.getName();
        }
        if ("bitel.billing.server.processor.SNMPNASConnectionInspectorCisco".equals(clazz) || "bitel.billing.server.processor.SNMPNASConnectionInspectorType3".equals(clazz)) {
            return SNMPNasConnectionInspectorCisco.class.getName();
        }
        if ("bitel.billing.server.processor.SNMPNASConnectionInspectorCisco36x".equals(clazz) || "bitel.billing.server.processor.SNMPNASConnectionInspectorType1".equals(clazz)) {
            return SNMPNasConnectionInspectorCisco36x.class.getName();
        }
        if ("bitel.billing.server.processor.SNMPNASConnectionInspectorHuaweiExpert".equals(clazz) || "bitel.billing.server.processor.SNMPNASConnectionInspectorType4".equals(clazz)) {
            return SNMPNasConnectionInspectorHuaweiExpert.class.getName();
        }
        if ("bitel.billing.server.processor.SNMPNASConnectionInspectorMsRRAS".equals(clazz) || "bitel.billing.server.processor.SNMPNASConnectionInspectorType7".equals(clazz)) {
            return SNMPNasConnectionInspectorMsRRAS.class.getName();
        }
        if ("bitel.billing.server.processor.SNMPNASConnectionInspectorUSRoboticsNetServer".equals(clazz) || "bitel.billing.server.processor.SNMPNASConnectionInspectorType6".equals(clazz)) {
            return SNMPNasConnectionInspectorUSRoboticsNetServer.class.getName();
        }
        if ("bitel.billing.server.processor.WiFiConnectionInspector".equals(clazz)) {
            return WiFiConnectionInspector.class.getName();
        }
        return clazz;
    }

    public void addListener(NasConnectionListener l) {
        this.listeners.add(l);
    }

    public void removeListener(NasConnectionListener l) {
        this.listeners.remove(l);
    }

    protected abstract void sendCheckRequest(NasConnection<?> var1);

    protected abstract long sendKillRequest(NasConnection<?> var1);

    protected long sendModifyRequest(NasConnection<?> con) {
        return this.sendKillRequest(con);
    }

    protected void runImpl() {
        int packetCount;
        while (this.run) {
            try {
                Object con2;
                long milliseconds = System.currentTimeMillis();
                packetCount = 10;
                ArrayList toKill = new ArrayList();
                packetCount -= this.killQueue.drainTo(toKill, packetCount);
                for (Object con2 : toKill) {
                    long id = this.sendKillRequest((NasConnection<?>)con2);
                    if (id == -1L) continue;
                    this.killMap.put((NasConnection<?>)con2, new long[]{milliseconds, 0L, id});
                }
                ArrayList toModify = new ArrayList();
                packetCount -= this.modifyQueue.drainTo(toModify, packetCount);
                con2 = toModify.iterator();
                while (con2.hasNext()) {
                    NasConnection con3 = (NasConnection)con2.next();
                    long id = this.sendModifyRequest(con3);
                    if (id == -1L) continue;
                    this.modifyMap.put(con3, new long[]{milliseconds, 0L, id});
                }
                packetCount = this.checkKill(milliseconds, packetCount);
                packetCount = this.checkModified(milliseconds, packetCount);
                if (this.check && packetCount > 0) {
                    if (this.checkIterator == null) {
                        this.checkSize = this.connections.size();
                        this.checkIterator = this.connections.values().iterator();
                    }
                    if (this.lastCheck == null) {
                        this.lastCheck = this.checkIterator.hasNext() ? this.checkIterator.next() : null;
                    }
                    int multiplier = Math.max(1, (int)Math.round(Math.log10(this.checkSize / 100)));
                    while (this.lastCheck != null) {
                        if (this.lastCheck.lastUpdate + (long)(multiplier * this.checkSleepTime * 1000) <= milliseconds) {
                            this.lastCheck.lastUpdate = milliseconds;
                            this.sendCheckRequest(this.lastCheck);
                            if (--packetCount <= 0) break;
                        }
                        this.lastCheck = this.checkIterator.hasNext() ? this.checkIterator.next() : null;
                    }
                    if (this.lastCheck == null) {
                        this.checkIterator = null;
                    }
                }
                this.onIdle();
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
        }
        do {
            try {
                long milliseconds = System.currentTimeMillis();
                packetCount = 10;
                packetCount = this.checkKill(milliseconds, packetCount);
                this.onIdle();
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
        } while (this.killMap.size() > 0);
        this.preDestroy();
    }

    protected void onIdle() throws InterruptedException {
        Thread.sleep(500L);
    }

    private int checkKill(long milliseconds, int packetCount) {
        Iterator iter = this.killMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            NasConnection con = (NasConnection)e.getKey();
            long[] value = (long[])e.getValue();
            if (con.getStatus() == NasConnection.Status.stopped) {
                iter.remove();
                continue;
            }
            if (milliseconds - value[0] <= (long)this.killTimout) continue;
            if (value[1] >= (long)(this.killRetries - 1)) {
                this.notKilled(con);
                iter.remove();
                continue;
            }
            value[0] = milliseconds;
            value[1] = value[1] + 1L;
            this.sendKillRequest(con);
            if (--packetCount > 0) continue;
            break;
        }
        return packetCount;
    }

    private int checkModified(long milliseconds, int packetCount) {
        Iterator iter = this.modifyMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            NasConnection con = (NasConnection)e.getKey();
            long[] value = (long[])e.getValue();
            if (con.getStatus() == NasConnection.Status.stopped) {
                iter.remove();
                continue;
            }
            if (milliseconds - value[0] <= (long)this.modifyTimout) continue;
            if (value[1] >= (long)(this.modifyRetries - 1)) {
                for (NasConnectionListener l : this.listeners) {
                    l.notModified(con);
                }
                iter.remove();
                continue;
            }
            value[0] = milliseconds;
            value[1] = value[1] + 1L;
            this.sendModifyRequest(con);
            if (--packetCount > 0) continue;
            break;
        }
        return packetCount;
    }

    protected final void fireModified(NasConnection<?> con, long id) {
        long[] value = (long[])this.modifyMap.get(con);
        if (value != null && value[2] == id) {
            this.modifyMap.remove(con, value);
        }
    }

    protected final void fireNotKilled(String nasPort) {
        NasConnection<?> con = this.connections.get(nasPort);
        if (con != null && this.notKilled(con)) {
            this.killMap.remove(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean notKilled(NasConnection<?> con) {
        NasConnectionInspector nasConnectionInspector = this;
        synchronized (nasConnectionInspector) {
            if (con.isKill()) {
                con.notKill();
                for (NasConnectionListener l : this.listeners) {
                    l.notKilled(con);
                }
                return true;
            }
        }
        return false;
    }

    public void kill(NasConnection<?> con) {
        this.killQueue.add(con);
    }

    public void modify(NasConnection<?> con) {
        this.modifyQueue.add(con);
    }

    protected void init(Nas<?, ?, ?> nas) {
        this.nas = nas;
        new Thread("nas-con-insp-" + this.getClass().getSimpleName() + "-" + nas.getNasIdentifier()){

            @Override
            public void run() {
                NasConnectionInspector.this.runImpl();
            }
        }.start();
    }

    public InetAddress getHost() {
        return this.nasIPAddress;
    }

    public final void destroy() {
        this.run = false;
    }

    protected void preDestroy() {
        this.listeners.clear();
    }
}

