/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.directory.tariff.common.TariffDirectory;
import ru.bitel.bgbilling.kernel.tariff.client.TariffNodeMenuItem;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.util.StringCache;

public class ModuleTariffConfig {
    private String rootType;
    private Map<String, Element> typesElements = new LinkedHashMap<String, Element>();
    private Map<String, String> typesClasses = new HashMap<String, String>();
    private Map<String, Dir> directories = new HashMap<String, Dir>();
    private static final StringCache STRING_CACHE = new StringCache(8);
    private Document doc;

    public ModuleTariffConfig(Document doc) {
        this.doc = doc;
        this.loadNodeTypes();
        this.loadRootNode();
        this.initDirs();
    }

    private void loadNodeTypes() {
        for (Element el : XMLUtils.selectElements((Node)this.doc.getDocumentElement(), (String)"/data/tree/node")) {
            String type = el.getAttribute("type");
            String className = el.getAttribute("class1");
            if (type == null) continue;
            this.typesElements.put(type, el);
            if (className == null) continue;
            this.typesClasses.put(type, className);
        }
    }

    private void loadRootNode() {
        this.rootType = XMLUtils.selectText((Node)this.doc.getDocumentElement(), (String)"/data/tree/@root");
    }

    private void initDirs() {
        for (Element dir : XMLUtils.selectElements((Node)this.doc.getDocumentElement(), (String)"/data/directory")) {
            String className = dir.getAttribute("class");
            String dirName = dir.getAttribute("name");
            String type = dir.getAttribute("type");
            if (className == null || dirName == null) continue;
            this.directories.put(dirName, new Dir(className, type));
        }
    }

    public TariffTreeNode createNodeByType(String type) {
        TariffTreeNode result = null;
        String className = this.typesClasses.get(type);
        try {
            result = (TariffTreeNode)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            System.err.println("Can't create node TYPE => " + type + "; ClassName => " + className);
        }
        return result;
    }

    public TariffTreeNode getRootNode(int mtree, Map<Integer, List<Element>> nodes, TariffTree tree) {
        TariffTreeNode result = null;
        int rootId = -1;
        List<Element> rootEl = nodes.remove(0);
        rootId = rootEl == null ? tree.createNode(mtree, this.rootType, 0) : Integer.parseInt(rootEl.get(0).getAttribute("id"));
        result = this.createNodeByType(this.rootType);
        result.init(rootId, mtree, this.rootType, tree, this, null, nodes);
        result.setEditable(false);
        if (rootEl != null) {
            String data = rootEl.get(0).getAttribute("data");
            result.setData(data);
        }
        return result;
    }

    public Map<String, String> getType_TitleChilds(String type) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Element typeRef = this.typesElements.get(type);
        if (typeRef != null) {
            NodeList childs = typeRef.getChildNodes();
            int size = childs.getLength();
            for (int i = 0; i < size; ++i) {
                Node node = childs.item(i);
                if (!node.getNodeName().equals("node")) continue;
                Element el = (Element)node;
                String tp = el.getAttribute("type");
                String title = this.getTypeTitle(tp);
                result.put(tp, title);
            }
            String category = typeRef.getAttribute("category");
            if (result.size() == 0 && "directory".equals(category)) {
                for (Element el : this.typesElements.values()) {
                    String typeName;
                    String typeTitle;
                    category = el.getAttribute("category");
                    if (category.equals("deprecated") || !Utils.notBlankString((String)(typeTitle = this.getTypeTitle(typeName = el.getAttribute("type"))))) continue;
                    result.put(typeName, typeTitle);
                }
            }
        }
        return result;
    }

    public String getTypeTitle(String type) {
        String result = "\u0411\u0435\u0437\u044b\u043c\u044f\u043d\u043d\u044b\u0439 \u0442\u0438\u043f";
        Element typeRef = this.typesElements.get(type);
        if (typeRef != null) {
            result = typeRef.getAttribute("title");
        }
        return result;
    }

    public Element getTypeElement(String type) {
        Element result = this.typesElements.get(type);
        return result;
    }

    public Vector<Directory> getDirectories() {
        Vector<Directory> result = new Vector<Directory>();
        for (String dirName : this.directories.keySet()) {
            Dir dir = this.directories.get(dirName);
            try {
                Directory directory;
                Class<?> clazz = Class.forName(dir.className);
                if (IdTitle.class.isAssignableFrom(clazz)) {
                    directory = new TariffDirectory(clazz, dir.type);
                    if (directory == null) continue;
                    directory.setName(dirName);
                    result.add(directory);
                    continue;
                }
                directory = (Directory)Class.forName(dir.className).getConstructor(new Class[0]).newInstance(new Object[0]);
                if (directory == null) continue;
                directory.setName(dirName);
                result.add(directory);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean childsSortNeed(String type) {
        boolean result = false;
        Element el = this.typesElements.get(type);
        result = el != null && el.getAttribute("sort_childs").equals("true");
        return result;
    }

    public TariffNodeMenuItem[] getMenuItems(String type) {
        TariffNodeMenuItem[] result = null;
        Element el = this.typesElements.get(type);
        if (el == null) {
            System.err.println("ModuleTariffConfig::getMenuItems Can't find reference of " + type);
        } else {
            NodeList nl = el.getElementsByTagName("menu");
            int length = nl.getLength();
            if (length > 0) {
                result = new TariffNodeMenuItem[length];
                for (int i = 0; i < length; ++i) {
                    Element menuRef = (Element)nl.item(i);
                    String className = menuRef.getAttribute("class");
                    String title = menuRef.getAttribute("title");
                    try {
                        TariffNodeMenuItem item = (TariffNodeMenuItem)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                        item.setTitle(title);
                        result[i] = item;
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    class Dir {
        final String className;
        final String type;

        Dir(String className, String type) {
            this.className = className;
            this.type = STRING_CACHE.intern(type);
        }
    }
}

