/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.option.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOptionActivateMode;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class TariffOptionActivateModeDao {
    private Connection con;

    public TariffOptionActivateModeDao(Connection con) {
        this.con = con;
    }

    public TariffOptionActivateMode get(int modeId) throws BGException {
        TariffOptionActivateMode result = null;
        try {
            String query = "SELECT * FROM tariff_option_activate_mode AS mode WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, modeId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getFromRS(rs, false);
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<TariffOptionActivateMode> getOptionActivateModeList(int optionId, Date date) throws BGException {
        try {
            ArrayList<TariffOptionActivateMode> result = new ArrayList<TariffOptionActivateMode>();
            Object query = "SELECT mode.*, type.title FROM tariff_option_activate_mode AS mode LEFT JOIN contract_charge_types AS type ON mode.charge_type_id=type.id WHERE mode.option_id=? ";
            if (date != null) {
                query = (String)query + "AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR ?<=date2)";
            }
            query = (String)query + "ORDER BY id";
            PreparedStatement ps = this.con.prepareStatement((String)query);
            ps.setInt(1, optionId);
            if (date != null) {
                java.sql.Date sqlDate = TimeUtils.convertDateToSqlDate((Date)date);
                ps.setDate(2, sqlDate);
                ps.setDate(3, sqlDate);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs, true));
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void updateTariffOptionActivateModeList(int optionId, List<TariffOptionActivateMode> modeList) throws BGException {
        try {
            PreparedStatement insertPS = this.con.prepareStatement("INSERT INTO tariff_option_activate_mode (option_id, title, charge_type_id, charge_summa, period_mode, period_col, deactivation_mode, reactivation_mode, delete_mode, delete_charge_mode, date1, date2) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 1);
            PreparedStatement updatePS = this.con.prepareStatement("UPDATE tariff_option_activate_mode SET title=?, charge_type_id=?, charge_summa=?, period_mode=?, period_col=?, deactivation_mode=?, reactivation_mode=?, delete_mode=?, delete_charge_mode=?, date1=?, date2=? WHERE id=?");
            HashSet<Integer> ids = new HashSet<Integer>();
            for (TariffOptionActivateMode mode : modeList) {
                this.update(optionId, mode, insertPS, updatePS);
                ids.add(mode.getId());
            }
            ids.add(-1);
            PreparedStatement deletePS = this.con.prepareStatement("DELETE FROM tariff_option_activate_mode WHERE option_id=? AND id NOT IN (" + Utils.toString(ids) + ")");
            deletePS.setInt(1, optionId);
            deletePS.executeUpdate();
            insertPS.close();
            updatePS.close();
            deletePS.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private void update(int optionId, TariffOptionActivateMode mode, PreparedStatement insertPS, PreparedStatement updatePS) throws SQLException {
        if (mode.getId() > 0) {
            updatePS.setString(1, mode.getTitle());
            updatePS.setInt(2, mode.getChargeTypeId());
            updatePS.setBigDecimal(3, mode.getChargeSumma());
            updatePS.setInt(4, mode.getPeriodMode());
            updatePS.setInt(5, mode.getPeriodCol());
            updatePS.setInt(6, mode.getDeactivationMode());
            updatePS.setInt(7, mode.getReactivationMode());
            updatePS.setInt(8, mode.getDeleteMode());
            updatePS.setInt(9, mode.getDeleteChargeMode());
            updatePS.setDate(10, TimeUtils.convertDateToSqlDate((Date)mode.getDateFrom()));
            updatePS.setDate(11, TimeUtils.convertDateToSqlDate((Date)mode.getDateTo()));
            updatePS.setInt(12, mode.getId());
            if (updatePS.executeUpdate() == 0) {
                mode.setId(-1);
            }
        }
        if (mode.getId() <= 0) {
            insertPS.setInt(1, optionId);
            insertPS.setString(2, mode.getTitle());
            insertPS.setInt(3, mode.getChargeTypeId());
            insertPS.setBigDecimal(4, mode.getChargeSumma());
            insertPS.setInt(5, mode.getPeriodMode());
            insertPS.setInt(6, mode.getPeriodCol());
            insertPS.setInt(7, mode.getDeactivationMode());
            insertPS.setInt(8, mode.getReactivationMode());
            insertPS.setInt(9, mode.getDeleteMode());
            insertPS.setInt(10, mode.getDeleteChargeMode());
            insertPS.setDate(11, TimeUtils.convertDateToSqlDate((Date)mode.getDateFrom()));
            insertPS.setDate(12, TimeUtils.convertDateToSqlDate((Date)mode.getDateTo()));
            insertPS.executeUpdate();
            mode.setId(ServerUtils.lastInsertId(insertPS));
        }
    }

    protected TariffOptionActivateMode getFromRS(ResultSet rs, boolean typeTitleLoad) throws SQLException {
        TariffOptionActivateMode result = new TariffOptionActivateMode();
        result.setId(rs.getInt("mode.id"));
        result.setOptionId(rs.getInt("mode.option_id"));
        result.setTitle(rs.getString("mode.title"));
        result.setChargeTypeId(rs.getInt("mode.charge_type_id"));
        result.setChargeSumma(rs.getBigDecimal("mode.charge_summa"));
        result.setPeriodMode(rs.getInt("mode.period_mode"));
        result.setDeactivationMode(rs.getInt("mode.deactivation_mode"));
        result.setReactivationMode(rs.getInt("mode.reactivation_mode"));
        result.setPeriodCol(rs.getInt("mode.period_col"));
        result.setDateFrom(rs.getDate("date1"));
        result.setDateTo(rs.getDate("date2"));
        result.setDeleteMode(rs.getInt("mode.delete_mode"));
        result.setDeleteChargeMode(rs.getInt("mode.delete_charge_mode"));
        if (typeTitleLoad) {
            result.setChargeTypeTitle(rs.getString("type.title"));
        }
        return result;
    }
}

