/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree;

import java.math.BigDecimal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ServiceCost;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.common.ParameterMap;

public class MultCostTariffTreeNode
extends DefaultTariffTreeNode<AbstractTariffRequest<?>, TariffContext> {
    private static final Logger logger = LogManager.getLogger();
    private final BigDecimal multiplicand;

    public MultCostTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.multiplicand = parameterMap.getBigDecimal("value", BigDecimal.ONE);
        if (logger.isDebugEnabled()) {
            logger.debug("multiplicand = " + this.multiplicand);
        }
    }

    @Override
    public int executeImpl(Long treeNodeId, AbstractTariffRequest<?> tariffRequest, TariffContext tariffContext) {
        if (((ServiceCost)tariffRequest.serviceCost).cost != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("tariffRequest.serviceCost.cost(before) = " + ((ServiceCost)tariffRequest.serviceCost).cost);
            }
            ((ServiceCost)tariffRequest.serviceCost).cost = ((ServiceCost)tariffRequest.serviceCost).cost.multiply(this.multiplicand, tariffContext.mc);
            if (logger.isDebugEnabled()) {
                logger.debug("tariffRequest.serviceCost.cost(after) = " + ((ServiceCost)tariffRequest.serviceCost).cost);
            }
            return 1;
        }
        return 0;
    }
}

