/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.util.dbfviewer.client;

import au.com.bytecode.opencsv.CSVWriter;
import bitel.billing.module.common.BGSelectFilePanel;
import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFReader;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class DBFViewer
extends BGTabPanel {
    public static final String TAB_ID = "dbfViewer";
    private JTable table = new JTable(0, 0);
    private BGSelectFilePanel selectFile = new BGSelectFilePanel(false, false, false);
    private BGButton openButton = new BGButton("\u041e\u0442\u043a\u0440\u044b\u0442\u044c");
    private BGButton saveButton = new BGButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0432 ...");
    private BGTextField encoding = new BGTextField();

    public DBFViewer() {
        super(TAB_ID, "\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0449\u0438\u043a DBF");
        this.module = "dbfviewer";
        try {
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initialize() throws Exception {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)this.openButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)this.saveButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(new JLabel("\u0424\u0430\u0439\u043b DBF:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.selectFile, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(new JLabel("\u041a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.encoding, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(buttonPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(new JScrollPane(this.table), new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = DBFViewer.this.getSelectedFile();
                if (file == null) {
                    return;
                }
                try {
                    DBFViewer.this.readDBF(file);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f dbf-\u0444\u0430\u0439\u043b\u0430!\n" + ex.getLocalizedMessage()));
                    ex.printStackTrace();
                }
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = DBFViewer.this.getSelectedFile();
                if (file == null) {
                    return;
                }
                BGFileChooser chooser = new BGFileChooser((Component)((Object)DBFViewer.this));
                chooser.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "CSV";
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().endsWith(".csv");
                    }
                });
                if (chooser.showSaveDialog() == 0) {
                    try {
                        File selected = chooser.getSelectedFile();
                        if (!selected.getName().endsWith(".csv")) {
                            selected = new File(selected.getAbsolutePath() + ".csv");
                        }
                        CSVWriter writer = new CSVWriter((Writer)new FileWriter(selected), ';');
                        DBFReader reader = DBFViewer.this.prepareReader(file);
                        for (int i = 0; i < reader.getRecordCount(); ++i) {
                            Object[] record = reader.nextRecord();
                            String[] csvRecord = new String[record.length];
                            for (int j = 0; j < record.length; ++j) {
                                csvRecord[j] = DBFViewer.this.parseRecordValue(record[j], reader.getField(j), 2);
                            }
                            writer.writeNext(csvRecord, false);
                        }
                        writer.flush();
                        writer.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    private File getSelectedFile() {
        File file = this.selectFile.getSelectedFile();
        if (file == null || !file.exists()) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b!", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 2);
        }
        return file;
    }

    private void readDBF(File dbfFile) throws Exception {
        DBFReader reader = this.prepareReader(dbfFile);
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        model.setColumnCount(reader.getFieldCount());
        Object[] columns = new Object[reader.getFieldCount()];
        for (int i = 0; i < reader.getFieldCount(); ++i) {
            columns[i] = reader.getField(i).getName();
        }
        model.setColumnIdentifiers(columns);
        model.setRowCount(reader.getRecordCount());
        for (int j = 0; j < reader.getRecordCount(); ++j) {
            Object[] data = reader.nextRecord();
            for (int i = 0; i < reader.getFieldCount(); ++i) {
                String value = this.parseRecordValue(data[i], reader.getField(i), -1);
                model.setValueAt(value, j, i);
            }
        }
    }

    private DBFReader prepareReader(File dbfFile) throws DBFException, FileNotFoundException {
        DBFReader reader = new DBFReader((InputStream)new FileInputStream(dbfFile));
        if (Utils.notBlankString((String)this.encoding.getText())) {
            reader.setCharactersetName(this.encoding.getText());
        }
        return reader;
    }

    private String parseRecordValue(Object data, DBFField field, int decimalCount) {
        String value = "";
        if (data != null) {
            switch (field.getDataType()) {
                case 67: {
                    value = (String)data;
                    break;
                }
                case 68: {
                    value = TimeUtils.format((Date)((Date)data), (String)"dd.MM.yyyy HH:mm:ss");
                    break;
                }
                case 78: {
                    value = Utils.formatBigDecimal((BigDecimal)((BigDecimal)data), (int)(decimalCount != -1 ? decimalCount : field.getDecimalCount()));
                    break;
                }
                default: {
                    value = data.toString();
                }
            }
        }
        return value.trim();
    }
}

