/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.domain.server.service;

import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jws.WebService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.oss.kernel.directories.domain.common.bean.Domain;
import ru.bitel.oss.kernel.directories.domain.common.event.DomainModifiedEvent;
import ru.bitel.oss.kernel.directories.domain.common.service.DomainService;
import ru.bitel.oss.kernel.directories.domain.server.bean.DomainDao;

@WebService(endpointInterface="ru.bitel.oss.kernel.directories.domain.common.service.DomainService")
public class DomainServiceImpl
extends AbstractService
implements DomainService {
    private static final Logger logger = LogManager.getLogger();
    private DomainDao domainDao;
    private Directory<Domain> domainDir;

    @PostConstruct
    void init() {
        this.domainDao = new DomainDao(this.getConnection());
        try {
            this.domainDir = this.context.getDirectory(Domain.class, 0);
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @PreDestroy
    void destroy() {
        try {
            this.domainDao.close();
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public int domainUpdate(Domain domain) throws BGException {
        this.domainDir.update(domain);
        return domain.getId();
    }

    public Domain domainGet(int id) throws BGException {
        return this.domainDir.get(id);
    }

    public List<Domain> domainList() throws BGException {
        return this.domainDir.list();
    }

    public void domainDelete(int id) throws BGException {
        this.domainDir.delete(id);
    }

    public Domain domainTree() throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
        return this.domainDao.tree();
    }

    public void domainMove(int newParentId, Set<Integer> children) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
        this.domainDao.move(newParentId, children);
        this.context.publishAfterCommit((Event)new DomainModifiedEvent(0, this.userId, null, null));
    }
}

