/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import ru.bitel.common.TimeUtils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDefaultDao;

class EntityAttrDateDao
extends EntityAttrDefaultDao<EntityAttrDate> {
    public EntityAttrDateDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String dateTable) {
        super(con, entityAttrDao, dateTable);
    }

    @Override
    protected void createTable() {
        try (Statement createStatement = this.con.createStatement();){
            createStatement.execute("CREATE TABLE IF NOT EXISTS `" + this.table + "` ( `entityId` int(11) NOT NULL DEFAULT 0, `entitySpecAttrId` int(11) NOT NULL DEFAULT 0, `value` date NULL DEFAULT NULL, PRIMARY KEY (`entityId`,`entitySpecAttrId`) )");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public EntityAttrDate get(int entityId, int attrSpecId) throws SQLException {
        EntityAttrDate result = null;
        try (PreparedStatement ps = this.getSelectPS(entityId, attrSpecId);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                result = new EntityAttrDate(entityId, attrSpecId, (Date)rs.getDate(1));
            }
        }
        return result;
    }

    @Override
    public void insert(int entityId, EntityAttr a) throws SQLException {
        try (PreparedStatement ps = this.getInsertPS(entityId, a.getEntitySpecAttrId());){
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)((EntityAttrDate)a).getValue()));
            ps.executeUpdate();
        }
    }

    @Override
    protected boolean updateImpl(int entityId, EntityAttrDate attr) throws SQLException {
        boolean update = false;
        try (PreparedStatement ps = this.getUpdatePS(entityId, attr.getEntitySpecAttrId());){
            ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)attr.getValue()));
            update = ps.executeUpdate() == 0;
        }
        if (update) {
            ps = this.getInsertPS(entityId, attr.getEntitySpecAttrId());
            try {
                ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)attr.getValue()));
                ps.executeUpdate();
                boolean bl = true;
                return bl;
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        java.sql.Date oldValue = null;
        try (PreparedStatement ps = this.entityAttrDao.getSelectOldValuePS();
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                oldValue = rs.getDate(1);
            }
        }
        return !TimeUtils.dateEqual((Date)attr.getValue(), (Date)oldValue);
    }

    @Override
    protected void insertHistory(int cid, EntityAttrDate attr) throws SQLException {
        try (PreparedStatement ps = this.getInsertHistiryPS();){
            ps.setInt(1, cid);
            ps.setInt(2, attr.getEntitySpecAttrId());
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)attr.getValue()));
            ps.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
            ps.setInt(5, this.entityAttrDao.userId);
            ps.executeUpdate();
        }
    }
}

