/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import bitel.billing.server.util.Config;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.PhoneUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDefaultDao;

class EntityAttrPhoneDao
extends EntityAttrDefaultDao<EntityAttrPhone> {
    String itemTable;
    private Formats formats = Setup.getSetup().getConfig(0, Formats.class);

    public EntityAttrPhoneDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String phoneTable, String phoneItemTable) {
        super(con, entityAttrDao, phoneTable);
        this.itemTable = phoneItemTable;
    }

    @Override
    protected void createTable() {
    }

    @Override
    protected PreparedStatement getSelectPS(int entityId, int entitySpecAttrId) throws SQLException {
        PreparedStatement selectPS = this.con.prepareStatement("SELECT value FROM " + this.table + " WHERE " + this.idName() + "=? AND " + this.typeName() + "=?");
        selectPS.setInt(1, entityId);
        selectPS.setInt(2, entitySpecAttrId);
        return selectPS;
    }

    @Override
    protected PreparedStatement getInsertPS(int entityId, int entitySpecAttrId) throws SQLException {
        PreparedStatement insertPS = this.con.prepareStatement("INSERT INTO " + this.table + " (" + this.idName() + ", " + this.typeName() + ", value) VALUES (?, ?, ?)");
        insertPS.setInt(1, entityId);
        insertPS.setInt(2, entitySpecAttrId);
        return insertPS;
    }

    @Override
    protected PreparedStatement getUpdatePS(int entityId, int entitySpecAttrId) throws SQLException {
        PreparedStatement updatePS = this.con.prepareStatement("UPDATE " + this.table + " SET value=? WHERE " + this.idName() + "=? AND " + this.typeName() + "=? AND (@oldValue:=value) IS NOT NULL");
        updatePS.setInt(2, entityId);
        updatePS.setInt(3, entitySpecAttrId);
        return updatePS;
    }

    @Override
    public EntityAttrPhone get(int entityId, int attrSpecId) throws SQLException {
        EntityAttrPhone result;
        PreparedStatement ps = this.getSelectPS(entityId, attrSpecId);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = new EntityAttrPhone(entityId, attrSpecId);
            result.setData(rs.getString(1));
            result.setContactList(new ArrayList(4));
        } else {
            result = null;
        }
        rs.close();
        if (result != null) {
            ps = this.con.prepareStatement("SELECT phone, comment FROM " + this.itemTable + " WHERE " + this.idName() + "=? AND " + this.typeName() + "=? ORDER BY n");
            ps.setInt(1, entityId);
            ps.setInt(2, attrSpecId);
            rs = ps.executeQuery();
            while (rs.next()) {
                EntityAttrPhone.PhoneContact phone = new EntityAttrPhone.PhoneContact();
                String p = rs.getString("phone");
                p = PhoneUtils.phoneToFormat(this.formats.prefixes, (String)p);
                phone.setPhone(p);
                phone.setComment(rs.getString("comment"));
                result.getContactList().add(phone);
            }
            rs.close();
            ps.close();
        }
        return result;
    }

    @Override
    public void insert(int entityId, EntityAttr a) throws SQLException, BGException {
        EntityAttrPhone phone = (EntityAttrPhone)a;
        EntityAttrPhoneDao.check(phone, true);
        try (PreparedStatement ps = this.getInsertPS(entityId, a.getEntitySpecAttrId());){
            ps.setString(3, phone.getData());
            ps.executeUpdate();
        }
        this.updatePhones(entityId, phone);
    }

    @Override
    public boolean updateImpl(int entityId, EntityAttrPhone attr) throws SQLException, BGException {
        boolean result;
        EntityAttrPhoneDao.check(attr, true);
        if (attr.getContactList() == null || attr.getContactList().size() == 0) {
            return this.deleteImpl(entityId, attr.getEntitySpecAttrId());
        }
        PreparedStatement ps = this.getUpdatePS(entityId, attr.getEntitySpecAttrId());
        ps.setString(1, attr.getData());
        if (ps.executeUpdate() == 0) {
            ps.close();
            ps = this.getInsertPS(entityId, attr.getEntitySpecAttrId());
            ps.setString(3, attr.getData());
            ps.executeUpdate();
            ps.close();
            result = true;
        } else {
            ps = this.entityAttrDao.getSelectOldValuePS();
            ResultSet rs = ps.executeQuery();
            String oldValue = rs.next() ? rs.getString(1) : null;
            rs.close();
            ps.close();
            result = !attr.getData().equals(oldValue);
        }
        this.updatePhones(entityId, attr);
        return result;
    }

    private void updatePhones(int entityId, EntityAttrPhone attr) throws SQLException {
        this.deletePhones(entityId, attr.getEntitySpecAttrId());
        PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + this.itemTable + " SET " + this.idName() + "=?, " + this.typeName() + "=?, n=?, phone=?, comment=?");
        ps.setInt(1, entityId);
        ps.setInt(2, attr.getEntitySpecAttrId());
        int order = 0;
        for (EntityAttrPhone.PhoneContact phone : attr.getContactList()) {
            ps.setInt(3, ++order);
            ps.setString(4, phone.getPhone());
            ps.setString(5, phone.getComment());
            ps.executeUpdate();
        }
        ps.close();
    }

    @Override
    protected boolean deleteImpl(int entityId, int entitySpecAttrId) throws SQLException {
        boolean result = super.deleteImpl(entityId, entitySpecAttrId);
        if (result) {
            this.deletePhones(entityId, entitySpecAttrId);
        }
        return result;
    }

    private void deletePhones(int entityId, int entitySpecAttrId) throws SQLException {
        PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.itemTable + " WHERE " + this.idName() + "=? AND " + this.typeName() + "=?");
        ps.setInt(1, entityId);
        ps.setInt(2, entitySpecAttrId);
        ps.executeUpdate();
        ps.close();
    }

    public static void check(EntityAttrPhone a, boolean skipError) throws BGMessageException {
        if (a.getContactList() != null) {
            int phoneNumberLength = Setup.getSetup().getInt("phones.customLengthNumber", 11);
            Iterator iter = a.getContactList().iterator();
            while (iter.hasNext()) {
                EntityAttrPhone.PhoneContact phone = (EntityAttrPhone.PhoneContact)iter.next();
                if (phone == null || Utils.isEmptyString((String)phone.getPhone())) {
                    iter.remove();
                    continue;
                }
                phone.setPhone(EntityAttrPhone.phoneUnformatted((String)phone.getPhone()));
                if (Utils.isBlankString((String)phone.getPhone())) {
                    iter.remove();
                    continue;
                }
                int length = phone.getPhone().length();
                if (length == 11 || length == phoneNumberLength) continue;
                if (skipError) {
                    iter.remove();
                    continue;
                }
                throw new BGMessageException("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0446\u0438\u0444\u0440 \u0432 \u043d\u043e\u043c\u0435\u0440\u0435 '" + phone.getPhone() + "\" \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c 11" + (String)(phoneNumberLength > 0 && phoneNumberLength != 11 ? " \u0438\u043b\u0438 " + phoneNumberLength + "." : "."), "phone.incorrect");
            }
        }
        if (skipError) {
            a.setData(PhoneUtils.getPhones((EntityAttrPhone)a, (String)Setup.getSetup().get("phones.formats")));
        }
    }

    private static class Formats
    extends Config {
        final Map<Integer, List<String>> prefixes;

        public Formats(int mid, ParameterMap moduleSetup, Setup serverSetup) {
            super(mid, moduleSetup, serverSetup);
            this.prefixes = PhoneUtils.prefixMap((String)serverSetup.get("phones.formats"));
        }
    }
}

