/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin;

import bitel.billing.module.admin.DBInfo;
import bitel.billing.module.common.BGDialog;
import bitel.billing.module.common.DBInfoManager;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGUComboBox;

public class UserAuth
extends BGDialog {
    private static final String MODE_CONNECT = "connect";
    private static final String MODE_EDITOR = "editor";
    private String mode = "connect";
    private JPanel panelCard = new JPanel();
    private BGButton quitButton = new BGButton();
    private BGButton editButton = new BGButton();
    private BGButton deleteButton = new BGButton();
    private JCheckBox saveCheckBox = new JCheckBox("\u0437\u0430\u043f\u043e\u043c\u043d\u0438\u0442\u044c \u043b\u043e\u0433\u0438\u043d \u0438 \u043f\u0430\u0440\u043e\u043b\u044c \u0434\u043b\u044f \u044d\u0442\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
    private BGTextField userLogin = new BGTextField();
    private BGTextField dbNameField = new BGTextField();
    private BGTextField dbURLField = new BGTextField();
    private BGTextField proxyHostField = new BGTextField();
    private BGTextField proxyPortField = new BGTextField();
    private JPasswordField userPswd = new JPasswordField();
    private BGUComboBox<DBInfo> bdComboBox = new BGUComboBox();
    private BGButtonPanelOkCancel okCancelPanel = new BGButtonPanelOkCancel();
    private DBInfoManager dbInfoManager = DBInfoManager.getManager();
    private static final JSeparator separatorUI = new JSeparator(0);
    private DBInfo dbInfo = null;

    public DBInfo getDbInfo() {
        return this.dbInfo;
    }

    public void setDbInfo(DBInfo dbInfo) {
        this.dbInfo = dbInfo;
    }

    @Override
    public void setData() {
        if (this.dbInfo != null) {
            this.userLogin.setText(this.dbInfo.getDbServerLogin());
            this.userPswd.setText(this.dbInfo.getDbServerPassword());
        }
    }

    public UserAuth() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loadServers();
        this.pack();
        this.moveWindowToCenterScreen();
    }

    private void loadServers() {
        DBInfo newDBInfo = new DBInfo();
        newDBInfo.setLocalItem(true);
        newDBInfo.setDbServerTitle("\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u043e\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435...");
        newDBInfo.setDbServerKey("NEW");
        List<DBInfo> resultList = this.dbInfoManager.getInfoLists(true);
        resultList.add(0, newDBInfo);
        List<DBInfo> uswallyList = this.dbInfoManager.getInfoLists(false);
        if (resultList.size() > 1 && uswallyList.size() > 0) {
            DBInfo separator = new DBInfo();
            separator.setLocalItem(true);
            separator.setDbServerTitle("-----");
            resultList.add(separator);
        }
        resultList.addAll(uswallyList);
        this.bdComboBox.removeAllItems();
        this.bdComboBox.setData(resultList);
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setResizable(true);
        this.setTitle("\u0410\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044f");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                UserAuth.this.this_windowOpened(windowEvent);
            }
        });
        this.okCancelPanel.addActionListener(e -> this.okCancelPanelActionPerformed(e));
        this.editButton.addActionListener(e -> {
            this.mode = MODE_EDITOR;
            ((CardLayout)this.panelCard.getLayout()).show(this.panelCard, this.mode);
            DBInfo info = (DBInfo)this.bdComboBox.getSelectedItem();
            this.dbNameField.setText(info.getDbServerTitle());
            this.dbURLField.setText(info.getDbServerURL());
            this.proxyHostField.setText(info.getDbServerProxyHost());
            this.proxyPortField.setText(info.getDbServerProxyPort());
            this.dbNameField.setEditable(info.isLocalItem());
            this.dbURLField.setEditable(info.isLocalItem());
            this.proxyHostField.setEditable(info.isLocalItem());
            this.proxyPortField.setEditable(info.isLocalItem());
        });
        this.deleteButton.addActionListener(e -> {
            DBInfo info = (DBInfo)this.bdComboBox.getSelectedItem();
            if (info.isLocalItem()) {
                DBInfo activeInfo = this.dbInfoManager.getActiveDBInfo();
                if (activeInfo == info) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435");
                    return;
                }
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 " + info.getDbServerTitle(), "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0) == 0) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435");
                    return;
                }
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 " + info.getDbServerTitle(), "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0) == 0) {
                    this.dbInfoManager.removeServer(info);
                    this.dbInfoManager.flush();
                    this.loadServers();
                }
            }
        });
        this.quitButton.addActionListener(e -> {
            DBInfo info = (DBInfo)this.bdComboBox.getSelectedItem();
            String message = "\u0422\u0435\u043a\u0443\u0449\u0435\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435  \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c " + info.getDbServerTitle() + " \u043f\u043e\u0434 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c " + info.getDbServerLogin() + " \u0431\u0443\u0434\u0435\u0442 \u0441\u0431\u0440\u043e\u0448\u0435\u043d\u043d\u043e. \u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c? ";
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), message, "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0) == 0) {
                this.userLogin.setEditable(true);
                this.userPswd.setEditable(true);
                this.dbInfoManager.disconnect(info);
            }
        });
        this.panelCard.setLayout(new CardLayout());
        this.panelCard.add((Component)this.getConnectPanel(), MODE_CONNECT);
        this.panelCard.add((Component)this.getEditorPanel(), MODE_EDITOR);
        this.getContentPane().add((Component)this.panelCard, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.okCancelPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 20, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.getRootPane().setDefaultButton(this.okCancelPanel.getButtonOk());
        this.bdComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DBInfo info = (DBInfo)UserAuth.this.bdComboBox.getSelectedItem();
                if (info == null) {
                    return;
                }
                UserAuth.this.userLogin.setText(info.getDbServerLogin());
                UserAuth.this.userPswd.setText(info.getDbServerPassword());
                boolean isAutorized = UserAuth.this.dbInfoManager.isAutorized(info);
                UserAuth.this.userLogin.setEditable(!isAutorized);
                UserAuth.this.userPswd.setEditable(!isAutorized);
                UserAuth.this.saveCheckBox.setEnabled(!isAutorized);
                UserAuth.this.quitButton.setVisible(isAutorized);
                UserAuth.this.deleteButton.setEnabled(info.isLocalItem() && UserAuth.this.bdComboBox.getSelectedIndex() > 0);
                UserAuth.this.saveCheckBox.setSelected(info.isSafe());
            }
        });
        this.bdComboBox.setRenderer(new BGDBComboBoxRenderer());
    }

    public void setSelectedDB(String key) {
        for (int index = 0; index < this.bdComboBox.getItemCount(); ++index) {
            this.dbInfo = (DBInfo)this.bdComboBox.getItemAt(index);
            String dbServerKey = this.dbInfo.getDbServerKey();
            if (dbServerKey == null || !dbServerKey.equals(key)) continue;
            this.bdComboBox.setSelectedIndex(index);
            break;
        }
    }

    private void okCancelPanelActionPerformed(ActionEvent actionEvent) {
        if (BGButtonPanel.OK.getActionCommand().equals(actionEvent.getActionCommand())) {
            this.dbInfo = (DBInfo)this.bdComboBox.getSelectedItem();
            if (this.mode.equals(MODE_CONNECT)) {
                if (this.performConnect2()) {
                    this.result = "ok";
                    this.setVisible(false);
                    this.dispose();
                }
            } else {
                this.performEdit(this.dbInfo);
            }
        } else if (BGButtonPanel.CANCEL.getActionCommand().equals(actionEvent.getActionCommand())) {
            if (MODE_EDITOR.equals(this.mode)) {
                this.mode = MODE_CONNECT;
                ((CardLayout)this.panelCard.getLayout()).show(this.panelCard, this.mode);
            } else {
                this.result = "cancel";
                this.setVisible(false);
                this.dispose();
            }
        }
    }

    private void performEdit(DBInfo dbInfo) {
        if (dbInfo.isLocalItem()) {
            String title = this.dbNameField.getText().trim();
            String url = this.dbURLField.getText().trim();
            String proxy = this.proxyHostField.getText().trim();
            String port = this.proxyPortField.getText().trim();
            if (Utils.isBlankString(title) || Utils.isBlankString(url)) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0437\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0438\u043c\u044f \u0438 URL ");
                return;
            }
            if (dbInfo.getDbServerKey().equals("NEW")) {
                DBInfo newDBInfo = new DBInfo();
                newDBInfo.setLocalItem(true);
                newDBInfo.setDbServerKey(Utils.randomAlphanumeric(10));
                newDBInfo.setDbServerTitle(title);
                newDBInfo.setDbServerURL(url);
                newDBInfo.setDbServerProxyHost(proxy);
                newDBInfo.setDbServerProxyPort(port);
                this.dbInfoManager.addServer(newDBInfo);
                this.dbInfoManager.flush();
                this.loadServers();
                dbInfo = newDBInfo;
            } else {
                dbInfo.setDbServerTitle(title);
                dbInfo.setDbServerURL(url);
                dbInfo.setDbServerProxyHost(proxy);
                dbInfo.setDbServerProxyPort(port);
                this.dbInfoManager.flush();
                this.loadServers();
            }
        }
        dbInfo = this.dbInfoManager.getInfo(dbInfo.getDbServerKey());
        this.setSelectedDB(dbInfo.getDbServerKey());
        this.mode = MODE_CONNECT;
        ((CardLayout)this.panelCard.getLayout()).show(this.panelCard, this.mode);
    }

    private boolean performConnect2() {
        String login = this.userLogin.getText();
        if (login == null || login.trim().length() == 0) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u0432\u0435\u0434\u0435\u043d \u041b\u041e\u0413\u0418\u041d");
            return false;
        }
        char[] pswd = this.userPswd.getPassword();
        if (pswd == null || pswd.length < 5) {
            ClientUtils.showErrorMessageDialog("\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043e\u0442 5 \u0434\u043e 15 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
            return false;
        }
        String passwd = new String(pswd).trim();
        if (this.dbInfo == null) {
            return false;
        }
        this.dbInfo.setDbServerLogin(login);
        this.dbInfo.setDbServerPassword(passwd);
        this.dbInfo.setSafe(this.saveCheckBox.isSelected());
        return true;
    }

    private void this_windowOpened(WindowEvent e) {
        this.userLogin.requestFocusInWindow();
    }

    private JPanel getConnectPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.editButton.setText("...");
        this.editButton.setToolTipText("\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        this.deleteButton.setText("X");
        this.deleteButton.setToolTipText("\u0443\u0434\u0430\u043b\u0438\u0442\u044c");
        this.quitButton.setText("\u0412\u044b\u0439\u0442\u0438");
        this.quitButton.setVisible(false);
        jPanel.add((Component)new JLabel("\u0418\u043c\u044f \u0411\u0414:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add(this.bdComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 5, 0), 0, 0));
        jPanel.add((Component)this.editButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 5, 5, 0), 0, 0));
        jPanel.add((Component)this.deleteButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 5, 5, 0), 0, 0));
        jPanel.add((Component)new JLabel("\u041b\u043e\u0433\u0438\u043d:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this.userLogin, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 5, 0), 0, 0));
        jPanel.add((Component)this.quitButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        jPanel.add((Component)new JLabel("\u041f\u0430\u0440\u043e\u043b\u044c:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this.userPswd, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 13, 1, new Insets(0, 5, 5, 0), 0, 0));
        jPanel.add((Component)this.saveCheckBox, new GridBagConstraints(1, 3, 3, 1, 0.0, 0.0, 13, 1, new Insets(0, 5, 5, 0), 0, 0));
        jPanel.add((Component)new JPanel(), new GridBagConstraints(0, 4, 4, 1, 1.0, 1.0, 13, 1, new Insets(0, 5, 5, 0), 0, 0));
        return jPanel;
    }

    private JPanel getEditorPanel() {
        this.dbNameField.setToolTipText("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0431\u0430\u0437\u044b \u0434\u0430\u043d\u043d\u044b\u0445");
        this.dbURLField.setToolTipText("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 URL \u0431\u0430\u0437\u044b \u0434\u0430\u043d\u043d\u044b\u0445");
        this.proxyHostField.setToolTipText("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 URL proxy \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0434\u043b\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445");
        this.proxyPortField.setToolTipText("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043f\u043e\u0440\u0442 proxy \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0434\u043b\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445");
        this.proxyPortField.setColumns(7);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel("\u0418\u043c\u044f \u0411\u0414:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        jPanel.add((Component)this.dbNameField, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 5, 0), 0, 0));
        jPanel.add((Component)new JLabel("URL \u0411\u0414:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        jPanel.add((Component)this.dbURLField, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 5, 0), 0, 0));
        jPanel.add((Component)new JLabel("Proxy:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        jPanel.add((Component)this.proxyHostField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 5, 0), 0, 0));
        jPanel.add((Component)new JLabel(":"), new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        jPanel.add((Component)this.proxyPortField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        jPanel.add((Component)new JPanel(), new GridBagConstraints(0, 5, 4, 1, 1.0, 1.0, 13, 1, new Insets(0, 5, 5, 0), 0, 0));
        return jPanel;
    }

    public static class BGDBComboBoxRenderer
    extends DefaultListCellRenderer {
        private ImageIcon iconLogin = ClientUtils.getIcon("user.png");

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == BGUComboBox.SEPARATOR || value != null && "-----".equals(value.toString())) {
                return separatorUI;
            }
            boolean isConnect = DBInfoManager.getManager().isAutorized((DBInfo)value);
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            label.setIcon(isConnect && index >= 0 ? this.iconLogin : null);
            return label;
        }
    }
}

