/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBasePrintHyperlink;
import net.sf.jasperreports.engine.export.ExporterFilter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JROriginExporterFilter;
import net.sf.jasperreports.engine.export.oasis.JROdsExporter;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleCsvReportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import net.sf.jasperreports.swing.JRViewerPanel;
import net.sf.jasperreports.view.JRHyperlinkListener;
import net.sf.jasperreports.view.JRSaveContributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.client.util.ClientUtils;

public class JRViewer
extends net.sf.jasperreports.swing.JRViewer {
    private final Logger logger = LogManager.getLogger();
    protected JasperPrint jasperPrint;
    protected boolean lastJasperPrintWasNull = false;
    protected JPanel panelMain;
    protected JScrollPane scrollPaneMain;
    protected JLabel labelPage;
    protected JPanel panelLinks;
    private JRViewerPanel jrViewerPanel;
    private ComponentListener[] componentListeners = null;
    private int pressRectBeginX = 0;
    private int pressRectBeginY = 0;
    private int copyRectBeginX = 0;
    private int copyRectBeginY = 0;
    private int copyRectEndX = 0;
    private int copyRectEndY = 0;
    private int lastCopyRectBeginX = 0;
    private int lastCopyRectBeginY = 0;
    private int lastCopyRectEndX = 0;
    private int lastCopyRectEndY = 0;
    private final Comparator<TextElement> textComparator = new Comparator<TextElement>(){

        @Override
        public int compare(TextElement o1, TextElement o2) {
            return o1.y * 10000 + o1.x - (o2.y * 10000 + o2.x);
        }
    };

    public JRViewer(JasperPrint jasperPrint) throws JRException {
        super(jasperPrint);
        this.jasperPrint = jasperPrint;
        this.initButtons();
        this.fixOnResize();
        String format = ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("page");
        if (format == null) {
            format = "\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 {0} \u0438\u0437 {1}";
        }
        this.lblStatus.setText(MessageFormat.format(format, 1, 1));
    }

    public void addHyperlinkListener(JRHyperlinkListener listener) {
        this.jrViewerPanel.addHyperlinkListener(listener);
    }

    public void removeHyperlinkListener(JRHyperlinkListener listener) {
        this.jrViewerPanel.removeHyperlinkListener(listener);
    }

    public JRHyperlinkListener[] getHyperlinkListeners() {
        return this.jrViewerPanel.getHyperlinkListeners();
    }

    public void addHyperlinkListener(final HyperlinkListener hyperlinkListener) {
        this.jrViewerPanel.addHyperlinkListener(new JRHyperlinkListener(){

            public void gotoHyperlink(JRPrintHyperlink printHyperlink) throws JRException {
                try {
                    URL url = new URL(printHyperlink.getHyperlinkAnchor());
                    hyperlinkListener.hyperlinkUpdate(new HyperlinkEvent(printHyperlink, HyperlinkEvent.EventType.ACTIVATED, url, printHyperlink.getHyperlinkTooltip()));
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void gotoHyperlink(JRBasePrintHyperlink printHyperlink) {
        for (JRHyperlinkListener listener : this.jrViewerPanel.getHyperlinkListeners()) {
            try {
                listener.gotoHyperlink((JRPrintHyperlink)printHyperlink);
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        }
    }

    protected JRViewerPanel createViewerPanel() {
        if (this.jrViewerPanel == null) {
            this.jrViewerPanel = super.createViewerPanel();
        }
        return this.jrViewerPanel;
    }

    public void setReport(JasperPrint jasperPrint) {
        boolean lastJasperPrintWasNull = this.jasperPrint == null;
        this.jasperPrint = jasperPrint;
        this.loadReport(jasperPrint);
        this.fixOnResize();
        this.refreshPage();
        if (this.scrollPaneMain != null) {
            this.scrollPaneMain.getViewport().setViewPosition(new Point(0, 0));
        }
        this.lastJasperPrintWasNull = lastJasperPrintWasNull;
    }

    public void loadReport(JasperPrint report) {
        if (report != null) {
            this.viewerContext.loadReport(report);
        }
        this.tlbToolBar.setEnabled(report != null);
    }

    protected void refreshPage() {
        this.viewerContext.refreshPage();
    }

    private void fixOnResize() {
        block3: {
            block4: {
                if (this.panelMain == null) break block3;
                if (this.jasperPrint != null) break block4;
                if (this.lastJasperPrintWasNull) break block3;
                for (ComponentListener l : this.componentListeners = this.panelMain.getComponentListeners()) {
                    this.panelMain.removeComponentListener(l);
                }
                break block3;
            }
            if (this.lastJasperPrintWasNull) {
                for (ComponentListener l : this.componentListeners) {
                    this.panelMain.addComponentListener(l);
                }
            }
        }
    }

    private void initButtons() {
        try {
            this.panelMain = (JPanel)((BorderLayout)this.getLayout()).getLayoutComponent("Center");
            this.scrollPaneMain = (JScrollPane)((BorderLayout)this.panelMain.getLayout()).getLayoutComponent("Center");
            JPanel panelInScroll = (JPanel)this.scrollPaneMain.getViewport().getView();
            JPanel panelPage = (JPanel)panelInScroll.getComponent(0);
            JPanel jpanel4 = (JPanel)((BorderLayout)panelPage.getLayout()).getLayoutComponent("Center");
            for (Component c : jpanel4.getComponents()) {
                JPanel panelLinks;
                if (c instanceof JLabel) {
                    this.labelPage = (JLabel)c;
                }
                if (!(c instanceof JPanel) || (panelLinks = (JPanel)c).getLayout() != null) continue;
                this.panelLinks = panelLinks;
            }
            this.initCopy(jpanel4);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initCopy(JPanel jpanel4) throws Exception {
        MouseListener[] mls;
        MouseMotionListener[] ls;
        Color _c = UIManager.getColor("Table.selectionBackground");
        final Color c = _c != null ? new Color(_c.getRed(), _c.getGreen(), _c.getBlue(), 100) : new Color(193, 214, 230, 100);
        final Border highlightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
        final ImageIcon iconCopy = ClientUtils.getIcon("page_copy.png");
        final JPanel panelCopy = new JPanel(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
            }

            @Override
            public void paintAll(Graphics g) {
            }

            @Override
            protected void paintComponent(Graphics g) {
                g.setColor(c);
                g.fillRect(JRViewer.this.copyRectBeginX, JRViewer.this.copyRectBeginY, JRViewer.this.copyRectEndX, JRViewer.this.copyRectEndY);
                highlightBorder.paintBorder(this, g, JRViewer.this.copyRectBeginX, JRViewer.this.copyRectBeginY, JRViewer.this.copyRectEndX, JRViewer.this.copyRectEndY);
                if (JRViewer.this.copyRectEndX >= 20 && JRViewer.this.copyRectEndY >= 20) {
                    iconCopy.paintIcon(this, g, JRViewer.this.copyRectBeginX + JRViewer.this.copyRectEndX - 18, JRViewer.this.copyRectBeginY + JRViewer.this.copyRectEndY - 18);
                }
                JRViewer.this.lastCopyRectBeginX = JRViewer.this.copyRectBeginX;
                JRViewer.this.lastCopyRectBeginY = JRViewer.this.copyRectBeginY;
                JRViewer.this.lastCopyRectEndX = JRViewer.this.copyRectEndX;
                JRViewer.this.lastCopyRectEndY = JRViewer.this.copyRectEndY;
            }

            @Override
            protected void paintBorder(Graphics g) {
            }

            @Override
            protected void paintChildren(Graphics g) {
            }
        };
        panelCopy.setLayout(null);
        panelCopy.setMinimumSize(new Dimension(5, 5));
        panelCopy.setPreferredSize(new Dimension(5, 5));
        panelCopy.setOpaque(false);
        panelCopy.setDoubleBuffered(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.labelPage.setLayout(new GridBagLayout());
        this.labelPage.add((Component)panelCopy, gridBagConstraints);
        for (MouseMotionListener l : ls = this.panelLinks.getMouseMotionListeners()) {
            this.panelLinks.removeMouseMotionListener(l);
        }
        for (MouseListener l : mls = this.panelLinks.getMouseListeners()) {
            this.panelLinks.removeMouseListener(l);
        }
        this.panelLinks.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                if (SwingUtilities.isRightMouseButton(evt)) {
                    JRViewer.this.copyRectEndX = Math.min(Math.max(1, evt.getX()), JRViewer.this.labelPage.getWidth() - 3);
                    JRViewer.this.copyRectEndY = Math.min(Math.max(1, evt.getY()), JRViewer.this.labelPage.getHeight() - 3);
                    if (JRViewer.this.copyRectEndX < JRViewer.this.pressRectBeginX) {
                        JRViewer.this.copyRectBeginX = JRViewer.this.copyRectEndX;
                        JRViewer.this.copyRectEndX = JRViewer.this.pressRectBeginX - JRViewer.this.copyRectBeginX;
                    } else {
                        JRViewer.this.copyRectEndX -= JRViewer.this.pressRectBeginX;
                        JRViewer.this.copyRectBeginX = JRViewer.this.pressRectBeginX;
                    }
                    if (JRViewer.this.copyRectEndY < JRViewer.this.pressRectBeginY) {
                        JRViewer.this.copyRectBeginY = JRViewer.this.copyRectEndY;
                        JRViewer.this.copyRectEndY = JRViewer.this.pressRectBeginY - JRViewer.this.copyRectBeginY;
                    } else {
                        JRViewer.this.copyRectEndY -= JRViewer.this.pressRectBeginY;
                        JRViewer.this.copyRectBeginY = JRViewer.this.pressRectBeginY;
                    }
                    int w = JRViewer.this.lastCopyRectBeginX > JRViewer.this.copyRectBeginX ? JRViewer.this.lastCopyRectBeginX - JRViewer.this.copyRectBeginX + JRViewer.this.lastCopyRectEndX + 1 : Math.max(JRViewer.this.copyRectEndX, JRViewer.this.lastCopyRectEndX) + 1;
                    int h = JRViewer.this.lastCopyRectBeginY > JRViewer.this.copyRectBeginY ? JRViewer.this.lastCopyRectBeginY - JRViewer.this.copyRectBeginY + JRViewer.this.lastCopyRectEndY + 1 : Math.max(JRViewer.this.copyRectEndY, JRViewer.this.lastCopyRectEndY) + 1;
                    panelCopy.repaint(Math.min(JRViewer.this.copyRectBeginX, JRViewer.this.lastCopyRectBeginX) - 1, Math.min(JRViewer.this.copyRectBeginY, JRViewer.this.lastCopyRectBeginY) - 1, w, h);
                } else {
                    for (MouseMotionListener l : ls) {
                        l.mouseDragged(evt);
                    }
                }
            }
        });
        this.panelLinks.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (SwingUtilities.isRightMouseButton(evt)) {
                    JRViewer.this.pressRectBeginX = Math.min(Math.max(1, evt.getX()), JRViewer.this.labelPage.getWidth() - 3);
                    JRViewer.this.pressRectBeginY = Math.min(Math.max(1, evt.getY()), JRViewer.this.labelPage.getHeight() - 3);
                    JRViewer.this.lastCopyRectBeginX = JRViewer.this.pressRectBeginX;
                    JRViewer.this.lastCopyRectBeginY = JRViewer.this.pressRectBeginY;
                } else {
                    for (MouseListener mouseListener : mls) {
                        mouseListener.mousePressed(evt);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (SwingUtilities.isRightMouseButton(evt)) {
                    StringSelection data = new StringSelection(JRViewer.this.copyFrom(JRViewer.this.copyRectBeginX, JRViewer.this.copyRectBeginY, JRViewer.this.copyRectEndX, JRViewer.this.copyRectEndY));
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(data, data);
                    JRViewer.this.copyRectBeginX = 0;
                    JRViewer.this.copyRectBeginY = 0;
                    JRViewer.this.copyRectEndX = 0;
                    JRViewer.this.copyRectEndY = 0;
                    panelCopy.repaint(JRViewer.this.lastCopyRectBeginX - 1, JRViewer.this.lastCopyRectBeginY - 1, JRViewer.this.lastCopyRectEndX + 1, JRViewer.this.lastCopyRectEndY + 1);
                } else {
                    for (MouseListener mouseListener : mls) {
                        mouseListener.mouseReleased(evt);
                    }
                }
            }
        });
    }

    protected String copyFrom(int x, int y, int w, int h) {
        StringBuilder sb = new StringBuilder();
        List pages = this.jasperPrint.getPages();
        JRPrintPage page = (JRPrintPage)pages.get(this.getPageIndex());
        float z = 1.0f;
        x = (int)((float)x * z);
        y = (int)((float)y * z);
        w = (int)((float)w * z);
        h = (int)((float)h * z);
        List elements = page.getElements();
        ArrayList<TextElement> textElements = new ArrayList<TextElement>();
        this.addElements(textElements, x, y, w += x, h += y, elements, 0, 0);
        if (textElements.size() > 0) {
            TextElement e;
            Collections.sort(textElements, this.textComparator);
            Iterator iter = textElements.iterator();
            if (iter.hasNext()) {
                e = (TextElement)iter.next();
                sb.append(e.text.getFullText());
                y = e.y;
            }
            while (iter.hasNext()) {
                e = (TextElement)iter.next();
                if (y != e.y) {
                    sb.append('\n');
                    y = e.y;
                } else {
                    sb.append('\t');
                }
                sb.append(e.text.getFullText());
            }
        }
        return sb.toString();
    }

    private void addElements(List<TextElement> textElements, int x, int y, int w, int h, Collection<?> elements, int offsetX, int offsetY) {
        for (Object element : elements) {
            if (element instanceof JRPrintText) {
                JRPrintText e = (JRPrintText)element;
                int xx = e.getX() + offsetX;
                int yy = e.getY() + offsetY;
                int ww = xx + e.getWidth();
                int hh = yy + e.getHeight();
                if (!(xx >= x && xx <= w || ww >= x && ww <= w) && (xx >= x || ww <= w) || !(yy >= y && yy <= h || hh >= y && hh <= h) && (yy >= y || hh <= h)) continue;
                textElements.add(new TextElement(xx, yy, e));
                continue;
            }
            if (!(element instanceof JRPrintFrame)) continue;
            JRPrintFrame f = (JRPrintFrame)element;
            this.addElements(textElements, x, y, w, h, f.getElements(), f.getX(), f.getY());
        }
    }

    private void btnSaveActionPerf(ActionEvent evt) {
        JRSaveContributor pdfSaveContrib;
        JFileChooser fileChooser = new JFileChooser();
        ArrayList<Class> params = new ArrayList<Class>();
        params.add(Locale.class);
        params.add(ResourceBundle.class);
        JRSaveContributor pdfFileFilter = null;
        pdfFileFilter = pdfSaveContrib = this.getContributor(fileChooser, "net.sf.jasperreports.view.save.JRPdfSaveContributor", null);
        JRSaveContributor htmlSaver = this.getContributor(fileChooser, "net.sf.jasperreports.view.save.JRHtmlSaveContributor", null);
        FileFilter csvFileFilter = this.getFilter("CSV (*.csv)", ".csv");
        FileFilter csvIgnorePaginationFileFilter = this.getFilter("CSV \u043e\u0434\u043d\u043e\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435\u0439 (*.csv)", ".csv");
        fileChooser.addChoosableFileFilter(csvFileFilter);
        fileChooser.addChoosableFileFilter(csvIgnorePaginationFileFilter);
        JRSaveContributor xlsSingleSheetSaver = this.getContributor(fileChooser, "net.sf.jasperreports.view.save.JRSingleSheetXlsSaveContributor", "XLS (*.xls)");
        this.getContributor(fileChooser, "net.sf.jasperreports.view.save.JRMultipleSheetsXlsSaveContributor", "XLS \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430-\u043b\u0438\u0441\u0442 (*.xls)");
        this.getContributor(fileChooser, "net.sf.jasperreports.view.save.JRRtfSaveContributor", "RTF (*.rtf)");
        this.getContributor(fileChooser, "net.sf.jasperreports.view.save.JROdtSaveContributor", "ODT (*.odt)");
        FileFilter odfFilter = this.getFilter("ODS \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u0430 (*.ods)", ".ods");
        fileChooser.addChoosableFileFilter(odfFilter);
        JRSaveContributor xmlSaver = this.getContributor(fileChooser, "net.sf.jasperreports.view.save.JRXmlSaveContributor", null);
        this.getContributor(fileChooser, "net.sf.jasperreports.view.save.JREmbeddedImagesXmlSaveContributor", null);
        FileFilter jrprintFileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().toLowerCase().endsWith(".jrprint");
            }

            @Override
            public String getDescription() {
                return "JasperReports (*.jrprint)";
            }
        };
        fileChooser.addChoosableFileFilter(jrprintFileFilter);
        fileChooser.setFileFilter((FileFilter)(pdfFileFilter != null ? pdfFileFilter : jrprintFileFilter));
        int retValue = fileChooser.showSaveDialog((Component)((Object)this));
        if (retValue == 0) {
            FileFilter fileFilter = fileChooser.getFileFilter();
            File file = fileChooser.getSelectedFile();
            String lowerCaseFileName = file.getName().toLowerCase();
            try {
                if (fileFilter == jrprintFileFilter) {
                    if (!file.getName().endsWith(".jrprint")) {
                        file = new File(file.getAbsolutePath() + ".jrprint");
                    }
                    JRSaver.saveObject((Object)this.jasperPrint, (File)file);
                } else if (fileFilter instanceof JRSaveContributor) {
                    ((JRSaveContributor)fileFilter).save(this.jasperPrint, file);
                } else if (fileFilter instanceof JRFileFilter) {
                    ((JRFileFilter)fileFilter).contr.save(this.jasperPrint, file);
                } else if (lowerCaseFileName.endsWith(".jrprint")) {
                    JRSaver.saveObject((Object)this.jasperPrint, (File)file);
                } else if (lowerCaseFileName.endsWith(".pdf") && pdfSaveContrib != null) {
                    pdfSaveContrib.save(this.jasperPrint, file);
                } else if ((lowerCaseFileName.endsWith(".html") || lowerCaseFileName.endsWith(".htm")) && htmlSaver != null) {
                    htmlSaver.save(this.jasperPrint, file);
                } else if (lowerCaseFileName.endsWith(".xls") && xlsSingleSheetSaver != null) {
                    xlsSingleSheetSaver.save(this.jasperPrint, file);
                } else if (fileFilter == csvIgnorePaginationFileFilter) {
                    if (!file.getName().endsWith(".csv")) {
                        file = new File(file.getAbsolutePath() + ".csv");
                    }
                    this.exportCsv(new JRCsvExporter(), this.jasperPrint, file, true);
                } else if (fileFilter == csvFileFilter || lowerCaseFileName.endsWith(".csv")) {
                    if (!file.getName().endsWith(".csv")) {
                        file = new File(file.getAbsolutePath() + ".csv");
                    }
                    this.exportCsv(new JRCsvExporter(), this.jasperPrint, file, false);
                } else if (fileFilter == odfFilter || lowerCaseFileName.endsWith(".odf")) {
                    if (!file.getName().endsWith(".odf")) {
                        file = new File(file.getAbsolutePath() + ".odf");
                    }
                    this.export(new JROdsExporter(), this.jasperPrint, file);
                } else if (lowerCaseFileName.endsWith(".xml") || lowerCaseFileName.endsWith(".jrpxml") && xmlSaver != null) {
                    xmlSaver.save(this.jasperPrint, file);
                } else {
                    if (!file.getName().endsWith(".jrprint")) {
                        file = new File(file.getAbsolutePath() + ".jrprint");
                    }
                    JRSaver.saveObject((Object)this.jasperPrint, (File)file);
                }
            }
            catch (JRException e) {
                ClientUtils.showErrorMessageDialog(e.getCause() != null ? e.getCause().getLocalizedMessage() : e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
    }

    private JRSaveContributor getContributor(JFileChooser fileChooser, String className, String pattern) {
        JRSaveContributor result = null;
        try {
            Class pdfSaveContribClass = JRClassLoader.loadClassForName((String)className);
            Constructor<?> constuctor = this.getConstuctor(pdfSaveContribClass);
            result = (JRSaveContributor)constuctor.newInstance(new Locale("ru"), null);
            if (pattern != null) {
                fileChooser.addChoosableFileFilter(new JRFileFilter(result, pattern));
            } else {
                fileChooser.addChoosableFileFilter((FileFilter)result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private Constructor<?> getConstuctor(Class<?> clazz) throws NoSuchMethodException {
        return clazz.getConstructor(Locale.class, ResourceBundle.class);
    }

    private void exportCsv(JRCsvExporter exporter, JasperPrint print, File file, boolean ignorePages) throws JRException {
        String title = ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("save");
        String message = MessageFormat.format(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("file.exists"), file.getName());
        if (!file.exists() || 0 == JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), message, title, 2)) {
            exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
            String encoding = null;
            try {
                encoding = ResourceBundle.getBundle("jasperreports").getString("net.sf.jasperreports.export.csv.character.encoding");
            }
            catch (Exception exception) {
                // empty catch block
            }
            exporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput(file, encoding != null ? encoding : "UTF-8"));
            if (ignorePages) {
                JRPropertiesMap propertiesMap = this.jasperPrint.getPropertiesMap();
                propertiesMap.setProperty("net.sf.jasperreports.export.csv.exclude.origin.keep.first.band.x1", "pageHeader");
                propertiesMap.setProperty("net.sf.jasperreports.export.csv.exclude.origin.band.x2", "pageFooter");
                SimpleCsvReportConfiguration configuration = new SimpleCsvReportConfiguration();
                configuration.setExporterFilter((ExporterFilter)JROriginExporterFilter.getFilter((JasperReportsContext)DefaultJasperReportsContext.getInstance(), (JRPropertiesMap)propertiesMap, (String)"net.sf.jasperreports.export.csv.exclude.origin."));
                exporter.setConfiguration((ReportExportConfiguration)configuration);
            }
            exporter.exportReport();
        }
    }

    private void export(JROdsExporter exporter, JasperPrint print, File file) throws JRException {
        String title = ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("save");
        String message = MessageFormat.format(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("file.exists"), file.getName());
        if (!file.exists() || 0 == JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), message, title, 2)) {
            exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.jasperPrint));
            exporter.exportReport();
        }
    }

    private FileFilter getFilter(final String title, final String filter) {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().toLowerCase().endsWith(filter);
            }

            @Override
            public String getDescription() {
                return title;
            }
        };
    }

    private class TextElement {
        private final int x;
        private final int y;
        private final JRPrintText text;

        public TextElement(int x, int y, JRPrintText text) {
            this.x = x;
            this.y = y;
            this.text = text;
        }
    }

    private class JRFileFilter
    extends FileFilter {
        private final JRSaveContributor contr;
        private final String desc;

        public JRFileFilter(JRSaveContributor contr, String desc) {
            this.contr = contr;
            this.desc = desc;
        }

        @Override
        public boolean accept(File f) {
            return this.contr.accept(f);
        }

        @Override
        public String getDescription() {
            return this.desc != null ? this.desc : this.contr.getDescription();
        }
    }
}

