/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.directory;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelDate;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import bitel.billing.module.contract.directory.AddressList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;

public class HouseEditor
extends BGPanel
implements ActionListener {
    public BGComboBox<ComboBoxItem> city = new BGComboBox();
    public BGComboBox<ComboBoxItem> area = new BGComboBox();
    public BGComboBox<ComboBoxItem> quarter = new BGComboBox();
    public BGComboBox<ComboBoxItem> street = new BGComboBox();
    public JTextArea comment = new JTextArea();
    public JTextField house = new JTextField();
    public IntTextField box_index = new IntTextField();
    public IntTextField amount = new IntTextField();
    public BGControlPanelDate datePanel = new BGControlPanelDate();
    private AddressList areasList = null;
    private AddressList quartersList = null;
    private AddressList streetsList = null;

    @Override
    public void init(String module, int mid) {
        module = "admin";
        super.init(module, mid);
    }

    public HouseEditor() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JPanel cityPanel = new JPanel(new GridBagLayout());
        JPanel areaPanel = new JPanel(new GridBagLayout());
        JPanel quarterPanel = new JPanel(new GridBagLayout());
        JPanel streetPanel = new JPanel(new GridBagLayout());
        JPanel housePanel = new JPanel(new GridBagLayout());
        JPanel box_indexPanel = new JPanel(new GridBagLayout());
        JPanel amountPanel = new JPanel(new GridBagLayout());
        JPanel commentPanel = new JPanel(new GridBagLayout());
        cityPanel.setBorder(new BGTitleBorder(" \u0413\u043e\u0440\u043e\u0434 "));
        areaPanel.setBorder(new BGTitleBorder(" \u0420\u0430\u0439\u043e\u043d "));
        quarterPanel.setBorder(new BGTitleBorder(" \u041a\u0432\u0430\u0440\u0442\u0430\u043b "));
        streetPanel.setBorder(new BGTitleBorder(" \u0423\u043b\u0438\u0446\u0430 "));
        housePanel.setBorder(new BGTitleBorder(" \u0414\u043e\u043c/\u0414\u0440\u043e\u0431\u044c "));
        box_indexPanel.setBorder(new BGTitleBorder(" \u0418\u043d\u0434\u0435\u043a\u0441 "));
        amountPanel.setBorder(new BGTitleBorder(" \u041a\u0432\u0430\u0440\u0442\u0438\u0440 "));
        commentPanel.setBorder(new BGTitleBorder(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "));
        this.comment.setMinimumSize(new Dimension(485, 40));
        this.comment.setOpaque(true);
        this.comment.setPreferredSize(new Dimension(485, 40));
        this.comment.setText("");
        this.comment.setLineWrap(true);
        this.comment.setRows(2);
        this.comment.setWrapStyleWord(true);
        this.city.setMinimumSize(new Dimension(110, 25));
        this.city.setPreferredSize(new Dimension(110, 25));
        this.house.setMinimumSize(new Dimension(4, 24));
        this.house.setPreferredSize(new Dimension(59, 24));
        this.box_index.setMinimumSize(new Dimension(70, 24));
        this.box_index.setPreferredSize(new Dimension(59, 24));
        this.box_index.setColumns(6);
        this.box_index.setHorizontalAlignment(0);
        this.amount.setMinimumSize(new Dimension(37, 24));
        this.amount.setPreferredSize(new Dimension(59, 24));
        this.amount.setColumns(3);
        JScrollPane jScrollPane1 = new JScrollPane(this.comment);
        jScrollPane1.setMinimumSize(new Dimension(22, 40));
        jScrollPane1.setPreferredSize(new Dimension(488, 40));
        this.add((Component)cityPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        cityPanel.add(this.city, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)areaPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        areaPanel.add(this.area, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.street.setMaximumSize(new Dimension(120, 24));
        this.street.setPreferredSize(new Dimension(120, 24));
        this.add((Component)streetPanel, new GridBagConstraints(2, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        streetPanel.add(this.street, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)housePanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        housePanel.add((Component)this.house, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)box_indexPanel, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        box_indexPanel.add((Component)this.box_index, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)amountPanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        amountPanel.add((Component)this.amount, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.datePanel, new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)commentPanel, new GridBagConstraints(0, 3, 5, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        commentPanel.add((Component)jScrollPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)quarterPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        quarterPanel.add(this.quarter, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.city.addActionListener(e -> this.setAddressToEditor());
        this.street.addActionListener(e -> this.setIndex());
        this.house.addActionListener(e -> this.setIndex());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public void setAddressMap(Document doc) {
        this.areasList = new AddressList(XMLUtils.selectNode(doc, "/data/areas"));
        this.streetsList = new AddressList(XMLUtils.selectNode(doc, "/data/streets"));
        this.quartersList = new AddressList(XMLUtils.selectNode(doc, "/data/quarters"));
        this.city.setModel(ClientUtils.buildComboBox(XMLUtils.selectNode(doc, "/data/cities"), null));
    }

    public void setCityComboBox(String cityId) {
        boolean find = false;
        for (int i = 0; i < this.city.getItemCount(); ++i) {
            ComboBoxItem item = (ComboBoxItem)this.city.getItemAt(i);
            if (!cityId.equals(item.getObject().toString())) continue;
            this.city.setSelectedIndex(i);
            find = true;
            break;
        }
        if (!find) {
            this.city.setSelectedIndex(0);
        }
    }

    public void setStreetComboBox(String addressId) {
        this.setAddresInComboBox(this.street, this.streetsList, addressId);
    }

    public void setAreaComboBox(String addressId) {
        this.setAddresInComboBox(this.area, this.areasList, addressId);
    }

    public void setQuarterComboBox(String addressId) {
        this.setAddresInComboBox(this.quarter, this.quartersList, addressId);
    }

    private void setAddresInComboBox(JComboBox<ComboBoxItem> comboBox, AddressList addr, String addressId) {
        ComboBoxItem item;
        boolean find = false;
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            item = comboBox.getItemAt(i);
            if (!addressId.equals(item.getObject().toString())) continue;
            comboBox.setSelectedIndex(i);
            find = true;
            break;
        }
        if (!find && !addressId.equals("0")) {
            Map<String, String> val = addr.getAddressById(Integer.valueOf(addressId));
            if (val != null) {
                item = new ComboBoxItem(addressId, val.get("title") + "[\u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0433\u043e\u0440\u043e\u0434]");
                for (String key : val.keySet()) {
                    item.put(key, val.get(key));
                }
                ((DefaultComboBoxModel)comboBox.getModel()).insertElementAt(item, 0);
                comboBox.setSelectedIndex(0);
            } else {
                comboBox.setSelectedIndex(-1);
            }
        }
    }

    private void setAddressToEditor() {
        int cityid = Integer.valueOf(this.city.getSelectedItem().getObject().toString());
        this.areasList.buildComboBox(this.area, cityid, false, true);
        this.quartersList.buildComboBox(this.quarter, cityid, false, true);
        this.streetsList.buildComboBox(this.street, cityid, false, false);
    }

    private void setIndex() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("GetHouseIndex");
        ComboBoxItem item = this.street.getSelectedItem();
        if (item != null) {
            request.setAttribute("street_id", (String)item.get("id"));
        } else {
            request.setAttribute("street_id", -1);
        }
        request.setAttribute("houseAndFrac", this.house.getText().trim());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            Element index = XMLUtils.selectElement(doc, "/data/index");
            this.box_index.setText(index.getAttribute("value"));
        }
    }

    public boolean checkAddress() {
        if (this.city.getSelectedIndex() == -1) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0433\u043e\u0440\u043e\u0434");
            return false;
        }
        if (this.area.getSelectedIndex() == -1) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0440\u0430\u0439\u043e\u043d");
            return false;
        }
        if (this.quarter.getSelectedIndex() == -1) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u043a\u0432\u0430\u0440\u0442\u0430\u043b");
            return false;
        }
        if (this.street.getSelectedIndex() == -1) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u0443\u043b\u0438\u0446\u0430");
            return false;
        }
        if ("".equals(this.house.getText().trim())) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u0432\u0435\u0434\u0435\u043d\u043e \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435:  \u0434\u043e\u043c");
            return false;
        }
        if ("".equals(this.amount.getText().trim())) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u0432\u0435\u0434\u0435\u043d\u043e \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435:  \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e");
            return false;
        }
        return true;
    }

    public AddressList getAreasList() {
        return this.areasList;
    }

    public AddressList getQuartersList() {
        return this.quartersList;
    }

    public AddressList getStreetsList() {
        return this.streetsList;
    }
}

