/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.directory;

import bitel.billing.module.common.BGControlPanelStringInput;
import bitel.billing.module.common.ListItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ListParamValuesEditor
extends BGPanel
implements ActionListener {
    private String editID = null;
    private String tabName = null;
    private DefaultListModel<ListItem> valuesModel = new DefaultListModel();
    private JList<ListItem> valuesList = new JList<ListItem>(this.valuesModel);
    private JButton closeButton = new JButton();
    private BGDialogToolBar toolBar = new BGDialogToolBar();
    private BGControlPanelStringInput editor = new BGControlPanelStringInput();
    protected String action = "ListValue";

    public ListParamValuesEditor() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.toolBar.setDefaultButtons(this);
        this.toolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem"});
        this.toolBar.setFloatable(false);
        this.editor.setVisible(false);
        this.editor.setActionListener(e -> this.stopEdit(e.getActionCommand() != null && e.getActionCommand().equals("ok")));
        this.valuesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (ListParamValuesEditor.this.tabName.equals("customListValue")) {
                        ListItem item = ListParamValuesEditor.this.valuesList.getSelectedValue();
                        ListParamValuesEditor.this.editor.setValue(item.getText());
                        ListParamValuesEditor.this.editID = (String)item.getAttribute("id");
                        ListParamValuesEditor.this.stopEdit(true);
                    } else {
                        ListParamValuesEditor.this.editItem();
                    }
                }
            }
        });
        this.valuesList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ListItem li;
                if ((e.getModifiersEx() & 0x80) > 0 && e.getKeyCode() == 73 && (li = ListParamValuesEditor.this.valuesList.getSelectedValue()) != null) {
                    ClientUtils.showMessageDialog("\u041a\u043e\u0434 = " + (String)li.getAttribute("id"), "\u041a\u043e\u0434 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f");
                }
            }
        });
    }

    private void jbInit() throws Exception {
        this.valuesList.setSelectionMode(0);
        this.closeButton.setToolTipText("");
        this.closeButton.setText("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
        this.closeButton.addActionListener(e -> this.close_Button_actionPerformed(e));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this.closeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add(Box.createHorizontalStrut(8), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane valuesListPane = new JScrollPane(this.valuesList);
        valuesListPane.setPreferredSize(new Dimension(50, 150));
        valuesListPane.setMinimumSize(new Dimension(50, 150));
        this.setLayout(new GridBagLayout());
        this.setBorder(new BGTitleBorder(" \u0414\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f"));
        this.add((Component)this.toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)valuesListPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction(this.action + "s");
        request.setAttribute("pid", this.getId());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            ClientUtils.buildList(this.valuesList, this.valuesModel, XMLUtils.selectNode(doc, "//values"));
        }
    }

    @Override
    public void deleteItem() {
        this.editID = this.getSelectedId();
        if (this.id != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("Delete" + this.action);
            request.setAttribute("id", this.editID);
            if (ClientUtils.checkStatus(this.getDocument(request))) {
                this.setData();
            }
        }
    }

    @Override
    public void editItem() {
        this.editID = this.getSelectedId();
        if (this.editID != null) {
            ListItem item = this.valuesList.getSelectedValue();
            this.editor.setValue(item.getText());
            this.editor.setVisible(true);
        }
    }

    @Override
    public void newItem() {
        this.editID = "new";
        this.editor.setValue("");
        this.editor.setVisible(true);
    }

    private String getSelectedId() {
        String id = null;
        ListItem li = this.valuesList.getSelectedValue();
        if (li != null) {
            id = (String)li.getAttribute("id");
        }
        return id;
    }

    private void stopEdit(boolean save) {
        String title = this.editor.getValue();
        if (save) {
            if (title == null || title.length() == 0) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443");
            } else {
                Request request = new Request();
                request.setModule(this.module);
                request.setAction("Update" + this.action);
                request.setAttribute("id", Utils.parseInt(this.editID));
                request.setAttribute("pid", this.getId());
                request.setAttribute("title", title);
                if (ClientUtils.checkStatus(this.getDocument(request))) {
                    this.editor.setVisible(false);
                    this.setData();
                }
            }
        } else {
            this.editor.setVisible(false);
        }
    }

    public void close_Button_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    public void setTabName(String tabName) {
        this.tabName = tabName;
    }
}

