/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.directory;

import bitel.billing.module.common.BGBorderFactory;
import bitel.billing.module.common.ListItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;

public class SimpleEditor
extends BGPanel {
    private String id = null;
    private int mode;
    private String nameEditor;
    private BGButtonPanelRestoreOkCancelHelp bGControlPanel_02 = new BGButtonPanelRestoreOkCancelHelp();
    private JTextField title = new JTextField();
    private JPanel editorPanel = new JPanel(new GridBagLayout());
    private JList<ListItem> list = new JList();

    public SimpleEditor(String nameEditor, int mode) {
        this.nameEditor = nameEditor;
        this.mode = mode;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.editorPanel.setVisible(false);
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ListItem li;
                if ((e.getModifiersEx() & 0x80) > 0 && e.getKeyCode() == 73 && (li = SimpleEditor.this.list.getSelectedValue()) != null) {
                    ClientUtils.showMessageDialog("\u041a\u043e\u0434 = " + (String)li.getAttribute("id"), "\u041a\u043e\u0434 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f");
                }
            }
        });
    }

    private void jbInit() throws Exception {
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this.title.setPreferredSize(new Dimension(this.title.getPreferredSize().width, 24));
        this.editorPanel.setBorder(new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        jPanel3.setBorder(new BGTitleBorder(this.nameEditor));
        this.bGControlPanel_02.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleEditor.this.bGControlPanel_02_actionPerformed(e);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SimpleEditor.this.list_mouseClicked(e);
            }
        });
        this.list.setBorder(BGBorderFactory.createEmptyBorder());
        this.editorPanel.add((Component)this.bGControlPanel_02, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(15, 10, 5, 10), 0, 0));
        this.editorPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)new JScrollPane(this.list), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        jPanel2.add((Component)new JLabel("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        jPanel2.add((Component)this.title, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.editorPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("ListDirectory");
        request.setAttribute("mode", this.mode);
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.setDocument(doc);
        }
    }

    @Override
    public void setDocument(Document doc) {
        this.id = null;
        ClientUtils.buildList(this.list, XMLUtils.selectNode(doc, "//directory"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("newItem".equals(actionCommand)) {
            this.editorPanel.setVisible(true);
            this.id = "new";
            this.title.setText("");
        } else if ("editItem".equals(actionCommand)) {
            this.editItem();
        } else if ("deleteItem".equals(actionCommand)) {
            if (this.list.getSelectedValue() == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f!");
                return;
            }
            ListItem item = this.list.getSelectedValue();
            if (!ClientUtils.confirmDelete(item)) {
                return;
            }
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("DeleteDirectoryItem");
            request.setAttribute("mode", this.mode);
            request.setAttribute("id", item.getAttribute("id"));
            if (!ClientUtils.checkStatus(this.getDocument(request))) {
                return;
            }
            this.setData();
        } else if ("refresh".equals(actionCommand)) {
            this.setData();
        }
    }

    void bGControlPanel_02_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("ok".equals(actionCommand)) {
            if (this.title.getText().trim().length() == 0) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435");
                return;
            }
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("UpdateDirectoryItem");
            request.setAttribute("mode", this.mode);
            request.setAttribute("id", this.id);
            request.setAttribute("title", this.title.getText().trim());
            if (ClientUtils.checkStatus(this.getDocument(request))) {
                this.setData();
            }
            this.editorPanel.setVisible(false);
        } else if ("reset".equals(actionCommand)) {
            this.editItem();
        } else if ("cancel".equals(actionCommand)) {
            this.editorPanel.setVisible(false);
        } else if ("help".equals(actionCommand)) {
            this.openHelp(this.getClass().getName());
        }
    }

    void list_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.editItem();
        }
    }

    @Override
    public void editItem() {
        if (this.list.isSelectionEmpty()) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
            return;
        }
        this.editorPanel.setVisible(true);
        ListItem item = this.list.getSelectedValue();
        this.id = (String)item.getAttribute("id");
        this.title.setText(item.toString());
    }
}

