/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.runner;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class BGClientRunnerCipher {
    private static final String rsa_1_pb = "30820122300D06092A864886F70D01010105000382010F003082010A0282010100978E593CC2FEE745952032B8D9B8C389DBC5CA4F7D30DEFE5E9B25BB379A4145242C0233639A233FF3B3F2706E4D1EAC391B3B83DDC7F7092525CB891A3531D148879CFB6875A774210D859628EED094C54D6C3C2BBAA68FC449DB0F37AA34F8251C12C9ED3A6C299B65A3DD45107B66267889729A76956893BEEC16F12D1CB2EE42F7C72CE2828E832913E522A92ACE4C67B5664BBB769F4974A8018BAC0005762FEB289B00BF224E8B64912414C5C6AF6F585124CDC7CD6C8AAB6C91615A26506EC856AD36147CE57D56E9046D36279E55727EED2FAD7EF08B82ADF364FF5FED99C6C5444AFE5B572208D22C9F2DED5EFD171B4E40B52A46F5D20FA79B17930203010001";
    private static final String rsa_1_pr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
    private static final KeyPair rsa_1;
    private static final SecretKey bf_1;
    public static final char[] HEX;

    public static String cipher(String string, boolean mode) {
        if (mode) {
            if (bf_1 != null) {
                try {
                    Cipher cipher = Cipher.getInstance("Blowfish/ECB/NoPadding");
                    cipher.init(2, bf_1);
                    byte[] b = cipher.doFinal(BGClientRunnerCipher.fromHex(string));
                    return new String(b, "UTF-8");
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            if (rsa_1 != null) {
                try {
                    Cipher cipher = Cipher.getInstance("RSA");
                    cipher.init(2, rsa_1.getPrivate());
                    byte[] b = cipher.doFinal(BGClientRunnerCipher.fromHex(string));
                    return new String(b, "UTF-8");
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        } else {
            if (bf_1 != null) {
                try {
                    Cipher cipher = Cipher.getInstance("Blowfish/ECB/NoPadding");
                    cipher.init(1, bf_1);
                    byte[] b = cipher.doFinal(string.getBytes("UTF-8"));
                    return BGClientRunnerCipher.toHex(b);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            if (rsa_1 != null) {
                try {
                    Cipher cipher = Cipher.getInstance("RSA");
                    cipher.init(1, rsa_1.getPublic());
                    byte[] b = cipher.doFinal(string.getBytes("UTF-8"));
                    return BGClientRunnerCipher.toHex(b);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static String toHex(byte[] bytes) {
        StringBuilder hex = new StringBuilder();
        if (bytes != null) {
            for (int j = 0; j < bytes.length; ++j) {
                hex.append(HEX[bytes[j] & 0xF]);
                hex.append(HEX[(bytes[j] & 0xF0) >> 4]);
            }
        }
        return hex.toString();
    }

    public static byte[] fromHex(String s) {
        int len = ((String)s).length();
        if (len != len / 2 * 2) {
            ++len;
            s = "0" + (String)s;
        }
        byte[] result = new byte[len / 2];
        for (int i = 0; i < result.length; ++i) {
            int pos = i * 2;
            char c2 = ((String)s).charAt(pos);
            char c1 = ((String)s).charAt(pos + 1);
            result[i] = (byte)(BGClientRunnerCipher.toInt(c1) * 16 + BGClientRunnerCipher.toInt(c2));
        }
        return result;
    }

    private static int toInt(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return c - 48;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return c - 97 + 10;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return c - 65 + 10;
            }
        }
        return -1;
    }

    static {
        bf_1 = null;
        KeyPair kp = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(new BigInteger(rsa_1_pb, 16).toByteArray());
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(new BigInteger(rsa_1_pr, 16).toByteArray());
            PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
            kp = new KeyPair(publicKey, privateKey);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        rsa_1 = kp;
        HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

