/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.server;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.CostMap;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.CostMapItem;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.GeographicCode;
import ru.bitel.bgbilling.kernel.base.phone.server.bean.CostMapManager;
import ru.bitel.bgbilling.kernel.base.phone.server.bean.GeographicCodeManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;

public class CostMapCache {
    private static Logger logger = LogManager.getLogger();
    private static Map<Integer, Future<CostMapCacheItem>> futures = new HashMap<Integer, Future<CostMapCacheItem>>();
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final ConcurrentHashMap<Integer, SoftReference<CostMapCacheItem>> cache = new ConcurrentHashMap();
    private final Map<Integer, CostMapItem> costMaps = new HashMap<Integer, CostMapItem>();
    private final GeographicCode geographicCode;

    public static synchronized CostMapCache getInstance(Connection con, int mid) throws BGException {
        SoftReference<CostMapCacheItem> ref;
        Future<CostMapCacheItem> future = futures.get(mid);
        if (future != null && future.isDone()) {
            try {
                logger.debug("Reloading costMap is done..");
                CostMapCacheItem newItem = future.get();
                cache.remove(mid);
                cache.put(mid, new SoftReference<CostMapCacheItem>(newItem));
                futures.put(mid, null);
                logger.info("Finish Reloading costMap cache and geo codes for mid " + mid);
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                futures.put(mid, null);
            }
        }
        CostMapCacheItem item = (ref = cache.get(mid)) != null ? ref.get() : null;
        Calendar dbModTime = ServerUtils.getLastModificationTime((Connection)con, (String)("zone_map_" + mid));
        if (item != null && (dbModTime == null || dbModTime.getTimeInMillis() == item.lastModified)) {
            return item.cache;
        }
        if (item == null) {
            logger.info("First loading costMap cache and geo codes for mid " + mid);
            item = new CostMapCacheItem(new CostMapCache(con, mid), dbModTime != null ? dbModTime.getTimeInMillis() : 0L);
            cache.put(mid, new SoftReference<CostMapCacheItem>(item));
            return item.cache;
        }
        if (futures.get(mid) == null) {
            logger.info("Start Reloading costMap cache and geo codes for mid " + mid);
            futures.put(mid, executor.submit(() -> {
                CostMapCacheItem result;
                Connection conSync = Setup.getSetup().getDBConnectionFromPool();
                try {
                    result = new CostMapCacheItem(new CostMapCache(conSync, mid), dbModTime != null ? dbModTime.getTimeInMillis() : 0L);
                }
                finally {
                    ServerUtils.closeConnection((Connection)conSync);
                }
                return result;
            }));
            logger.debug("Start Reloading costMap cache and geo codes for mid " + mid + "..Ok");
        }
        return item.cache;
    }

    private CostMapCache(Connection con, int mid) throws BGException {
        try (CostMapManager cmm = new CostMapManager(con, mid);){
            for (CostMap map : cmm.list()) {
                this.costMaps.put(map.getId(), cmm.getTree(map.getId(), false));
            }
        }
        GeographicCodeManager gcm = new GeographicCodeManager(con, mid);
        this.geographicCode = gcm.getTree(false);
    }

    public CostMapItem getTree(int costMapId) throws BGException {
        return this.costMaps.get(costMapId);
    }

    public void deleteTreeFromCache(int costMapId) {
        this.costMaps.remove(costMapId);
    }

    public GeographicCode getGeographicCode() {
        return this.geographicCode;
    }

    private static class CostMapCacheItem {
        final CostMapCache cache;
        final long lastModified;

        public CostMapCacheItem(CostMapCache cache, long lastModified) {
            this.cache = cache;
            this.lastModified = lastModified;
        }
    }
}

