/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.client.RightRulePanel;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.GroupRight;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserRightService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.treetable.BGTreeTableModel;

public class RightManagerPanel
extends BGUPanel {
    private BGUTreeTable groupTreeTable;
    private RightRulePanel rightRulePanel;
    private GroupRightTreeTableModel groupTreeTableModel;
    private UserRightService userRightService;

    @Override
    protected void jbInit() throws Exception {
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, this.getGroupPanel(), (Component)this.getRightPanel(), 400L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel getGroupPanel() {
        this.groupTreeTable = new BGUTreeTable(this.getGroupRightTreeTableModel());
        this.groupTreeTable.setSelectionMode(0);
        this.groupTreeTable.getSelectionModel().addListSelectionListener(e -> {
            GroupRight groupRight;
            if (!e.getValueIsAdjusting() && (groupRight = (GroupRight)this.getGroupRightTreeTableModel().getSelectedRow()) != null) {
                this.rightRulePanel.setGroupRight(groupRight);
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(this.groupTreeTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getRightPanel() {
        if (this.rightRulePanel == null) {
            this.rightRulePanel = new RightRulePanel();
        }
        return this.rightRulePanel;
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                RightManagerPanel.this.getGroupRightTreeTableModel().setData(RightManagerPanel.this.getUserRightService().groupRightTree());
                RightManagerPanel.this.groupTreeTable.expandAfterUpdate();
            }
        };
        new AbstractBGUPanel.DefaultAction("new", "\u041d\u043e\u0432\u043e\u0435"){

            @Override
            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                GroupRight groupRight = (GroupRight)RightManagerPanel.this.getGroupRightTreeTableModel().getSelectedRow();
                if (groupRight != null && groupRight.getId() > 0) {
                    RightManagerPanel.this.rightRulePanel.performAction("new");
                } else {
                    ClientUtils.showMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0433\u0440\u0443\u043f\u043f\u0443");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                RightManagerPanel.this.rightRulePanel.performAction("edit");
            }
        };
    }

    private GroupRightTreeTableModel getGroupRightTreeTableModel() {
        if (this.groupTreeTableModel == null) {
            this.groupTreeTableModel = new GroupRightTreeTableModel(GroupRightTreeTableModel.class.getName());
        }
        return this.groupTreeTableModel;
    }

    private UserRightService getUserRightService() {
        if (this.userRightService == null) {
            this.userRightService = ((ClientContext)this.getContext()).getPort(UserRightService.class);
        }
        return this.userRightService;
    }

    class GroupRightTreeTableModel
    extends BGTreeTableModel<GroupRight> {
        public GroupRightTreeTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b", GroupRight.class, 100, 200, -1, "title", false);
            this.addColumn("\u0422\u0438\u043f", 60, 60, 60, "type", false, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumnId();
        }

        @Override
        public Object getValue(GroupRight groupRight, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("title".equals(identifier)) {
                return groupRight.getTitle() + (String)(groupRight.getParentId() == 0 && groupRight.getModuleId() != 0 ? " [" + groupRight.getModule() + "#" + groupRight.getModuleId() + "]" : "");
            }
            return super.getValue(groupRight, column);
        }

        @Override
        public Icon getIcon(GroupRight value) {
            return ClientUtils.getIcon("node");
        }
    }
}

