/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.basic.server.action.web;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractStatus;
import bitel.billing.server.contract.bean.ContractStatusManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.contract.status.server.WebStatusChangeRules;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.GetContractStatusChangeDatesEvent;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.TimeUtils;

public class ActionStatus
extends AbstractAction {
    private String moduleName = "contract";
    private ContractStatusManager statusManager = null;
    private static final int CANCHANGE_DISABLED = 1;
    private static final int CANCHANGE_DISABLED_BADSTATUS = 2;
    private static final int CANCHANGE_DO = 3;
    private static final int CANCHANGE_CANCEL_ALLOW = 4;
    private static final int CANCHANGE_CANCEL_DENY = 5;

    @Override
    public void execute() throws BGException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void status() throws BGException {
        Date curdate = new Date();
        try (ContractManager contractManager = new ContractManager(this.con);){
            int statusint;
            block31: {
                Calendar changeTo;
                Calendar changeFrom;
                List<Date> changeDateToList;
                List<Date> changeDateFromList;
                Object dateListEvent;
                Contract contract = contractManager.getContractById(this.contractId);
                statusint = contract.getStatus();
                WebStatusChangeRules changeRules = StatusCache.getInstance().getWebStatusChangeRules();
                Set<Integer> changeableStatusSet = changeRules.getChangeableStatusIds();
                String command = this.context.getRequest().getParameter("command");
                if ("Change".equals(command)) {
                    dateListEvent = new GetContractStatusChangeDatesEvent(this.userId, this.contractId, statusint, curdate);
                    dateListEvent = EventProcessor.getInstance().request(dateListEvent);
                    changeDateFromList = ((GetContractStatusChangeDatesEvent)dateListEvent).getDateList();
                    changeDateToList = ((GetContractStatusChangeDatesEvent)dateListEvent).getDateToList();
                    changeFrom = TimeUtils.convertDateToCalendar(changeRules.getFromStatusChangeDate(statusint));
                    changeTo = changeFrom != null ? TimeUtils.plusPeriod(changeFrom, 2, 1) : null;
                    changeDateFromList = this.checkDateList(changeDateFromList, changeFrom, "fromDates");
                    changeDateToList = this.checkDateList(changeDateToList, changeTo, "toDates");
                    this.actionContractStatusChangeDoAction(contract, changeRules, TimeUtils.convertCalendarToDate(changeFrom), changeDateFromList, changeDateToList);
                } else if ("Cancel".equals(command)) {
                    this.actionContractStatusCancelAction(contract, curdate, changeRules, changeableStatusSet);
                }
                Boolean canCancel = null;
                try {
                    for (ContractStatus status : this.getContractStatusManager().getStatusList(this.contractId)) {
                        if (!TimeUtils.dateBefore(curdate, status.getDateFrom()) || canCancel == Boolean.FALSE) continue;
                        canCancel = changeableStatusSet.contains(status.getStatus());
                    }
                }
                catch (Exception ex) {
                    this.context.getRequest().setAttribute("error", (Object)ex.getLocalizedMessage());
                }
                contract = contractManager.getContractById(this.contractId);
                statusint = contract.getStatus();
                dateListEvent = new GetContractStatusChangeDatesEvent(this.userId, this.contractId, statusint, curdate);
                dateListEvent = (GetContractStatusChangeDatesEvent)EventProcessor.getInstance().request(dateListEvent);
                changeDateFromList = ((GetContractStatusChangeDatesEvent)dateListEvent).getDateList();
                changeDateToList = ((GetContractStatusChangeDatesEvent)dateListEvent).getDateToList();
                changeFrom = TimeUtils.convertDateToCalendar(changeRules.getFromStatusChangeDate(statusint));
                changeTo = changeFrom != null ? TimeUtils.plusPeriod(changeFrom, 2, 1) : null;
                changeDateFromList = this.checkDateList(changeDateFromList, changeFrom, "fromDates");
                changeDateToList = this.checkDateList(changeDateToList, changeTo, "toDates");
                int canchange = 3;
                if (changeDateFromList != null && changeDateFromList.isEmpty()) {
                    canchange = 1;
                }
                if (canchange == 3 && !changeableStatusSet.contains(statusint)) {
                    canchange = 2;
                }
                if (canchange == 3 && canCancel != null) {
                    canchange = canCancel != false ? 4 : 5;
                }
                this.context.getRequest().setAttribute("canchange", (Object)String.valueOf(canchange));
                break block31;
                catch (Exception ex) {
                    this.context.getRequest().setAttribute("error", (Object)ex.getLocalizedMessage());
                    canCancel = null;
                    try {
                        for (ContractStatus status : this.getContractStatusManager().getStatusList(this.contractId)) {
                            if (!TimeUtils.dateBefore(curdate, status.getDateFrom()) || canCancel == Boolean.FALSE) continue;
                            canCancel = changeableStatusSet.contains(status.getStatus());
                        }
                    }
                    catch (Exception ex2) {
                        this.context.getRequest().setAttribute("error", (Object)ex2.getLocalizedMessage());
                    }
                    contract = contractManager.getContractById(this.contractId);
                    statusint = contract.getStatus();
                    dateListEvent = new GetContractStatusChangeDatesEvent(this.userId, this.contractId, statusint, curdate);
                    dateListEvent = (GetContractStatusChangeDatesEvent)EventProcessor.getInstance().request(dateListEvent);
                    changeDateFromList = ((GetContractStatusChangeDatesEvent)dateListEvent).getDateList();
                    changeDateToList = ((GetContractStatusChangeDatesEvent)dateListEvent).getDateToList();
                    changeFrom = TimeUtils.convertDateToCalendar(changeRules.getFromStatusChangeDate(statusint));
                    changeTo = changeFrom != null ? TimeUtils.plusPeriod(changeFrom, 2, 1) : null;
                    changeDateFromList = this.checkDateList(changeDateFromList, changeFrom, "fromDates");
                    changeDateToList = this.checkDateList(changeDateToList, changeTo, "toDates");
                    canchange = 3;
                    if (changeDateFromList != null && changeDateFromList.isEmpty()) {
                        canchange = 1;
                    }
                    if (canchange == 3 && !changeableStatusSet.contains(statusint)) {
                        canchange = 2;
                    }
                    if (canchange == 3 && canCancel != null) {
                        canchange = canCancel != false ? 4 : 5;
                    }
                    this.context.getRequest().setAttribute("canchange", (Object)String.valueOf(canchange));
                    catch (Throwable throwable) {
                        Boolean canCancel2 = null;
                        try {
                            for (ContractStatus status : this.getContractStatusManager().getStatusList(this.contractId)) {
                                if (!TimeUtils.dateBefore(curdate, status.getDateFrom()) || canCancel2 == Boolean.FALSE) continue;
                                canCancel2 = changeableStatusSet.contains(status.getStatus());
                            }
                        }
                        catch (Exception ex3) {
                            this.context.getRequest().setAttribute("error", (Object)ex3.getLocalizedMessage());
                        }
                        contract = contractManager.getContractById(this.contractId);
                        statusint = contract.getStatus();
                        GetContractStatusChangeDatesEvent dateListEvent2 = new GetContractStatusChangeDatesEvent(this.userId, this.contractId, statusint, curdate);
                        dateListEvent2 = EventProcessor.getInstance().request(dateListEvent2);
                        List<Date> changeDateFromList2 = dateListEvent2.getDateList();
                        List<Date> changeDateToList2 = dateListEvent2.getDateToList();
                        Calendar changeFrom2 = TimeUtils.convertDateToCalendar(changeRules.getFromStatusChangeDate(statusint));
                        Calendar changeTo2 = changeFrom2 != null ? TimeUtils.plusPeriod(changeFrom2, 2, 1) : null;
                        changeDateFromList2 = this.checkDateList(changeDateFromList2, changeFrom2, "fromDates");
                        changeDateToList2 = this.checkDateList(changeDateToList2, changeTo2, "toDates");
                        int canchange2 = 3;
                        if (changeDateFromList2 != null && changeDateFromList2.isEmpty()) {
                            canchange2 = 1;
                        }
                        if (canchange2 == 3 && !changeableStatusSet.contains(statusint)) {
                            canchange2 = 2;
                        }
                        if (canchange2 == 3 && canCancel2 != null) {
                            canchange2 = canCancel2 != false ? 4 : 5;
                        }
                        this.context.getRequest().setAttribute("canchange", (Object)String.valueOf(canchange2));
                        throw throwable;
                    }
                }
            }
            this.context.getRequest().setAttribute("statusstr", (Object)StatusCache.getInstance().getStatusTitle(statusint));
            this.context.getRequest().setAttribute("statusint", (Object)String.valueOf(statusint));
            this.context.getRequest().setAttribute("curdate", (Object)curdate);
        }
        this.requestDispatcher(this.moduleName, "status_form");
    }

    public void log() throws BGException {
        StatusCache statusCache = StatusCache.getInstance();
        HashMap statusMap = new HashMap();
        List list = this.getContractStatusManager().getStatusList(this.contractId);
        Collections.reverse(list);
        list.forEach(status -> statusMap.put(status.getStatus(), statusCache.getStatusTitle(status.getStatus())));
        this.context.getRequest().setAttribute("statuses", (Object)list);
        this.context.getRequest().setAttribute("statusMap", statusMap);
        this.requestDispatcher(this.moduleName, "status_log");
    }

    public void actionContractStatusChangeDoAction(Contract contract, WebStatusChangeRules changeRules, Date fromDate, List<Date> dateList, List<Date> dateToList) throws SQLException, BGException {
        int newStatus = this.req.getInt("status", -1);
        Date date2 = null;
        String comment = "\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c";
        Date date1 = this.req.getDate("dateFrom", null);
        date2 = this.req.getDate("dateTo", null);
        TimeUtils.checkPeriod(date1, date2);
        if (this.contractId <= 0 || newStatus < 0) {
            throw new BGIllegalArgumentException();
        }
        if (date1 == null) {
            throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0434\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u0430.");
        }
        int currentStatus = contract.getStatus();
        if (!changeRules.isStatusChangeAllow(currentStatus, newStatus)) {
            throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u0435\u0440\u0435\u0445\u043e\u0434 \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d.");
        }
        if (dateList != null && !dateList.contains(date1) || fromDate != null && !TimeUtils.dateBeforeOrEq(fromDate, date1)) {
            throw new BGMessageException("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u0441 \u0434\u0430\u043d\u043d\u043e\u0439 \u0434\u0430\u0442\u044b \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d.");
        }
        if (dateToList != null && date2 != null && !dateToList.contains(date2)) {
            throw new BGMessageException("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u0414\u041e \u0434\u0430\u043d\u043d\u043e\u0439 \u0434\u0430\u0442\u044b \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d.");
        }
        ContractStatus status = new ContractStatus();
        status.setContractId(this.contractId);
        status.setStatus(newStatus);
        status.setDateFrom(date1);
        status.setDateTo(date2);
        status.setComment(comment);
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionContractStatus", (int)this.moduleId, (int)this.userId);
        if (closedDate != null) {
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, null, null, (Date)date1, (Date)date2);
        }
        this.getContractStatusManager().changeStatus(status.clone(), Integer.valueOf(-1));
    }

    public void actionContractStatusCancelAction(Contract contract, Date curdate, WebStatusChangeRules changeRules, Set<Integer> changeableStatusSet) throws SQLException, BGException {
        boolean canCancel = false;
        for (ContractStatus status : this.getContractStatusManager().getStatusList(this.contractId)) {
            if (!TimeUtils.dateBefore(curdate, status.getDateFrom())) continue;
            if (!changeableStatusSet.contains(status.getStatus())) {
                throw new BGMessageException("\u0417\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043d\u0435\u043f\u0435\u0440\u0435\u043a\u0440\u044b\u0432\u0430\u0435\u043c\u043e\u0433\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u0430.");
            }
            canCancel = true;
        }
        if (!canCancel) {
            throw new BGMessageException("\u041d\u0435\u0447\u0435\u0433\u043e \u043e\u0442\u043c\u0435\u043d\u044f\u0442\u044c.");
        }
        int newStatus = contract.getStatus();
        Date date2 = null;
        String comment = "\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c (\u043e\u0442\u043c\u0435\u043d\u0430 \u0441\u043c\u0435\u043d\u044b \u0441\u0442\u0430\u0442\u0443\u0441\u0430)";
        ContractStatus status = new ContractStatus();
        status.setContractId(this.contractId);
        status.setStatus(newStatus);
        status.setDateFrom(curdate);
        status.setDateTo(date2);
        status.setComment(comment);
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionContractStatus", (int)this.moduleId, (int)this.userId);
        if (closedDate != null) {
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, null, null, (Date)curdate, date2);
        }
        this.getContractStatusManager().changeStatus(status.clone(), Integer.valueOf(-1));
    }

    private void clearDates(List<Date> dates) {
        if (dates != null) {
            ArrayList list = new ArrayList();
            dates.forEach(date -> list.add(TimeUtils.clear_HOUR_MIN_MIL_SEC(date)));
            dates.clear();
            dates.addAll(list);
        }
    }

    private List<Date> checkDateList(List<Date> dates, Calendar date, String key) {
        this.clearDates(dates);
        if (dates != null) {
            if (!dates.isEmpty()) {
                this.context.getRequest().setAttribute(key, dates);
            }
        } else if (date != null) {
            Calendar cal = (Calendar)date.clone();
            TimeUtils.clear_HOUR_MIN_MIL_SEC(cal);
            dates = new ArrayList<Date>();
            for (int i = 0; i < 30; ++i) {
                dates.add(cal.getTime());
                cal.add(5, 1);
            }
            this.context.getRequest().setAttribute(key, dates);
        }
        return dates;
    }

    private ContractStatusManager getContractStatusManager() {
        if (this.statusManager == null) {
            this.statusManager = new ContractStatusManager(this.con);
        }
        return this.statusManager;
    }
}

