/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.pattern.client;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.RadioButtonTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternBaseTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.table.PatternTable;
import ru.bitel.bgbilling.kernel.contract.pattern.client.table.PatternTableModelItem;
import ru.bitel.bgbilling.kernel.contract.pattern.common.bean.RowData;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroup;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class PatternTariffTabPanel
extends PatternBaseTabPanel {
    private static final String TARIFF_GROUPS = "tariff_groups";
    private static final String TARIFF = "tariff";
    private TariffService tariffService = null;
    private TariffModel tariffTableModel = new TariffModel(TariffModel.class.getName());
    private BGUTable tariffTable = new BGUTable(this.tariffTableModel);
    private TariffGroupModel tariffGroupTableModel = new TariffGroupModel(TariffGroupModel.class.getName());
    private PatternTable tariffGroupTable = new PatternTable(this.tariffGroupTableModel);

    public PatternTariffTabPanel(Document moduleDoc) {
        int gridy = 0;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getTariffGroupPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getTariffPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private TariffService getTariffService() {
        if (this.tariffService == null) {
            this.tariffService = this.getContext().getPort(TariffService.class);
        }
        return this.tariffService;
    }

    private JPanel getTariffGroupPanel() {
        this.setMouseListener(this.tariffGroupTable, 0);
        Dimension dimension = new Dimension(500, 200);
        JScrollPane scrollPane = new JScrollPane(this.tariffGroupTable);
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0413\u0440\u0443\u043f\u043f\u0430 \u0442\u0430\u0440\u0438\u0444\u043e\u0432 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getTariffPanel() {
        this.tariffTable.setSelectionMode(0);
        AbstractAction newAction = new AbstractAction("new", ClientUtils.getIcon("item_add")){

            @Override
            public void actionPerformed(ActionEvent e) {
                RowData rowData = new RowData();
                rowData.setPosition("0");
                rowData.setGroupId(-1);
                PatternTariffTabPanel.this.getTariffDialog("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u0430", rowData).setVisible(true);
            }
        };
        AbstractAction editAction = new AbstractAction("edit", ClientUtils.getIcon("item_edit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                RowData rowData = (RowData)PatternTariffTabPanel.this.tariffTableModel.getSelectedRow();
                if (rowData != null) {
                    PatternTariffTabPanel.this.getTariffDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u0430", rowData).setVisible(true);
                }
            }
        };
        AbstractAction deleteAction = new AbstractAction("delete", ClientUtils.getIcon("item_delete")){

            @Override
            public void actionPerformed(ActionEvent e) {
                RowData rowData = (RowData)PatternTariffTabPanel.this.tariffTableModel.getSelectedRow();
                if (rowData != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u0438\u0441\u0438?") == 0) {
                    PatternTariffTabPanel.this.tariffTableModel.deleteRow(rowData);
                }
            }
        };
        BGDialogToolBar tariffToolBar = new BGDialogToolBar();
        tariffToolBar.add(newAction);
        tariffToolBar.add(editAction);
        tariffToolBar.add(deleteAction);
        tariffToolBar.compact();
        this.setMouseListener(this.tariffTable, 0);
        int gridx = 0;
        JPanel topPanle = new JPanel(new GridBagLayout());
        topPanle.add((Component)new JLabel("\u0422\u0430\u0440\u0438\u0444\u044b:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        topPanle.add((Component)tariffToolBar, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)topPanle, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane(this.tariffTable), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, -114, 0, 0), 0, 0));
        return panel;
    }

    @Override
    public void setData(Document doc) {
        ArrayList<PatternTableModelItem> tariffGroupRowData = new ArrayList<PatternTableModelItem>();
        for (Element element : XMLUtils.selectElements(doc, "//tariff_groups/data/row")) {
            PatternTableModelItem item = new PatternTableModelItem();
            item.setId(Utils.parseInt(element.getAttribute("id")));
            item.setTitle(element.getAttribute("title"));
            tariffGroupRowData.add(item);
        }
        this.tariffGroupTableModel.setData(tariffGroupRowData);
    }

    @Override
    public void setPatternData(Element pattern) {
        ArrayList<RowData> currentRariffRowData = new ArrayList<RowData>();
        try {
            Directory<TariffPlan> tariffPalnDirectory = this.getContext().getDirectory(TariffPlan.class);
            for (String tariff : Utils.toList(pattern.getAttribute(TARIFF))) {
                String[] aa = tariff.split(":");
                int tariffId = Utils.parseInt(aa[0]);
                TariffPlan tariffPlan = tariffPalnDirectory.get(tariffId);
                if (tariffPlan == null) continue;
                int position = 0;
                int groupId = -1;
                if (aa.length > 1) {
                    position = Utils.parseInt(aa[1]);
                }
                if (aa.length > 2) {
                    groupId = Utils.parseInt(aa[2]);
                }
                RowData rowData = new RowData();
                rowData.setId(tariffId);
                rowData.setGroupId(groupId);
                rowData.setPosition(String.valueOf(position));
                rowData.setTitle(tariffPlan.getTitle());
                currentRariffRowData.add(rowData);
            }
        }
        catch (Exception e2) {
            ClientUtils.showErrorMessageDialog(e2);
        }
        this.tariffTableModel.setData(currentRariffRowData);
        List<Integer> tariffGroupList = Utils.toIntegerList(pattern.getAttribute("tariff_group"));
        int tarifGroupId = tariffGroupList.size() > 0 ? tariffGroupList.get(0) : 0;
        this.tariffGroupTableModel.getRows().stream().forEach(e -> e.setSelected(e.getId() == tarifGroupId));
    }

    @Override
    public void resetData() {
        this.tariffTableModel.deleteRows();
        this.tariffGroupTableModel.getRows().stream().forEach(e -> e.setSelected(e.getId() == 0));
    }

    @Override
    public boolean setRequestData(Request request) {
        ArrayList tariffPlans = new ArrayList();
        this.tariffTableModel.getRows().stream().forEach(rowData -> {
            Object tpid = String.valueOf(rowData.getId());
            tpid = (String)tpid + ":" + Utils.parseInt(rowData.getPosition());
            tpid = (String)tpid + ":" + rowData.getGroupId();
            tariffPlans.add(tpid);
        });
        request.setAttribute(TARIFF, Utils.toString(tariffPlans));
        request.setAttribute("tgid", Utils.toString(this.tariffGroupTableModel.getRows().stream().filter(e -> e.isSelected()).map(t -> t.getId()).collect(Collectors.toList())));
        return true;
    }

    private JDialog getTariffDialog(String title, RowData rowData) {
        JList<IdTitle> tariffs = new JList<IdTitle>();
        tariffs.setSelectionMode(0);
        JTextField position = new JTextField(5);
        position.setHorizontalAlignment(0);
        BGComboBox tariffGroup = new BGComboBox();
        JScrollPane scrollPane = new JScrollPane(tariffs);
        scrollPane.setMinimumSize(new Dimension(500, 250));
        scrollPane.setPreferredSize(new Dimension(500, 250));
        int gridx = 0;
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        bottomPanel.add((Component)new JLabel("\u0413\u0440\u0443\u043f\u043f\u0430 \u0442\u0430\u0440\u0438\u0444\u043e\u0432:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        bottomPanel.add(tariffGroup, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        bottomPanel.add((Component)new JLabel("\u041f\u043e\u0437\u0438\u0446\u0438\u044f:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        bottomPanel.add((Component)position, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0422\u0430\u0440\u0438\u0444:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 13, 1, new Insets(3, 0, 0, 0), 0, 0));
        panel.add((Component)bottomPanel, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 13, 1, new Insets(3, 0, 0, 0), 0, 0));
        ArrayList tariffData = new ArrayList();
        try {
            this.getTariffService().tariffPlanList(new ArrayList<Integer>(), null, null).stream().forEach(g -> tariffData.add(new IdTitle(g.getId(), g.getTitle())));
            tariffs.setListData(tariffData.toArray(new IdTitle[0]));
            DefaultComboBoxModel<IdTitle> tariffGroupModel = new DefaultComboBoxModel<IdTitle>();
            tariffGroupModel.addElement(new IdTitle(-1, "\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e"));
            tariffGroupModel.addElement(new IdTitle(0, "<\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430>"));
            this.getTariffService().tariffGroupList().forEach(g -> tariffGroupModel.addElement(new IdTitle(g.getId(), g.getTitle())));
            tariffGroup.setModel(tariffGroupModel);
        }
        catch (Exception e2) {
            ClientUtils.showErrorMessageDialog(e2);
        }
        for (IdTitle idTitle : tariffData) {
            if (idTitle.getId() != rowData.getId()) continue;
            tariffs.setSelectedValue(idTitle, true);
            break;
        }
        for (int index = 0; index < tariffGroup.getItemCount(); ++index) {
            if (((IdTitle)tariffGroup.getItemAt(index)).getId() != rowData.getGroupId()) continue;
            tariffGroup.setSelectedIndex(index);
            break;
        }
        position.setText(String.valueOf(rowData.getPosition()));
        BGOptionPane optionPane = new BGOptionPane((Object)panel, title);
        JDialog dialog = optionPane.getDialog();
        ((JButton)optionPane.getOptions()[0]).addActionListener(e -> {
            try {
                IdTitle idTitle = (IdTitle)tariffs.getSelectedValue();
                if (idTitle == null) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \"\u0422\u0430\u0440\u0438\u0444\"!");
                    return;
                }
                if (rowData.getId() == 0) {
                    this.tariffTableModel.addRow(rowData);
                }
                rowData.setId(idTitle.getId());
                rowData.setTitle(idTitle.getTitle());
                rowData.setGroupId(((IdTitle)tariffGroup.getSelectedItem()).getId());
                rowData.setPosition(String.valueOf(Utils.parseInt(position.getText())));
                rowData.setValue(Boolean.TRUE);
                this.tariffTable.revalidate();
                this.tariffTable.repaint();
                dialog.setVisible(false);
                dialog.dispose();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        });
        return dialog;
    }

    class TariffModel
    extends BGTableModel<RowData> {
        private Directory<TariffGroup> tariffGroupDirectory;

        public TariffModel(String name) {
            super(name);
            this.tariffGroupDirectory = null;
            try {
                this.tariffGroupDirectory = PatternTariffTabPanel.this.getContext().getDirectory(TariffGroup.class);
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog(e);
            }
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u043e\u0437\u0438\u0446\u0438\u044f", 90, 90, 90, "position", true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u0430", -1, -1, -1, "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0422\u0430\u0440\u0438\u0444\u043d\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430", -1, -1, -1, "groupId", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValueAt(RowData rowData, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("groupId".equals(identifier)) {
                int groupId = rowData.getGroupId();
                if (groupId == -1) {
                    return "\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e";
                }
                if (groupId == 0) {
                    return "<\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430>";
                }
                TariffGroup tariffGroup = this.tariffGroupDirectory.get(groupId);
                return tariffGroup != null ? tariffGroup.getTitle() : "<\u0433\u0440\u0443\u043f\u043f\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 #" + groupId + ">";
            }
            return super.getValueAt(rowData, column);
        }
    }

    class TariffGroupModel
    extends BGTableModel<PatternTableModelItem> {
        public TariffGroupModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("V", 50, 50, 50, "selected").setTableCellRenderer(new RadioButtonTableCellRenderer());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title").setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }
}

