/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.pattern.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.admin.webmenu.common.bean.WebMenuItem;
import ru.bitel.bgbilling.kernel.admin.webmenu.common.service.WebMenuService;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternBaseTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.table.PatternTable;
import ru.bitel.bgbilling.kernel.contract.pattern.client.table.PatternTableModel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.table.PatternTableModelItem;

public class PatternWebMenuTabPanel
extends PatternBaseTabPanel {
    private int webMenuId = -1;
    private PatternTable table = null;
    private PatternTableModel model = null;

    public PatternWebMenuTabPanel(Document moduleDoc) {
    }

    @Override
    public void initUI() {
        if (!this.uiInited) {
            this.model = new PatternTableModel(PatternWebMenuTabPanel.class.getName());
            this.table = new PatternTable(this.model);
            this.setLayout(new GridBagLayout());
            this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            PatternTableModelItem defaultWebMenuItem = new PatternTableModelItem();
            defaultWebMenuItem.setId(-1);
            defaultWebMenuItem.setSelected(-1 == this.webMenuId);
            defaultWebMenuItem.setTitle("\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
            try {
                ArrayList<PatternTableModelItem> list = new ArrayList<PatternTableModelItem>();
                for (WebMenuItem webMenuItem : this.getContext().getPort(WebMenuService.class).webMenuList(false)) {
                    PatternTableModelItem item = new PatternTableModelItem(webMenuItem);
                    item.setSelected(webMenuItem.getId() == this.webMenuId);
                    list.add(item);
                }
                list.add(0, defaultWebMenuItem);
                this.model.setData(list);
            }
            catch (BGException e) {
                e.printStackTrace();
            }
            this.uiInited = true;
        }
    }

    @Override
    public void setPatternData(Element pattern) {
        this.webMenuId = this.getIntValue(pattern, "webMenuId", -1);
        if (this.table != null) {
            this.table.setSelected(this.webMenuId);
            if (!this.table.setSelected()) {
                this.resetData();
            }
        }
    }

    @Override
    public void resetData() {
        this.webMenuId = -1;
        if (this.table != null) {
            this.table.setSelected();
        }
    }

    @Override
    public boolean setRequestData(Request request) {
        request.setAttribute("web_menu_id", this.table != null ? this.table.getSelectedId() : this.webMenuId);
        return true;
    }
}

