/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.directory.api.client;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.ws.common.WSLinkedClient;
import ru.bitel.bgbilling.kernel.directory.api.client.ClientDirectoryInfo;
import ru.bitel.bgbilling.kernel.directory.api.common.CachedDirectory;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.common.model.Id;

class ClientDirectoryView<K extends Id>
implements Directory<K> {
    private final Directory<K> service;
    private final CachedDirectory<K> cache;

    public ClientDirectoryView(WSLinkedClient context, ClientDirectoryInfo<K> info, int moduleId, Directory<K> service, boolean cached) throws BGException {
        this.service = service;
        this.cache = cached ? info.getCache(context, moduleId) : new CachedDirectory(new AtomicLong());
    }

    @Override
    public K get(int id) throws BGException {
        return this.cache.get(this.service, id);
    }

    @Override
    public K get(String title) throws BGException {
        return this.cache.get(this.service, title);
    }

    @Override
    public List<K> list() throws BGException {
        return this.cache.list(this.service);
    }

    @Override
    public void update(K k) throws BGException {
        this.cache.update(this.service, k);
    }

    @Override
    public int delete(int id) throws BGException {
        return this.cache.delete(this.service, id);
    }
}

