/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.module.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class UserManager
extends AbstractIdDao<User> {
    public UserManager(Connection con) {
        super(Objects.requireNonNull(con, "'con' must be not null"), 0, "user");
    }

    @Override
    protected void updateImpl(User user) throws BGException, SQLException {
        try {
            String query = null;
            PreparedStatement ps = null;
            String querySet = " SET login=?, name=?, email=?, descr=?, pswd=?, status=?, cgr=?, cgr_mode=?, pids=?, opids=?, contract_pid=?, contract_cid=?, config=?, domainIds=?, personal_action=?, menu_id=?";
            if (user.getId() > 0 || user.getId() == -1) {
                query = "UPDATE " + this.tableName + querySet + " WHERE id=?";
                ps = this.con.prepareStatement(query);
            } else {
                query = "INSERT INTO " + this.tableName + querySet + ", dt=now()";
                ps = this.con.prepareStatement(query, 1);
            }
            Object config = Utils.maskNull(user.getConfig());
            config = ((String)config).replace("need.change.password=true", "").replace("need.change.password=false", "");
            if (user.isNeedChangePassword()) {
                config = (String)config + "\nneed.change.password=true";
            }
            user.setConfig(((String)config).replaceAll("\\n{2,}", "\n"));
            int index = 1;
            ps.setString(index++, user.getLogin());
            ps.setString(index++, user.getName());
            ps.setString(index++, user.getEmail());
            ps.setString(index++, user.getDescription());
            ps.setString(index++, user.getPassword());
            ps.setInt(index++, user.getStatus());
            ps.setLong(index++, user.getContractGroups());
            ps.setInt(index++, user.getContractGroupsMode());
            ps.setString(index++, Utils.toString(user.getRuleAccessContractParameter()));
            ps.setString(index++, Utils.toString(user.getRuleAccessObjectParameter()));
            ps.setInt(index++, user.getContractPid());
            ps.setInt(index++, user.getContractCid());
            ps.setString(index++, user.getConfig());
            ps.setString(index++, Utils.toString(user.getDomainIds()));
            ps.setInt(index++, user.getPersonalAction());
            ps.setInt(index++, user.getMenuId());
            if (user.getId() > 0 || user.getId() == -1) {
                ps.setInt(index++, user.getId());
            }
            ps.executeUpdate();
            if (user.getId() <= 0 && user.getId() != -1) {
                user.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    @Override
    protected User getFromRS(ResultSet rs) throws SQLException, BGException {
        ResultSetMetaData resultSetMetaData = rs.getMetaData();
        Pattern pattern = Pattern.compile("^\\d+$");
        List<String> pids = Utils.toList(rs.getString("pids"));
        for (int index = 0; index < pids.size(); ++index) {
            if (!pattern.matcher(pids.get(index)).matches()) continue;
            pids.set(index, pids.get(index).concat("C"));
        }
        User user = new User();
        user.setId(rs.getInt("id"));
        user.setLogin(rs.getString("login"));
        user.setName(rs.getString("name"));
        user.setEmail(rs.getString("email"));
        user.setDescription(rs.getString("descr"));
        user.setPassword(rs.getString("pswd"));
        user.setStatus(rs.getInt("status"));
        user.setContractGroups(rs.getLong("cgr"));
        user.setContractGroupsMode(rs.getInt("cgr_mode"));
        user.setRuleAccessObjectParameter(Utils.toList(rs.getString("opids")));
        user.setRuleAccessContractParameter(pids);
        user.setDate(TimeUtils.convertTimestampToCalendar(rs.getTimestamp("dt")));
        user.setContractPid(rs.getInt("contract_pid"));
        user.setContractCid(rs.getInt("contract_cid"));
        user.setTitle(user.getLogin() + " [ " + user.getName() + " ]");
        user.setConfig(rs.getString("config"));
        user.setDomainIds(Utils.toIntegerSet(rs.getString("domainIds")));
        user.setPersonalAction(rs.getInt("personal_action"));
        user.setNeedChangePassword(user.getConfig().contains("need.change.password=true"));
        for (int index = 1; index <= resultSetMetaData.getColumnCount(); ++index) {
            if (!"menu_id".equals(resultSetMetaData.getColumnName(index))) continue;
            user.setMenuId(rs.getInt("menu_id"));
            break;
        }
        return user;
    }

    public Map<Integer, User> getUsersMap() {
        HashMap<Integer, User> result = new HashMap<Integer, User>();
        try {
            String query = "SELECT * FROM " + this.tableName;
            PreparedStatement ps = this.con.prepareStatement(query);
            User user = null;
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                user = new User();
                user = this.getFromRS(rs);
                result.put(user.getId(), user);
            }
            rs.close();
            ps.close();
            user = new User();
            user.setName("\u0421\u0435\u0440\u0432\u0435\u0440");
            user.setTitle("\u0421\u0435\u0440\u0432\u0435\u0440");
            user.setId(0);
            result.put(user.getId(), user);
            user = new User();
            user.setName("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c");
            user.setTitle("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c");
            user.setId(-1);
            result.put(user.getId(), user);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void findSearchResult(SearchResult<User> searchResult) throws BGException, BGMessageException {
        if (searchResult == null) {
            return;
        }
        Page page = searchResult.getPage();
        List<User> list = searchResult.getList();
        Optional<String> filterField = Optional.ofNullable(searchResult.getAttribute("field"));
        Optional<String> filterValue = Optional.ofNullable(searchResult.getAttribute("value"));
        if (Stream.of("login", "name", "email", "descr").filter(filterField.orElse("none")::equals).count() == 0L) {
            filterField = null;
        }
        String filterStatus = searchResult.getAttribute("status");
        String groupId = searchResult.getAttribute("groupId");
        try {
            int index = 1;
            ResultSet resultSet = null;
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            query.append("SELECT SQL_CALC_FOUND_ROWS user.*, title FROM " + this.tableName + " LEFT JOIN contract ON contract.id = user.contract_cid WHERE true" + (String)(filterField != null ? " AND " + filterField.get() + " LIKE ?" : ""));
            if (filterStatus != null && !filterStatus.equals("-1")) {
                query.append(" AND user.status=?");
            }
            if (!groupId.equals("-1")) {
                query.append(" AND user.id IN (SELECT uid FROM bgs_user_group WHERE gid=?)");
            }
            query.append(" ORDER BY name");
            if (page != null && page.getPageSize() > 0) {
                query.append(" LIMIT ?, ?");
            }
            ps = this.con.prepareStatement(query.toString());
            if (filterField != null) {
                ps.setString(index++, "%" + filterValue.orElse("") + "%");
            }
            if (filterStatus != null && !filterStatus.equals("-1")) {
                ps.setInt(index++, Integer.valueOf(filterStatus));
            }
            if (!groupId.equals("-1")) {
                ps.setInt(index++, Integer.valueOf(groupId));
            }
            if (page != null && page.getPageSize() > 0) {
                ps.setInt(index++, page.getPageFirstRecordNumber());
                ps.setInt(index++, page.getPageSize());
            }
            resultSet = ps.executeQuery();
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
            while (resultSet.next()) {
                list.add(this.getFromRS(resultSet));
            }
            resultSet.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGMessageException(ex.getMessage());
        }
    }

    @Deprecated
    public boolean checkLogin(String login) {
        boolean result = true;
        try {
            String query = "SELECT COUNT(*) FROM " + this.tableName + " WHERE login=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, login);
            ResultSet rs = ps.executeQuery();
            result = !rs.next() || rs.getInt(1) <= 0;
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean checkLogin(String login, int userID) throws BGException {
        boolean result = false;
        String query = "SELECT COUNT(*) FROM " + this.tableName + " WHERE login=? AND id<>?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setString(index++, login);
            ps.setInt(index++, userID);
            ResultSet rs = ps.executeQuery();
            result = rs.next() && rs.getInt(1) > 0;
            rs.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public List<User> list() throws BGException {
        return this.list("", "name", new Object[0]);
    }

    public User getUserByLogin(String login) throws BGException {
        return (User)this.get("login=?", login);
    }
}

