/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.task.client.TaskEditor;
import ru.bitel.bgbilling.kernel.task.common.SchedulerService;
import ru.bitel.bgbilling.kernel.task.common.bean.LightweightTaskData;
import ru.bitel.bgbilling.kernel.task.common.bean.TaskStatus;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Pair;

public class SchedulerTaskPanel
extends BGUPanel {
    private static final String RUN_NOW_ACTION = "task.runnow";
    private static final String DISABLE_ENABLE_TASK_ACTION = "task.disableEnable";
    private static final long serialVersionUID = 1L;
    private TaskEditor editor;
    private BGComboBox<ComboBoxItem> filterModuleComboBox = new BGComboBox();
    private BGUTable taskTable;
    private BGTableModel<LightweightTaskData> taskTableModel;
    private JLabel statusLabel = new JLabel();
    private ComboBoxItem currentModule;
    private JPopupMenu popup = new JPopupMenu();

    public SchedulerTaskPanel(ClientContext ctx) {
        super(ctx);
    }

    @Override
    protected void jbInit() throws Exception {
        this.editor = new TaskEditor(this);
        this.editor.setVisible(false);
        this.taskTableModel = new BGTableModel<LightweightTaskData>("task"){

            @Override
            protected void initColumns() {
                this.addColumn("\u2116", -1, 35, 40, "id", true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER);
                this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0437\u0430\u0434\u0430\u0447\u0438", 150, 200, -1, "title", true);
                this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 50, 100, -1, "comment");
                this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 160, 170, 180, "periodString").setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
                this.addColumn("\u041c\u043e\u0434\u0443\u043b\u044c", -1, 150, 150, "moduleName", true);
                this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", -1, 110, 110, "taskStatus", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
                this.addColumn("\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442", -1, 120, 120, "priorityTitle").setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
                this.addColumn("\u041c\u0435\u0441\u044f\u0446\u044b", -1, -1, -1, "month");
                this.addColumn("\u0414\u043d\u0438 \u043c\u0435\u0441\u044f\u0446\u0430", -1, -1, -1, "day");
                this.addColumn("\u0414\u043d\u0438 \u043d\u0435\u0434\u0435\u043b\u0438", -1, -1, -1, "dayOfWeek");
                this.addColumn("\u0427\u0430\u0441\u044b", -1, -1, -1, "hour");
                this.addColumn("\u041c\u0438\u043d\u0443\u0442\u044b", -1, -1, -1, "min");
            }

            @Override
            public Object getValue(LightweightTaskData val, int column) throws BGException {
                Object result = "";
                switch (column) {
                    case 3: {
                        result = TimeUtils.formatPeriod(val.getPeriod());
                        break;
                    }
                    case 6: {
                        result = val.getPriority() == 0 ? "\u043c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439" : (val.getPriority() == 1 ? "\u043d\u043e\u0440\u043c\u0430\u043b\u044c\u043d\u044b\u0439" : "\u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439");
                        break;
                    }
                    case 7: {
                        result = Utils.unpackValues(val.getMonth(), 1);
                        break;
                    }
                    case 8: {
                        result = Utils.unpackValues(val.getDay(), 1);
                        break;
                    }
                    case 9: {
                        result = Utils.unpackValues(val.getDayOfWeek(), 1);
                        break;
                    }
                    case 10: {
                        result = Utils.unpackValues(val.getHour(), 0);
                        break;
                    }
                    case 11: {
                        result = Utils.unpackValues(val.getMin(), 0);
                    }
                }
                if (Utils.isEmptyString(String.valueOf(result))) {
                    result = super.getValue(val, column);
                }
                return result;
            }
        };
        this.taskTable = new BGUTable(this.taskTableModel);
        this.taskTable.setSelectionMode(2);
        JPanel filterPanel = new JPanel(new GridBagLayout());
        JPanel statusPanel = new JPanel(new GridBagLayout());
        filterPanel.setBorder(new BGTitleBorder("\u0424\u0438\u043b\u044c\u0442\u0440"));
        statusPanel.setBorder(new BGTitleBorder("\u0421\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a\u0430"));
        JMenuItem runNowItem = new JMenuItem("\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0441\u0435\u0439\u0447\u0430\u0441");
        runNowItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchedulerTaskPanel.this.performAction(SchedulerTaskPanel.RUN_NOW_ACTION);
            }
        });
        JMenuItem enableDisableItem = new JMenuItem("\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c/\u0412\u044b\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0437\u0430\u0434\u0430\u0447\u0443");
        enableDisableItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchedulerTaskPanel.this.performAction(SchedulerTaskPanel.DISABLE_ENABLE_TASK_ACTION);
            }
        });
        this.popup.add(runNowItem);
        this.popup.add(enableDisableItem);
        filterPanel.add((Component)new JLabel("\u041c\u043e\u0434\u0443\u043b\u044c: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        filterPanel.add(this.filterModuleComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        statusPanel.add((Component)this.statusLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)filterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JScrollPane(this.taskTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)statusPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.filterModuleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchedulerTaskPanel.this.performAction("refresh");
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SchedulerTaskPanel.this.performAction("refresh");
            }
        });
        this.taskTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    SchedulerTaskPanel.this.performAction("edit");
                }
                if (e.getButton() == 3) {
                    SchedulerTaskPanel.this.popup.show(SchedulerTaskPanel.this.taskTable, e.getX(), e.getY());
                }
            }
        });
        this.setData();
        this.performAction("refresh");
    }

    private void setData() throws BGException {
        List<Pair<String, String>> modulesPairs = ((ClientContext)this.getContext()).getPort(SchedulerService.class).getModuleAndPluginList();
        ComboBoxItem[] items = new ComboBoxItem[modulesPairs.size()];
        for (int i = 0; i < modulesPairs.size(); ++i) {
            Pair<String, String> current = modulesPairs.get(i);
            items[i] = "-1".equals(current.getFirst()) ? new BGComboBox.Separator(current.getSecond()) : new ComboBoxItem(current.getFirst(), current.getSecond());
        }
        this.filterModuleComboBox.setModel(new DefaultComboBoxModel<ComboBoxItem>(items));
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                SchedulerTaskPanel.this.currentModule = SchedulerTaskPanel.this.filterModuleComboBox.getSelectedItem();
                String moduleId = (String)SchedulerTaskPanel.this.currentModule.getObject();
                List<LightweightTaskData> taskList = ((ClientContext)SchedulerTaskPanel.this.getContext()).getPort(SchedulerService.class).getSchedulerTasks(moduleId);
                SchedulerTaskPanel.this.taskTableModel.setData(taskList);
                int runTaskCount = ((ClientContext)SchedulerTaskPanel.this.getContext()).getPort(SchedulerService.class).getActiveTaskCount();
                SchedulerTaskPanel.this.statusLabel.setText("\u0412 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 " + runTaskCount + " \"\u0442\u044f\u0436\u0435\u043b\u044b\u0445\" \u0437\u0430\u0434\u0430\u0447");
            }
        };
        new AbstractBGUPanel.DefaultAction("new", "\u041d\u043e\u0432\u0430\u044f \u0437\u0430\u0434\u0430\u0447\u0430"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                SchedulerTaskPanel.this.editor.setTask(null);
                SchedulerTaskPanel.this.editor.setVisible(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u0434\u0430\u0447\u0443"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                LightweightTaskData selectedItem = SchedulerTaskPanel.this.taskTableModel.getSelectedRow();
                if (selectedItem != null) {
                    SchedulerTaskPanel.this.editor.setTask(selectedItem);
                    SchedulerTaskPanel.this.editor.setVisible(true);
                } else {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0430\u0434\u0430\u0447\u0443!");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u0430\u0434\u0430\u0447\u0443"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                LightweightTaskData selectedTask = SchedulerTaskPanel.this.taskTableModel.getSelectedRow();
                if (selectedTask != null) {
                    if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u0430\u0434\u0430\u0447\u0443 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a\u0430?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", 0, 1) == 0) {
                        ((ClientContext)SchedulerTaskPanel.this.getContext()).getPort(SchedulerService.class).deleteTask(selectedTask.getId());
                        SchedulerTaskPanel.this.performAction("refresh");
                    }
                } else {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0430\u0434\u0430\u0447\u0443!");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction(RUN_NOW_ACTION, "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0441\u0435\u0439\u0447\u0430\u0441"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                LightweightTaskData selectedTask = SchedulerTaskPanel.this.taskTableModel.getSelectedRow();
                if (selectedTask != null) {
                    ((ClientContext)SchedulerTaskPanel.this.getContext()).getPort(SchedulerService.class).immediateRun(selectedTask);
                    SchedulerTaskPanel.this.performAction("refresh");
                } else {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0430\u0434\u0430\u0447\u0443!");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction(DISABLE_ENABLE_TASK_ACTION, "\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c/\u0412\u044b\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0437\u0430\u0434\u0430\u0447\u0443"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                List<LightweightTaskData> selectedTasks = SchedulerTaskPanel.this.taskTableModel.getSelectedRows();
                if (selectedTasks != null && selectedTasks.size() > 0) {
                    for (LightweightTaskData task : selectedTasks) {
                        task.setTaskStatus(task.getTaskStatus() == TaskStatus.ENABLE ? TaskStatus.DISABLE : TaskStatus.ENABLE);
                        ((ClientContext)SchedulerTaskPanel.this.getContext()).getPort(SchedulerService.class).updateTask(task);
                    }
                    SchedulerTaskPanel.this.performAction("refresh");
                } else {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0430\u0434\u0430\u0447\u0443!");
                }
            }
        };
    }
}

