/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import ru.bitel.common.client.DelegateAction;

public abstract class BGUAction
extends AbstractAction {
    public static final String NEW = "new";
    public static final String EDIT = "edit";
    public static final String DELETE = "delete";
    public static final String INIT = "init";
    public static final String REFRESH = "refresh";
    public static final String MOVE_UP = "move_up";
    public static final String MOVE_DOWN = "move_down";
    public static final String OK = "ok";
    public static final String CLOSE = "close";
    public static final String RESET = "reset";
    public static final String CANCEL = "cancel";
    public static final String IMPORT = "import";
    public static final String EXPORT = "export";
    public static final String MENU_ACTION = "Action.MenuAction";
    public static final String ACTION_EDITOR = "Action.Editor";
    public static final String ACTION_OVERRIDEN = "Action.Overriden";
    public static final String PARENT_COMPONENT = "Action.ParentComponent";

    public BGUAction(String command, String name) {
        super(name);
        this.putValue("ActionCommandKey", command);
        this.init(null, command, null);
    }

    public BGUAction(String command, String name, KeyStroke stroke) {
        super(name);
        this.putValue("ActionCommandKey", command);
        this.putValue("AcceleratorKey", stroke);
        this.init(null, command, stroke);
    }

    public BGUAction(String command, String name, Icon icon) {
        super(name, icon);
        this.putValue("ActionCommandKey", command);
        this.init(null, command, null);
    }

    public BGUAction(String command, String name, KeyStroke stroke, Icon icon) {
        super(name, icon);
        this.putValue("ActionCommandKey", command);
        this.putValue("AcceleratorKey", stroke);
        this.init(null, command, stroke);
    }

    public BGUAction(JComponent panel, String command, String name, String ... params) {
        super(name);
        this.putValue("ActionCommandKey", command);
        for (String param : params) {
            this.putValue(param, Boolean.TRUE);
        }
        this.init(panel, command, null);
    }

    public BGUAction(JComponent panel, String command, String name, KeyStroke stroke, String ... params) {
        super(name);
        this.putValue("ActionCommandKey", command);
        this.putValue("AcceleratorKey", stroke);
        for (String param : params) {
            this.putValue(param, Boolean.TRUE);
        }
        this.init(panel, command, stroke);
    }

    public BGUAction(JComponent panel, String command, String name, Icon icon, String ... params) {
        super(name, icon);
        this.putValue("ActionCommandKey", command);
        for (String param : params) {
            this.putValue(param, Boolean.TRUE);
        }
        this.init(panel, command, null);
    }

    public BGUAction(JComponent panel, String command, String name, KeyStroke stroke, Icon icon, String ... params) {
        super(name, icon);
        this.putValue("ActionCommandKey", command);
        this.putValue("AcceleratorKey", stroke);
        for (String param : params) {
            this.putValue(param, Boolean.TRUE);
        }
        this.init(panel, command, stroke);
    }

    @Override
    public void setEnabled(boolean newValue) {
        super.setEnabled(newValue);
    }

    protected void init(JComponent panel, String command, KeyStroke stroke) {
        if (panel != null) {
            Action overriden = panel.getActionMap().get(command);
            if (overriden != null) {
                this.putValue(ACTION_OVERRIDEN, overriden);
            }
            panel.getActionMap().put(command, this);
            if (stroke != null) {
                panel.getInputMap(2).put(stroke, command);
            }
        }
    }

    protected Action getParentAction(JComponent panel) {
        return panel.getActionMap().getParent().get(this.getValue("ActionCommandKey"));
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);

    public static BGUAction newAction(JComponent comp, String command, String message, final ActionListener l, String ... params) {
        return new BGUAction(comp, command, message, params){

            @Override
            public void actionPerformed(ActionEvent e) {
                l.actionPerformed(e);
            }
        };
    }

    public boolean equals(Object obj) {
        if (obj instanceof DelegateAction) {
            return super.equals(((DelegateAction)obj).getAction());
        }
        return super.equals(obj);
    }
}

