/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class ScriptDocument
extends DefaultStyledDocument {
    private static Set<CharSequence> keywords = new HashSet<CharSequence>();
    private Pattern pattern;
    private final StyleContext styleContext;
    private final List<String> customKeywords = new ArrayList<String>();

    public ScriptDocument() {
        this(new StyleContext(), Collections.emptyMap());
    }

    /*
     * WARNING - void declaration
     */
    public ScriptDocument(StyleContext styleContext, Map<String, Set<String>> keywords) {
        void var5_7;
        this.styleContext = styleContext;
        Type[] typeArray = Type.values();
        int n = typeArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            Type t = typeArray[var5_7];
            Style style = styleContext.getStyle(t.name());
            if (style == null) {
                style = styleContext.addStyle(t.name(), null);
            }
            style.setResolveParent(t.defaultStyle);
            ++var5_7;
        }
        StringBuilder sb = new StringBuilder().append("(\\n)|(\\\\)|(//)|(/\\*)|(\\*/)|(\")|(\\b\\d+\\b)");
        sb.append("|(?:\\b(");
        for (CharSequence charSequence : ScriptDocument.keywords) {
            sb.append("(?:").append(charSequence).append(")|");
        }
        sb.setLength(sb.length() - 1);
        sb.append(")\\b)");
        for (Map.Entry entry : keywords.entrySet()) {
            sb.append("|(?:\\b(");
            for (CharSequence k : (Set)entry.getValue()) {
                sb.append("(?:").append(k).append(")|");
            }
            sb.setLength(sb.length() - 1);
            sb.append(")\\b)");
            this.customKeywords.add((String)entry.getKey());
        }
        this.pattern = Pattern.compile(sb.toString());
    }

    private Type getType(int pos) {
        Object o;
        AttributeSet attrs = this.getCharacterElement(pos).getAttributes();
        Type current = Type.text;
        if (pos >= 0 && (o = attrs.getAttribute(StyleConstants.NameAttribute)) != null) {
            current = Type.valueOf((String)o);
        }
        return current;
    }

    public void onChange(int pos, int length) {
        Element para;
        int index;
        Element e = this.getDefaultRootElement();
        while (!e.isLeaf()) {
            index = e.getElementIndex(pos);
            e = e.getElement(index);
        }
        e = e.getParentElement();
        Type before = this.getType(e.getEndOffset() - 1);
        Type last = this.getType(e.getStartOffset() - 1);
        last = this.paragraphChanged(e, last);
        index = e.getParentElement().getElementIndex(pos);
        int index2 = e.getParentElement().getElementIndex(pos + length);
        if (last == Type.comment_block || before == Type.comment_block) {
            index2 = Math.max(index + 1, index2);
        }
        for (int i = index + 1; i <= index2 && (para = e.getParentElement().getElement(i)) != null; ++i) {
            before = this.getType(para.getEndOffset());
            if (((last = this.paragraphChanged(para, last)) != Type.comment_block || before == Type.comment_block) && (last == Type.comment_block || before != Type.comment_block)) continue;
            index2 = Math.max(i + 1, index2);
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        Object strN = str;
        try {
            if (str.equals("\n")) {
                String upText = super.getText(0, offs);
                Object offsetString = "";
                int ind = upText.lastIndexOf("\n");
                String origLine = ind > -1 ? upText.substring(ind + 1) : upText;
                String line = origLine.replaceAll(" ", "").replaceAll("\t", "");
                if (line.length() > 0) {
                    String ch = line.substring(0, 1);
                    ind = origLine.indexOf(ch);
                    if (ind > -1) {
                        offsetString = origLine.substring(0, ind);
                        if (ch.equals("{")) {
                            int len = super.getLength() - upText.length();
                            offsetString = (String)offsetString + "\t" + (String)(!this.doHaveCloseBracket(offs, len, (String)offsetString) ? "\n" + (String)offsetString + "}" : "");
                        }
                    }
                } else {
                    offsetString = origLine;
                }
                strN = str + (String)offsetString;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.insertString(offs, (String)strN, Type.text.getStyle(this.styleContext));
        this.onChange(offs, ((String)strN).length());
    }

    private boolean doHaveCloseBracket(int offs, int lenght, String offset) {
        try {
            String bottomText = super.getText(offs + 1, lenght);
            int fb = bottomText.indexOf("}");
            if (fb > -1) {
                String line;
                String bT = bottomText.substring(0, fb + 1);
                int ln = bT.lastIndexOf("\n");
                String string = line = ln > -1 ? bT.substring(ln + 1) : bT;
                if (!line.substring(0, 1).equals("}") && line.replaceAll(offset, "").substring(0, 1).equals("}")) {
                    return true;
                }
                ln = bottomText.indexOf("\n");
                String string2 = line = ln > -1 ? bT.substring(ln + 1) : bT;
                if (line.replaceAll(offset, "").substring(0, 1).equals("\t") && line.length() > offset.length() + 1) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        super.remove(offs, len);
        this.onChange(offs, 0);
    }

    @Override
    public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        super.replace(offset, length, text, attrs);
    }

    protected Type paragraphChanged(Element paragraphElement, Type prev) {
        try {
            int paraStart = paragraphElement.getStartOffset();
            int paraLength = paragraphElement.getEndOffset() - paraStart;
            Type current = prev;
            this.setCharacterAttributes(paraStart, paraLength, Type.text.getStyle(this.styleContext), true);
            String str = this.getText(paraStart, paraLength);
            int offs = paraStart;
            Matcher matcher = this.pattern.matcher(str);
            int backslash = -1;
            int lastPosition = 0;
            block12: while (matcher.find()) {
                int start = -1;
                int end = -1;
                int token = -1;
                int size = matcher.groupCount();
                for (int i = 1; i <= size; ++i) {
                    start = matcher.start(i);
                    if (start < 0) continue;
                    end = matcher.end(i);
                    token = i;
                    break;
                }
                if (lastPosition >= 0) {
                    this.setCharacterAttributes(offs + lastPosition, start - lastPosition, current.getStyle(this.styleContext), true);
                }
                lastPosition = end;
                switch (token) {
                    case 1: {
                        if (current == Type.comment_block) break;
                        current = Type.text;
                        break;
                    }
                    case 3: {
                        if (current == Type.comment_block || current == Type.string) break;
                        current = Type.comment;
                        break;
                    }
                    case 4: {
                        if (current == Type.comment || current == Type.string) break;
                        current = Type.comment_block;
                        break;
                    }
                    case 5: {
                        if (current != Type.comment_block) break;
                        this.setCharacterAttributes(offs + start, end - start, current.getStyle(this.styleContext), true);
                        current = Type.text;
                        continue block12;
                    }
                    case 6: {
                        if (backslash == start - 1) break;
                        if (current == Type.string) {
                            this.setCharacterAttributes(offs + start, end - start, current.getStyle(this.styleContext), true);
                            current = Type.text;
                            continue block12;
                        }
                        if (current == Type.comment || current == Type.comment_block) break;
                        current = Type.string;
                        break;
                    }
                    case 7: {
                        if (current == Type.comment || current == Type.comment_block || current == Type.string) break;
                        current = Type.number;
                        break;
                    }
                    case 8: {
                        if (current == Type.comment || current == Type.comment_block || current == Type.string) break;
                        current = Type.keyword;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        if (current == Type.comment || current == Type.comment_block || current == Type.string) break;
                        current = Type.customKeyword;
                        break;
                    }
                }
                backslash = token == 2 ? start : -1;
                if (current == Type.customKeyword) {
                    this.setCharacterAttributes(offs + start, end - start, this.styleContext.getStyle(this.customKeywords.get(token - 9)), true);
                } else {
                    this.setCharacterAttributes(offs + start, end - start, current.getStyle(this.styleContext), true);
                }
                if (current != Type.number && current != Type.keyword && current != Type.customKeyword) continue;
                current = Type.text;
            }
            this.setCharacterAttributes(offs + lastPosition, str.length() - lastPosition, current.getStyle(this.styleContext), true);
            return current;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Type.text;
        }
    }

    static {
        keywords.add("abstract");
        keywords.add("boolean");
        keywords.add("break");
        keywords.add("byte");
        keywords.add("byvalue");
        keywords.add("case");
        keywords.add("cast");
        keywords.add("catch");
        keywords.add("char");
        keywords.add("class");
        keywords.add("const");
        keywords.add("continue");
        keywords.add("default");
        keywords.add("do");
        keywords.add("double");
        keywords.add("extends");
        keywords.add("else");
        keywords.add("false");
        keywords.add("final");
        keywords.add("finally");
        keywords.add("float");
        keywords.add("for");
        keywords.add("future");
        keywords.add("generic");
        keywords.add("if");
        keywords.add("implements");
        keywords.add("import");
        keywords.add("inner");
        keywords.add("instanceof");
        keywords.add("int");
        keywords.add("interface");
        keywords.add("long");
        keywords.add("native");
        keywords.add("new");
        keywords.add("null");
        keywords.add("operator");
        keywords.add("outer");
        keywords.add("package");
        keywords.add("private");
        keywords.add("protected");
        keywords.add("public");
        keywords.add("rest");
        keywords.add("return");
        keywords.add("short");
        keywords.add("static");
        keywords.add("super");
        keywords.add("switch");
        keywords.add("synchronized");
        keywords.add("this");
        keywords.add("throw");
        keywords.add("throws");
        keywords.add("transient");
        keywords.add("true");
        keywords.add("try");
        keywords.add("var");
        keywords.add("void");
        keywords.add("volatile");
        keywords.add("while");
        keywords.add("String");
    }

    static enum Type {
        text(null),
        comment(new Color(1201208), false, true),
        comment_block(new Color(1201208), false, true),
        keyword(new Color(128), true, false),
        number(Color.RED),
        string(Color.BLUE),
        customKeyword(null, false, true);

        private SimpleAttributeSet defaultStyle = new SimpleAttributeSet();

        private Type(Color color) {
            this(color, false, false);
        }

        private Type(Color color, boolean bold, boolean italic) {
            if (color != null) {
                StyleConstants.setForeground(this.defaultStyle, color);
            }
            if (bold) {
                StyleConstants.setBold(this.defaultStyle, true);
            }
            if (italic) {
                StyleConstants.setItalic(this.defaultStyle, true);
            }
            this.defaultStyle.addAttribute(StyleConstants.NameAttribute, this.name());
        }

        public Style getStyle(StyleContext ctx) {
            return ctx.getStyle(this.name());
        }
    }
}

