/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGCalendarButton;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.license.client.DefaultOrder;
import ru.bitel.bgbilling.modules.license.client.DefaultOrdersPanel;
import ru.bitel.bgbilling.modules.license.common.bean.OrderType;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.xml.JAXBUtils;

public class DefaultOrderEditor
extends BGPanel {
    private int id;
    private BGComboBox<ComboBoxItem> component = new BGComboBox();
    private BGComboBox<ComboBoxItem> type = new BGComboBox();
    private BGTextField term = new BGTextField();
    private BGTextField count = new BGTextField();
    private JCheckBox unlimited = new JCheckBox("\u043d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e");
    private BGCalendarButton dateTo = new BGCalendarButton();
    private BGButtonPanelOkCancel okCancelPanel = new BGButtonPanelOkCancel();
    private int mid;

    public DefaultOrderEditor(final DefaultOrdersPanel ordersPanel) {
        this.setLayout(new GridBagLayout());
        this.type.addItem((Object)new ComboBoxItem(OrderType.TEST.getCode(), "\u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439"));
        this.type.addItem((Object)new ComboBoxItem(OrderType.BUY.getCode(), "\u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u044b\u0439"));
        JPanel termPanel = new JPanel(new GridBagLayout());
        termPanel.add((Component)this.term, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        termPanel.add((Component)new JLabel("\u0434\u043d\u0435\u0439"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
        termPanel.add((Component)this.dateTo, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 0, 0), 0, 0));
        JPanel countPanel = new JPanel(new BorderLayout());
        countPanel.add((Component)this.count, "Center");
        countPanel.add((Component)this.unlimited, "East");
        this.add(BGSwingUtilites.wrapBorder(this.component, (String)"\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442"), new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(BGSwingUtilites.wrapBorder((JPanel)countPanel, (String)"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e"), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.add(BGSwingUtilites.wrapBorder(this.type, (String)"\u0422\u0438\u043f"), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.add(BGSwingUtilites.wrapBorder((JPanel)termPanel, (String)"\u0421\u0440\u043e\u043a"), new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.okCancelPanel, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.component.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultOrderEditor.this.componentChanged(DefaultOrderEditor.this.component.getSelectedId());
            }
        });
        this.type.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultOrderEditor.this.typeChanged();
            }
        });
        this.unlimited.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                DefaultOrderEditor.this.setUnlimited(source.isSelected());
            }
        });
        this.term.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent arg0) {
                DefaultOrderEditor.this.dateTo.setText("");
            }
        });
        this.dateTo.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                if ("text".equals(propertyName) && !"".equals(e.getNewValue())) {
                    Calendar cal = ((BGCalendarButton)e.getSource()).getCalendar();
                    DefaultOrderEditor.this.term.setText(String.valueOf(DefaultOrderEditor.this.getDifferenceInDays(new Date(), cal.getTime())));
                }
            }
        });
        this.okCancelPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ordersPanel.stopEdit(e.getActionCommand().equals("ok"));
            }
        });
    }

    public void setModuleId(int mid) {
        this.mid = mid;
    }

    private void componentChanged(String id) {
        if (Utils.notBlankString((String)id)) {
            Request req = new Request();
            req.setModule("license");
            req.setModuleId(this.mid);
            req.setAction("GetProductItem");
            req.setAttribute("id", id);
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc)) {
                ru.bitel.bgbilling.modules.license.common.bean.Component productItem = (ru.bitel.bgbilling.modules.license.common.bean.Component)JAXBUtils.unmarshal((Node)doc, (String)"/data/component", ru.bitel.bgbilling.modules.license.common.bean.Component.class);
                this.setUnlimited(productItem.getUnlimited() == 1);
            }
        }
    }

    private void setFieldsDefaults() {
        this.id = -1;
        this.count.setText("");
        this.term.setText("");
        this.unlimited.setSelected(false);
        this.type.setSelectedIndex(0);
        this.dateTo.setText("");
    }

    private void typeChanged() {
        String id = this.type.getSelectedId();
        if (Integer.valueOf(id) == 0) {
            this.term.setText("");
            this.term.setEditable(true);
            this.dateTo.setEnabled(true);
        } else if (Integer.valueOf(id) == 1) {
            this.term.setText("-");
            this.term.setEditable(false);
            this.dateTo.setEnabled(false);
        }
    }

    private void setUnlimited(boolean value) {
        if (value) {
            this.unlimited.setSelected(true);
            this.count.setText("-");
            this.count.setEnabled(false);
        } else {
            this.unlimited.setSelected(false);
            this.count.setText("");
            this.count.setEnabled(true);
        }
    }

    private int getDifferenceInDays(Date startDate, Date endDate) {
        long start = startDate.getTime();
        long end = endDate.getTime();
        float diff = (float)(end - start) / 8.64E7f;
        int diffDays = (int)diff + 1;
        if (diff > 0.0f) {
            ++diffDays;
        }
        return diffDays;
    }

    public void updateComponents(int productId) {
        Request req = new Request();
        req.setModule("license");
        req.setModuleId(this.mid);
        req.setAction("ProductItemProductList");
        req.setAttribute("product_id", productId);
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildComboBox(this.component, (Node)XMLUtils.selectNode((Node)doc, (String)"/data/list_select"), (String)"");
        }
        this.setFieldsDefaults();
        this.componentChanged(this.component.getSelectedId());
    }

    public void showEditor() {
        this.setFieldsDefaults();
        this.componentChanged(this.component.getSelectedId());
        this.setVisible(true);
    }

    public void showEditor(DefaultOrder component) {
        this.setFieldsDefaults();
        this.id = component.getId();
        this.component.setSelectedId(component.getComponentId());
        if (component.getCount() > 0) {
            this.count.setText(String.valueOf(component.getCount()));
        } else {
            this.setUnlimited(true);
        }
        if (component.getTerm() == 0) {
            this.type.setSelectedIndex(OrderType.BUY.getCode());
        } else {
            this.type.setSelectedIndex(OrderType.TEST.getCode());
            this.term.setText(String.valueOf(component.getTerm()));
        }
        this.setVisible(true);
    }

    public int getEditorId() {
        return this.id;
    }

    public int getCount() {
        int count = this.unlimited.isSelected() ? 0 : Utils.parseInt((String)this.count.getText(), (int)-1);
        return count;
    }

    public int getTerm() {
        int term = Utils.parseInt((String)this.type.getSelectedId(), (int)-1) == OrderType.BUY.getCode() ? 0 : Utils.parseInt((String)this.term.getText(), (int)-1);
        return term;
    }

    public BGComboBox<ComboBoxItem> getComponentsCombo() {
        return this.component;
    }
}

